/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassBytesLoader {
    private static Map jarCache = new HashMap();

    public static URL getClassFileURL(String string) {
        String string2 = string.replace('.', '/') + ".class";
        URL uRL = ClassLoader.getSystemResource(string2);
        if (uRL == null) {
            // empty if block
        }
        return uRL;
    }

    public static byte[] getClassFileBytes(String string) {
        return ClassBytesLoader.getClassFileBytes(ClassBytesLoader.getClassFileURL(string));
    }

    public static byte[] getClassFileBytes(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.getProtocol();
        if (string == null) {
            System.err.println("***Profiler agent critical error: could not get .class file for class " + uRL.toExternalForm() + " in ClassBytesLoader.getClassFileBytes");
            return null;
        }
        try {
            if (string.equals("jar")) {
                return ClassBytesLoader.readJar(uRL);
            }
            if (string.equals("file")) {
                return ClassBytesLoader.readFile(uRL);
            }
            return ClassBytesLoader.readUrl(uRL);
        }
        catch (IOException iOException) {
            System.err.println("*** Profiler agent critical error: caught IOException in ClassBytesLoadergetClassFileBytes: " + iOException);
            iOException.printStackTrace();
            System.err.println("*** End Profiler agent critical error message ---------------------------");
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.println("*** Profiler agent critical error: caught URISyntaxException in ClassBytesLoadergetClassFileBytes: " + uRISyntaxException);
            uRISyntaxException.printStackTrace();
            System.err.println("*** End Profiler agent critical error message ---------------------------");
            return null;
        }
    }

    public static void preloadClasses(boolean bl) {
        ClassBytesLoader.getClassFileBytes("java.lang.Object");
        new FilePermission("*", "read");
        new HashMap().keySet().iterator();
        if (bl) {
            new Deflater();
        }
        try {
            Class.forName("java.io.RandomAccessFile$1");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    private static byte[] readFile(URL uRL) throws IOException, URISyntaxException {
        URI uRI = new URI(uRL.toString());
        File file = new File(uRI);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] byArray = new byte[(int)randomAccessFile.length()];
        randomAccessFile.readFully(byArray);
        randomAccessFile.close();
        return byArray;
    }

    private static byte[] readJar(URL uRL) throws IOException {
        String string = uRL.getFile();
        int n = string.lastIndexOf(33);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 2);
        ZipFile zipFile = (ZipFile)jarCache.get(string2);
        int n2 = 0;
        if (zipFile == null) {
            zipFile = new ZipFile(new File(URI.create(string2)));
            jarCache.put(string2, zipFile);
        }
        ZipEntry zipEntry = zipFile.getEntry(string3);
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        byte[] byArray = new byte[(int)zipEntry.getSize()];
        while (n2 < byArray.length) {
            n2 += inputStream.read(byArray, n2, byArray.length - n2);
        }
        inputStream.close();
        return byArray;
    }

    private static byte[] readUrl(URL uRL) throws IOException {
        int n;
        InputStream inputStream = uRL.openStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

