/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.SAXParser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.ejb.DescriptorHandler;
import org.apache.tools.ant.taskdefs.optional.ejb.EJBDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.EjbJar;
import org.apache.tools.ant.taskdefs.optional.ejb.InnerClassFilenameFilter;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.depend.DependencyAnalyzer;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GenericDeploymentTool
implements EJBDeploymentTool {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final int JAR_COMPRESS_LEVEL = 9;
    protected static final String META_DIR = "META-INF/";
    protected static final String MANIFEST = "META-INF/MANIFEST.MF";
    protected static final String EJB_DD = "ejb-jar.xml";
    public static final String ANALYZER_SUPER = "super";
    public static final String ANALYZER_FULL = "full";
    public static final String ANALYZER_NONE = "none";
    public static final String DEFAULT_ANALYZER = "super";
    public static final String ANALYZER_CLASS_SUPER = "org.apache.tools.ant.util.depend.bcel.AncestorAnalyzer";
    public static final String ANALYZER_CLASS_FULL = "org.apache.tools.ant.util.depend.bcel.FullAnalyzer";
    private EjbJar.Config config;
    private File destDir;
    private Path classpath;
    private String genericJarSuffix = "-generic.jar";
    private Task task;
    private ClassLoader classpathLoader = null;
    private Set addedfiles;
    private DescriptorHandler handler;
    private DependencyAnalyzer dependencyAnalyzer;

    public void setDestdir(File inDir) {
        this.destDir = inDir;
    }

    protected File getDestDir() {
        return this.destDir;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    protected Task getTask() {
        return this.task;
    }

    protected EjbJar.Config getConfig() {
        return this.config;
    }

    protected boolean usingBaseJarName() {
        return this.config.baseJarName != null;
    }

    public void setGenericJarSuffix(String inString) {
        this.genericJarSuffix = inString;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.task.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    protected Path getCombinedClasspath() {
        Path combinedPath = this.classpath;
        if (this.config.classpath != null) {
            if (combinedPath == null) {
                combinedPath = this.config.classpath;
            } else {
                combinedPath.append(this.config.classpath);
            }
        }
        return combinedPath;
    }

    protected void log(String message, int level) {
        this.getTask().log(message, level);
    }

    protected Location getLocation() {
        return this.getTask().getLocation();
    }

    private void createAnalyzer() {
        String analyzer = this.config.analyzer;
        if (analyzer == null) {
            analyzer = "super";
        }
        if (analyzer.equals(ANALYZER_NONE)) {
            return;
        }
        String analyzerClassName = null;
        analyzerClassName = analyzer.equals("super") ? ANALYZER_CLASS_SUPER : (analyzer.equals(ANALYZER_FULL) ? ANALYZER_CLASS_FULL : analyzer);
        try {
            Class<?> analyzerClass = Class.forName(analyzerClassName);
            this.dependencyAnalyzer = (DependencyAnalyzer)analyzerClass.newInstance();
            this.dependencyAnalyzer.addClassPath(new Path(this.task.getProject(), this.config.srcDir.getPath()));
            this.dependencyAnalyzer.addClassPath(this.config.classpath);
        }
        catch (NoClassDefFoundError e) {
            this.dependencyAnalyzer = null;
            this.task.log("Unable to load dependency analyzer: " + analyzerClassName + " - dependent class not found: " + e.getMessage(), 1);
        }
        catch (Exception e) {
            this.dependencyAnalyzer = null;
            this.task.log("Unable to load dependency analyzer: " + analyzerClassName + " - exception: " + e.getMessage(), 1);
        }
    }

    public void configure(EjbJar.Config config) {
        this.config = config;
        this.createAnalyzer();
        this.classpathLoader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileToJar(JarOutputStream jStream, File inputFile, String logicalFilename) throws BuildException {
        FileInputStream iStream = null;
        try {
            if (!this.addedfiles.contains(logicalFilename)) {
                iStream = new FileInputStream(inputFile);
                ZipEntry zipEntry = new ZipEntry(logicalFilename.replace('\\', '/'));
                jStream.putNextEntry(zipEntry);
                byte[] byteBuffer = new byte[2048];
                int count = 0;
                do {
                    jStream.write(byteBuffer, 0, count);
                } while ((count = iStream.read(byteBuffer, 0, byteBuffer.length)) != -1);
                this.addedfiles.add(logicalFilename);
            }
        }
        catch (IOException ioe) {
            this.log("WARNING: IOException while adding entry " + logicalFilename + " to jarfile from " + inputFile.getPath() + " " + ioe.getClass().getName() + "-" + ioe.getMessage(), 1);
        }
        finally {
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (IOException closeException) {}
            }
        }
    }

    protected DescriptorHandler getDescriptorHandler(File srcDir) {
        DescriptorHandler h = new DescriptorHandler(this.getTask(), srcDir);
        this.registerKnownDTDs(h);
        Iterator i = this.getConfig().dtdLocations.iterator();
        while (i.hasNext()) {
            EjbJar.DTDLocation dtdLocation = (EjbJar.DTDLocation)i.next();
            h.registerDTD(dtdLocation.getPublicId(), dtdLocation.getLocation());
        }
        return h;
    }

    protected void registerKnownDTDs(DescriptorHandler handler) {
    }

    public void processDescriptor(String descriptorFileName, SAXParser saxParser) {
        this.checkConfiguration(descriptorFileName, saxParser);
        try {
            File jarFile;
            this.handler = this.getDescriptorHandler(this.config.srcDir);
            Hashtable ejbFiles = this.parseEjbFiles(descriptorFileName, saxParser);
            this.addSupportClasses(ejbFiles);
            String baseName = this.getJarBaseName(descriptorFileName);
            String ddPrefix = this.getVendorDDPrefix(baseName, descriptorFileName);
            File manifestFile = this.getManifestFile(ddPrefix);
            if (manifestFile != null) {
                ejbFiles.put(MANIFEST, manifestFile);
            }
            ejbFiles.put("META-INF/ejb-jar.xml", new File(this.config.descriptorDir, descriptorFileName));
            this.addVendorFiles(ejbFiles, ddPrefix);
            this.checkAndAddDependants(ejbFiles);
            if (this.config.flatDestDir && baseName.length() != 0) {
                int startName = baseName.lastIndexOf(File.separator);
                if (startName == -1) {
                    startName = 0;
                }
                int endName = baseName.length();
                baseName = baseName.substring(startName, endName);
            }
            if (this.needToRebuild(ejbFiles, jarFile = this.getVendorOutputJarFile(baseName))) {
                this.log("building " + jarFile.getName() + " with " + String.valueOf(ejbFiles.size()) + " files", 2);
                String publicId = this.getPublicId();
                this.writeJar(baseName, jarFile, ejbFiles, publicId);
            } else {
                this.log(jarFile.toString() + " is up to date.", 3);
            }
        }
        catch (SAXException se) {
            String msg = "SAXException while parsing '" + descriptorFileName + "'. This probably indicates badly-formed XML." + "  Details: " + se.getMessage();
            throw new BuildException(msg, se);
        }
        catch (IOException ioe) {
            String msg = "IOException while parsing'" + descriptorFileName + "'.  This probably indicates that the descriptor" + " doesn't exist. Details: " + ioe.getMessage();
            throw new BuildException(msg, ioe);
        }
    }

    protected void checkConfiguration(String descriptorFileName, SAXParser saxParser) throws BuildException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable parseEjbFiles(String descriptorFileName, SAXParser saxParser) throws IOException, SAXException {
        FileInputStream descriptorStream = null;
        Hashtable ejbFiles = null;
        try {
            descriptorStream = new FileInputStream(new File(this.config.descriptorDir, descriptorFileName));
            saxParser.parse(new InputSource(descriptorStream), (HandlerBase)this.handler);
            ejbFiles = this.handler.getFiles();
        }
        finally {
            if (descriptorStream != null) {
                try {
                    descriptorStream.close();
                }
                catch (IOException closeException) {}
            }
        }
        return ejbFiles;
    }

    protected void addSupportClasses(Hashtable ejbFiles) {
        Project project = this.task.getProject();
        Iterator i = this.config.supportFileSets.iterator();
        while (i.hasNext()) {
            FileSet supportFileSet = (FileSet)i.next();
            File supportBaseDir = supportFileSet.getDir(project);
            DirectoryScanner supportScanner = supportFileSet.getDirectoryScanner(project);
            supportScanner.scan();
            String[] supportFiles = supportScanner.getIncludedFiles();
            for (int j = 0; j < supportFiles.length; ++j) {
                ejbFiles.put(supportFiles[j], new File(supportBaseDir, supportFiles[j]));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getJarBaseName(String descriptorFileName) {
        String baseName = "";
        if (this.config.namingScheme.getValue().equals("basejarname")) {
            String canonicalDescriptor = descriptorFileName.replace('\\', '/');
            int index = canonicalDescriptor.lastIndexOf(47);
            if (index == -1) return baseName + this.config.baseJarName;
            baseName = descriptorFileName.substring(0, index + 1);
            return baseName + this.config.baseJarName;
        }
        if (this.config.namingScheme.getValue().equals("descriptor")) {
            int lastSeparatorIndex = descriptorFileName.lastIndexOf(File.separator);
            int endBaseName = -1;
            endBaseName = lastSeparatorIndex != -1 ? descriptorFileName.indexOf(this.config.baseNameTerminator, lastSeparatorIndex) : descriptorFileName.indexOf(this.config.baseNameTerminator);
            if (endBaseName == -1) throw new BuildException("Unable to determine jar name from descriptor \"" + descriptorFileName + "\"");
            return descriptorFileName.substring(0, endBaseName);
        }
        if (this.config.namingScheme.getValue().equals("directory")) {
            File descriptorFile = new File(this.config.descriptorDir, descriptorFileName);
            String path = descriptorFile.getAbsolutePath();
            int lastSeparatorIndex = path.lastIndexOf(File.separator);
            if (lastSeparatorIndex == -1) {
                throw new BuildException("Unable to determine directory name holding descriptor");
            }
            String dirName = path.substring(0, lastSeparatorIndex);
            int dirSeparatorIndex = dirName.lastIndexOf(File.separator);
            if (dirSeparatorIndex == -1) return dirName;
            dirName = dirName.substring(dirSeparatorIndex + 1);
            return dirName;
        }
        if (!this.config.namingScheme.getValue().equals("ejb-name")) return baseName;
        return this.handler.getEjbName();
    }

    public String getVendorDDPrefix(String baseName, String descriptorFileName) {
        String ddPrefix = null;
        if (this.config.namingScheme.getValue().equals("descriptor")) {
            ddPrefix = baseName + this.config.baseNameTerminator;
        } else if (this.config.namingScheme.getValue().equals("basejarname") || this.config.namingScheme.getValue().equals("ejb-name") || this.config.namingScheme.getValue().equals("directory")) {
            String canonicalDescriptor = descriptorFileName.replace('\\', '/');
            int index = canonicalDescriptor.lastIndexOf(47);
            ddPrefix = index == -1 ? "" : descriptorFileName.substring(0, index + 1);
        }
        return ddPrefix;
    }

    protected void addVendorFiles(Hashtable ejbFiles, String ddPrefix) {
    }

    File getVendorOutputJarFile(String baseName) {
        return new File(this.destDir, baseName + this.genericJarSuffix);
    }

    protected boolean needToRebuild(Hashtable ejbFiles, File jarFile) {
        if (jarFile.exists()) {
            long lastBuild = jarFile.lastModified();
            Iterator fileIter = ejbFiles.values().iterator();
            while (fileIter.hasNext()) {
                File currentFile = (File)fileIter.next();
                if (lastBuild >= currentFile.lastModified()) continue;
                this.log("Build needed because " + currentFile.getPath() + " is out of date", 3);
                return true;
            }
            return false;
        }
        return true;
    }

    protected String getPublicId() {
        return this.handler.getPublicId();
    }

    protected File getManifestFile(String prefix) {
        File manifestFile = new File(this.getConfig().descriptorDir, prefix + "manifest.mf");
        if (manifestFile.exists()) {
            return manifestFile;
        }
        if (this.config.manifest != null) {
            return this.config.manifest;
        }
        return null;
    }

    protected void writeJar(String baseName, File jarfile, Hashtable files, String publicId) throws BuildException {
        ZipOutputStream jarStream = null;
        try {
            if (this.addedfiles == null) {
                this.addedfiles = new HashSet();
            } else {
                this.addedfiles.clear();
            }
            if (jarfile.exists()) {
                jarfile.delete();
            }
            jarfile.getParentFile().mkdirs();
            jarfile.createNewFile();
            InputStream in = null;
            Manifest manifest = null;
            try {
                File manifestFile = (File)files.get(MANIFEST);
                if (manifestFile != null && manifestFile.exists()) {
                    in = new FileInputStream(manifestFile);
                } else {
                    String defaultManifest = "/org/apache/tools/ant/defaultManifest.mf";
                    in = this.getClass().getResourceAsStream(defaultManifest);
                    if (in == null) {
                        throw new BuildException("Could not find default manifest: " + defaultManifest);
                    }
                }
                manifest = new Manifest(in);
            }
            catch (IOException e) {
                throw new BuildException("Unable to read manifest", e, this.getLocation());
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            jarStream = new JarOutputStream((OutputStream)new FileOutputStream(jarfile), manifest);
            jarStream.setMethod(8);
            Iterator entryIterator = files.keySet().iterator();
            while (entryIterator.hasNext()) {
                String entryName = (String)entryIterator.next();
                if (entryName.equals(MANIFEST)) continue;
                File entryFile = (File)files.get(entryName);
                this.log("adding file '" + entryName + "'", 3);
                this.addFileToJar((JarOutputStream)jarStream, entryFile, entryName);
                InnerClassFilenameFilter flt = new InnerClassFilenameFilter(entryFile.getName());
                File entryDir = entryFile.getParentFile();
                String[] innerfiles = entryDir.list(flt);
                if (innerfiles == null) continue;
                int n = innerfiles.length;
                for (int i = 0; i < n; ++i) {
                    int entryIndex = entryName.lastIndexOf(entryFile.getName()) - 1;
                    entryName = entryIndex < 0 ? innerfiles[i] : entryName.substring(0, entryIndex) + File.separatorChar + innerfiles[i];
                    entryFile = new File(this.config.srcDir, entryName);
                    this.log("adding innerclass file '" + entryName + "'", 3);
                    this.addFileToJar((JarOutputStream)jarStream, entryFile, entryName);
                }
            }
        }
        catch (IOException ioe) {
            String msg = "IOException while processing ejb-jar file '" + jarfile.toString() + "'. Details: " + ioe.getMessage();
            throw new BuildException(msg, ioe);
        }
        finally {
            if (jarStream != null) {
                try {
                    jarStream.close();
                }
                catch (IOException closeException) {}
            }
        }
    }

    protected void checkAndAddDependants(Hashtable checkEntries) throws BuildException {
        if (this.dependencyAnalyzer == null) {
            return;
        }
        this.dependencyAnalyzer.reset();
        Iterator i = checkEntries.keySet().iterator();
        while (i.hasNext()) {
            String entryName = (String)i.next();
            if (!entryName.endsWith(".class")) continue;
            String className = entryName.substring(0, entryName.length() - ".class".length());
            className = className.replace(File.separatorChar, '/');
            className = className.replace('/', '.');
            this.dependencyAnalyzer.addRootClass(className);
        }
        Enumeration e = this.dependencyAnalyzer.getClassDependencies();
        while (e.hasMoreElements()) {
            String classname = (String)e.nextElement();
            String location = classname.replace('.', File.separatorChar) + ".class";
            File classFile = new File(this.config.srcDir, location);
            if (!classFile.exists()) continue;
            checkEntries.put(location, classFile);
            this.log("dependent class: " + classname + " - " + classFile, 3);
        }
    }

    protected ClassLoader getClassLoaderForBuild() {
        if (this.classpathLoader != null) {
            return this.classpathLoader;
        }
        Path combinedClasspath = this.getCombinedClasspath();
        this.classpathLoader = combinedClasspath == null ? this.getClass().getClassLoader() : this.getTask().getProject().createClassLoader(combinedClasspath);
        return this.classpathLoader;
    }

    public void validateConfigured() throws BuildException {
        if (this.destDir == null || !this.destDir.isDirectory()) {
            String msg = "A valid destination directory must be specified using the \"destdir\" attribute.";
            throw new BuildException(msg, this.getLocation());
        }
    }
}

