package com.sun.cc.platform.user;

import java.rmi.RemoteException;

import java.io.PrintStream;

import java.util.ArrayList;
import java.util.List;

import java.util.logging.*;

import javax.xml.rpc.Stub;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPException;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;

public final class UserServiceClientImpl implements UserServiceClient {

    public static final String PROFILE_URN = "urn:cns_platform_0.5_profile";
    public static final String LEGAL_URN
        = "urn:cns_platform_0.5_legalagreement";

    private final String endpoint;
    private static final String FAKE_TOKEN_FOR_BR
        = "MY_VOICE_IS_MY_PASSPORT_VERIFY_MY_FAKE_TOKEN";

    private PrintStream printStream;

    private final Logger log = Logger.getLogger(getClass().getName());

    protected UserServiceClientImpl(String theEndpoint) {
        endpoint = theEndpoint;
        log.fine("UserServiceClientImpl.init() endpoint=" + endpoint);
    }

    public boolean isEndpointCompatible() {
        try {
            SOAPFactory factory = SOAPFactory.newInstance();
            SOAPElement xsd = factory.createElement("xsd");
            
            // do we retrieve during validation ?
            Schema[] retrieveUrns
                = new Schema[] { new Schema(PROFILE_URN, xsd) };
            
            
            Schema[] modifyUrns = new Schema[] { new Schema(PROFILE_URN, xsd), 
                                                 new Schema(LEGAL_URN, xsd) };
            
            UserInformationService_PortType port = getService();
            MetaInformation information = port.query(retrieveUrns, modifyUrns);
            
            return (information.getCanRetrieve().length == 1 
                    && information.getCanUpdate().length == 2);
        } catch (Exception e) {
            return false;
        }
    }
        
    public String validate(String username, String password) 
        throws RemoteException {
        try {
            return getService().validate(username, password);
        } catch (Exception e) {
            log.severe("Error validating user with service: " + e);
            //throw new RemoteException("Error validating user with service", e);
            return null;
        }
    }

    public String registerUser(String username, String password,
                               String firstName, String lastName, 
                               String companyName,
                               String address1, String address2, 
                               String address3, String city, String state, 
                               String postalCode, String country, 
                               String phone, String email, 
                               String preferredLanguage,
                               String jobTitle, boolean maySunContact, 
                               String touAccepted, 
                               String touVersion,
                               String touCountryCode,
                               String touLanguageCode,
                               String application) 
        throws RemoteException, DuplicateAccountException {
        try {
            Information profileInfo = createUserProfile(username, 
                                                        firstName, lastName, 
                                                        companyName, 
                                                        address1, address2, 
                                                        address3, 
                                                        city, state, 
                                                        postalCode, country, 
                                                        email, phone, 
                                                        preferredLanguage,
                                                        jobTitle,
                                                        maySunContact,
                                                        password);
            
            Information licenseInfo
                = createLicenseAcceptance(new String[] { touAccepted }, 
                                          new String[] { touVersion }, 
                                          new String[] { touCountryCode },
                                          new String[] { touLanguageCode }, 
                                          application);
            
            return doRegisterUser(profileInfo, licenseInfo, username);
        } catch (SOAPException soape) {
            log.severe("error creating SOAP documents: " + soape);
        }
        return null;
    }


    public String registerUser(String username, String password,
                               String firstName, String lastName, 
                               String companyName,
                               String address1, String address2, 
                               String address3, String city, String state, 
                               String postalCode, String country, 
                               String phone, String email, 
                               String preferredLanguage,
                               String jobTitle, boolean maySunContact, 
                               String touAccepted, 
                               String touVersion,
                               String touCountryCode,
                               String touLanguageCode,
                               String licenseAccepted, 
                               String licenseVersion,
                               String licenseCountryCode,
                               String licenseLanguageCode,
                               String application) 
        throws RemoteException, DuplicateAccountException {        
        try {
            Information profileInfo = createUserProfile(username, 
                                                        firstName, lastName, 
                                                        companyName, 
                                                        address1, address2, 
                                                        address3, city, state, 
                                                        postalCode, country, 
                                                        email, phone, 
                                                        preferredLanguage,
                                                        jobTitle,
                                                        maySunContact,
                                                        password);
            Information licenseInfo
                = createLicenseAcceptance(new String[] { licenseAccepted, 
                                                         touAccepted }, 
                                          new String[] { licenseVersion,
                                                         touVersion}, 
                                          new String[] { licenseCountryCode, 
                                                         touCountryCode },
                                          new String[] { licenseLanguageCode,
                                                         touLanguageCode}, 
                                          application);


            return doRegisterUser(profileInfo, licenseInfo, username);
        } catch (SOAPException soape) {
            log.severe("error creating SOAP documents: " + soape);
        }
        return null;
    }   

    

    public String validateAndAccept(String username, String password,
                                    String touAccepted, 
                                    String touVersion,
                                    String touLanguageCode,
                                    String touCountryCode,
                                    String licenseAccepted, 
                                    String licenseVersion,
                                    String licenseLanguageCode,
                                    String licenseCountryCode,
                                    String application) 
        throws RemoteException {
        log.info("validateAndAccept: " + username);
        String token = validate(username, password);

        if (token == null) { return null; }
        
        UserInformationService_PortType port = null;
        try {
            port = getService();
        } catch (Exception e) {
            log.severe("Exception caught contacting service: " + e);
            throw new RemoteException("Error connecting to user service", e);
        }
        
        try {
            Information licenseInfo
                = createLicenseAcceptance(new String[] { licenseAccepted, 
                                                         touAccepted }, 
                                          new String[] { licenseVersion,
                                                         touVersion}, 
                                          new String[] { licenseCountryCode, 
                                                         touCountryCode },
                                          new String[] { licenseLanguageCode,
                                                         touLanguageCode}, 
                                          application);
            port.store(token, username, 
                       new Information[] { licenseInfo });
            return token;
        } catch (UnknownSourceFault usf) {
            log.severe("Unknown source, service is probably incompatible: " 
                       + usf);
        } catch (ModificationFailure mf) { 
            log.severe("tried to modify, we expected to be creating data: " 
                       + mf);
        } catch (AccessDeniedFault adf) { 
            log.severe("access denied after registration, this is bad: " 
                       + adf);
        } catch (SOAPException soape) {
            log.severe("error creating SOAP documents: " + soape);
        } catch (CreationFailure cf) { 
            log.severe("Something catastrophic happened: " + cf);
        } catch (DuplicateFault df) { 
            log.severe("SHOULDNT HAPPEN Duplicate account: " + df);
        }
        return null;
    }

    private String doRegisterUser(Information profileInfo, 
                                  Information licenseInfo, String username) 
        throws RemoteException, DuplicateAccountException {
        log.fine("registering..." + username);
        String token = null;
        UserInformationService_PortType port = null;
        try {
            port = getService();
        } catch (Exception e) {
            log.severe("Exception caught contacting service: " + e);
            throw new RemoteException("Error connecting to user service", e);
        }
        
        try {
            StoreResponse response
                = port.store(null, null, 
                             new Information[] { profileInfo });
            Information[] infoArr = response.getInformation();
            for (int i = 0; i < infoArr.length; i++) {
                token = findToken(infoArr[i].getIdentifier());
                if (token != null) { break; }
            }
            
            if (token == null) { return null; }
            port.store(token, username, 
                       new Information[] { licenseInfo });
            return token;
        } catch (UnknownSourceFault usf) {
            log.severe("Unknown source, service is probably incompatible: " 
                       + usf);
        } catch (ModificationFailure mf) { 
            log.severe("tried to modify, we expected to be creating data: " 
                       + mf);
        } catch (AccessDeniedFault adf) { 
            log.severe("access denied after registration, this is bad: " 
                       + adf);
        } catch (CreationFailure cf) { 
            log.severe("Something catastrophic happened: " + cf);
        } catch (DuplicateFault df) { 
            //log.severe("Duplicate account: " + df);
            throw new DuplicateAccountException(username, df);
        }
        return null;
    }

    protected String findToken(Node identifier) {
        Node child = identifier.getFirstChild();
        if (child == null) { return null; }
        
        String name = child.getLocalName();
        if ("token".equals(name)) {
            Node tokenNode = child.getFirstChild();
            if (tokenNode != null 
                && tokenNode.getNodeType() == Node.TEXT_NODE) {
                return tokenNode.getNodeValue();
            }
        }
        return findToken(child);
    }

    public void setPrintStream(PrintStream thePrintStream) {
        printStream = thePrintStream;
    }

    //  COPIED FROM OPERATIONS IN com.sun.cc.platform.client
    
    private Information createLicenseAcceptance(String[] license, 
                                                String[] version, 
                                                String[] country, 
                                                String[] language, 
                                                String application) 
        throws SOAPException {
        
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement data = factory.createElement("data");

        // XSD Says we don't need this, however it gets parsed
        // its probably an issue in the WebService lifecycle
        // or mis-documenation for the web-service  -  yes that was a funny
        
        // either way, need to verify with the legalagreement.xsd author

        SOAPElement identifier = factory.createElement("identifier");

        SOAPElement legalIdentifier
            = identifier.addChildElement("LegalAgreementRetrieveKey", 
                                         "la", LEGAL_URN);
        legalIdentifier.setAttribute("country", country[0]);
        legalIdentifier.setAttribute("language", language[0]);
        SOAPElement agreementList
            = legalIdentifier.addChildElement("agreementList", "la");
        SOAPElement agreement
            = agreementList.addChildElement("agreement", "la");
        agreement.addTextNode(license[0]);


        // populate data
        SOAPElement legal = data.addChildElement("LegalAgreementModifyData", 
                                                 "la", LEGAL_URN);
        SOAPElement applicationElement
            = legal.addChildElement("application", "la");
        applicationElement.addTextNode(application);
        
        // we are accepting the TOU right now, this millisecond 
        SOAPElement responseDate
            = legal.addChildElement("responseDate", "la");
        responseDate.setAttribute("timestamp", 
                                  "" + System.currentTimeMillis());

        SOAPElement responses = legal.addChildElement("responses", "la");

        for (int i = 0; i < license.length; i++) {
            // we will only responding to 1 legal agreement.
            SOAPElement legalResponse
                = responses.addChildElement("response", "la");
            
            // we accept, woot!
            legalResponse.setAttribute("accepted", "true");
            
            // okay, now tell us what we accepted.
            SOAPElement agreementSelector 
                = legalResponse.addChildElement("LegalAgreementSelector", 
                                            "la", LEGAL_URN);
            agreementSelector.setAttribute("name", license[i]);
            agreementSelector.setAttribute("version", version[i]);
            agreementSelector.setAttribute("country", country[i]);
            agreementSelector.setAttribute("language", language[i]);
        }
        
        if (printStream != null) {
            printStream.println();
            printStream.println();
            printStream.println("License Aggreement:");
            printStream.println(elementToString(identifier));
            printStream.println(elementToString(data));
        }

        return new Information(LEGAL_URN, identifier, data);
    }

    // NOTE: street 2 and 3 are ignored.
    private Information createUserProfile(String uname, 
                                          String fname, String lname, 
                                          String company, String street1, 
                                          String street2, String street3, 
                                          String city, String state, 
                                          String zip, String country, 
                                          String email, String phone, 
                                          String preferredLanguage,
                                          String jobTitle, 
                                          boolean maySunContact, 
                                          String pass) 
        throws SOAPException {
        
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement identifier = factory.createElement("identifier");
        SOAPElement data = factory.createElement("data");

        // profile doesn't really check for name spaces, but we add them anyway
        SOAPElement profile
            = data.addChildElement("profile", "ns", PROFILE_URN);
        profile.setAttribute("identifier", uname);
        
        appendProfileElement(profile, "firstName", fname);
        appendProfileElement(profile, "lastName", lname);
        appendProfileElement(profile, "company", company);
        appendProfileElement(profile, "address1", street1);
        appendProfileElement(profile, "address2", street2);
        appendProfileElement(profile, "address3", street3);
        appendProfileElement(profile, "city", city);
        appendProfileElement(profile, "state", state);
        appendProfileElement(profile, "zip", zip);
        appendProfileElement(profile, "country", country);
        appendProfileElement(profile, "email", email);
        appendProfileElement(profile, "telephone", phone);
        appendProfileElement(profile, "preferredLanguage", preferredLanguage);
        appendProfileElement(profile, "jobtitle", jobTitle);
        appendProfileElement(profile, "maySunContact", maySunContact);
        appendProfileElement(profile, "password", pass);
        
        if (printStream != null) {
            printStream.println();
            printStream.println();
            printStream.println("User Profile Registration Data:");
            printStream.println(elementToString(data));
        }

        return new Information(PROFILE_URN, identifier, data);
    }
    
    private void appendProfileElement(SOAPElement profile, 
                                      String elementName, boolean value) 
        throws SOAPException {
        appendProfileElement(profile, elementName, Boolean.toString(value));
    }

    private void appendProfileElement(SOAPElement profile, 
                                      String elementName, String value) 
        throws SOAPException {
        if (value != null && ! value.equals("")) {
            SOAPElement element = profile.addChildElement(elementName, "ns");
            element.addTextNode(value);
        }
    }

    private StringBuffer elementToString(Node node) {
        return elementToString(node, "\n", 
                               new StringBuffer(), new ArrayList());
    }

    private StringBuffer elementToString(Node node, 
                                         String indent, 
                                         StringBuffer sb,
                                         List knownNamespaces) {
        // indent so it looks pretty
        sb.append(indent);
        if (node.getNodeType() == Node.TEXT_NODE) {
            // add the text content.
            sb.append(node.getNodeValue());
        } else {
            
            // open
            appendOpen(sb, node, knownNamespaces);

            // do the kids
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); i++) {
                elementToString(children.item(i), indent + "\t", 
                                sb, knownNamespaces);
            }

            // make it pretty
            sb.append(indent);

            // close up shop
            appendClose(sb, node);
        }

        // be nice and give it back
        return sb;
    }

    private void appendClose(StringBuffer sb, Node node) {
        sb.append("</").append(node.getNodeName()).append(">");
    }

    private void appendOpen(StringBuffer sb, Node node, List knownNS) {
        sb.append("<");
        sb.append(node.getNodeName());            
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); i++) {
            Node attr = attributes.item(i);
            String attrName = attr.getNodeName();
            String attrValue = attr.getNodeValue();
            if (attrName.startsWith("xmlns")) {
                if (!knownNS.contains(attrValue)) {
                    knownNS.add(attrValue);
                    appendAttribute(sb, attrName, attrValue);
                } 
            } else {
                appendAttribute(sb, attrName, attrValue);
            }
        }
        sb.append(">");
    }
    
    private void appendAttribute(StringBuffer sb, String name, String value) {
        sb.append(" ").append(name).append("=\"").append(value).append("\"");
    }

    private UserInformationService_PortType getService() 
        throws Exception {
        UserInformationService_Service theService 
            = new UserInformationService_Service_Impl();
        UserInformationService_PortType port 
            = theService.getUserInformationServicePort();
        Stub theStub = (Stub)port;
        theStub._setProperty(Stub.ENDPOINT_ADDRESS_PROPERTY, endpoint);
        return port;
    }

    public String registerUser(String username, String password,
                               String firstName, String lastName, 
                               String companyName,
                               String address1, String address2, 
                               String address3, String city, String state, 
                               String postalCode, String country, 
                               String phone, String email, 
                               String preferredLanguage,
                               String jobTitle, boolean maySunContact, 
                               boolean touAccepted, 
                               boolean licenseAccepted, 
                               String application) 
        throws RemoteException, DuplicateAccountException {
        
        if (touAccepted && licenseAccepted) {
            return registerUser(username, password, firstName, lastName, 
                                companyName, address1, address2, address3, 
                                city, state, postalCode, country, phone, 
                                email, preferredLanguage, 
                                jobTitle, maySunContact,
                                "SMI_TOU", "2.0", "US", "en", 
                                "BCL", "1.1", "US", "en", 
                                application);
        } 

        if (touAccepted) {
            return registerUser(username, password, firstName, lastName, 
                                companyName, address1, address2, address3, 
                                city, state, postalCode, country, phone, 
                                email, preferredLanguage, 
                                jobTitle, maySunContact,
                                "SMI_TOU", "2.0", "US", "en",
                                application);
        }

        if (licenseAccepted) {
            return registerUser(username, password, firstName, lastName, 
                                companyName, address1, address2, address3, 
                                city, state, postalCode, country, phone, 
                                email, preferredLanguage, 
                                jobTitle, maySunContact,
                                "BCL", "1.1", "US", "en", 
                                application);
        }

        return null;
    }

    public String validateAndAccept(String username, String password,
                                    boolean touAcceptedAndBL,  
                                    String application) 
        throws RemoteException {

        if (touAcceptedAndBL) {
            return validateAndAccept(username, password,
                                     "SMI_TOU", "2.0", "US", "en", 
                                     "BCL", "1.1", "US", "en", 
                                     application);
        }
        
        return null;
    }
}
