#!/bin/sh
#
# Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)runwlabel.ksh	1.1	07/10/17 SMI"
#
#
# Usage:
# runwlabel "my-label" my-program
#

[ ! -x /usr/sbin/zoneadm ] && exit 0    # SUNWzoneu not installed

PATH=/usr/sbin:/usr/bin; export PATH

# Get the zone path associated with the "my-label" zone
# Remove the trailing "/root"
zonepath=`getzonepath "$1" | sed -e 's/\/root$//'`
progname="$2"

# Find the zone name that is associated with this zone path
for zone in `zoneadm list -pi | nawk -F: -v zonepath=${zonepath} '{
	if ("$4" == "${zonepath}") {
		print $2
	}
}'`; do
	# Run the specified command in the matching zone
	zlogin ${zone} ${progname}
	done
exit
