/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SHAREFS_SHAREFS_H
#define	_SHAREFS_SHAREFS_H

#pragma ident	"@(#)sharefs.h	1.1	08/02/14 SMI"

/*
 * This header provides service for the sharefs module.
 */

#include <sys/modctl.h>
#include <sys/vfs.h>
#include <sys/vnode.h>
#include <sys/gfs.h>
#include <sharefs/share.h>
#include <sharefs/sharetab.h>

#ifdef __cplusplus
extern "C" {
#endif

#define	SHAREFS_ROOT	"/etc/dfs"
#define	SHAREFS_BASE	"sharetab"

/*
 * Lengths of strings.
 */
typedef struct sharefs_lens {
	int	shl_path;
	int	shl_res;
	int	shl_fstype;
	int	shl_opts;
	int	shl_descr;
} sharefs_lens_t;

/*
 * VFS data object
 */
typedef struct sharefs_vfs {
	vnode_t	*sharefs_vfs_root;
} sharefs_vfs_t;

#define	SHAREFS_NAME_MAX	MAXNAMELEN

/*
 * The lock ordering whenever sharefs_lock and sharetab_lock both
 * need to be held is: sharefs_lock and then sharetab_lock.
 */
extern krwlock_t	sharefs_lock;	/* lock for the vnode ops */
extern sharetab_t	*sharefs_sharetab;	/* The sharetab. */

extern uint_t		sharetab_count;	/* How many shares? */
extern krwlock_t	sharetab_lock;	/* lock for the cached sharetab */
extern size_t		sharetab_size;	/* How big is the sharetab file? */

extern timestruc_t	sharetab_mtime;	/* Last mod to sharetab */
extern timestruc_t	sharetab_snap_time;	/* Last snap */
extern uint_t		sharetab_generation;	/* Which copy is it? */

#define	SHAREFS_INO_FILE	0x80

extern vnode_t *sharefs_create_root_file(vfs_t *);

/*
 * Sharetab file
 *
 * Note that even though the sharetab code does not explictly
 * use 'sharefs_file', it is required by GFS that the first
 * field of the private data be a gfs_file_t.
 */
typedef struct shnode_t {
	gfs_file_t	sharefs_file;		/* gfs file */
	char		*sharefs_snap;		/* snapshot of the share */
	size_t		sharefs_size;		/* size of the snapshot */
	uint_t		sharefs_count;		/* number of shares */
	uint_t		sharefs_refs;		/* reference count */
	uint_t		sharefs_real_vp;	/* Are we a real or snap */
	uint_t		sharefs_generation;	/* Which copy are we? */
	timestruc_t	sharefs_snap_time;	/* When were we modded? */
} shnode_t;

/*
 * Some conversion macros:
 */
#define	VTOSH(vp)	((shnode_t *)((vp)->v_data))

extern const fs_operation_def_t	sharefs_tops_data[];
extern vnodeops_t		*sharefs_ops_data;

extern void sharefs_data_init(void);

extern void sharefs_sharetab_init(void);

#ifdef __cplusplus
}
#endif

#endif /* !_SHAREFS_SHAREFS_H */
