/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SYS_SCSI_TARGETS_SMP_H
#define	_SYS_SCSI_TARGETS_SMP_H

#pragma ident	"@(#)smp.h	1.1	08/05/21 SMI"

#include <sys/types.h>
#include <sys/scsi/scsi.h>

#ifdef	__cplusplus
extern "C" {
#endif

#if defined(_KERNEL)

/*
 * smp_open_flag: field indicating open smp instance.
 *	0 = closed, 1 = shared open, 2 = exclusive open.
 */
#define	SMP_CLOSED	0
#define	SMP_SOPENED	1
#define	SMP_EXOPENED	2

typedef struct smp_state {
	struct smp_device *smp_dev;		/* pointer to smp_device */
	kmutex_t smp_mutex;			/* mutex */
	uint32_t smp_open_flag;		/* open flag */
} smp_state_t;

#define	SMP_ESTIMATED_NUM_DEVS	4		/* for soft-state allocation */
#define	SMP_DEFAULT_RETRY_TIMES	3

#define	SMP_FLAG_REQBUF		0x1
#define	SMP_FLAG_RSPBUF		0x2
#define	SMP_FLAG_XFER			0x4

#endif /* defined(_KERNEL) */


#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_SCSI_TARGETS_SMP_H */
