/* pserror.c
 * Copyright (C) Angus J. C. Duggan 1991-1995
 * See file LICENSE for details.
 *
 * Warnings and errors for PS programs
 */

extern char *program ;	/* Defined by main program, giving program name */

#include "psutil.h"
#include "pserror.h"
#include "patchlev.h"

#include <string.h>
#include <stdio.h>
#include <stdarg.h>

/* Message functions; there is a single are varargs functions for messages,
   warnings, and errors sent to stderr. If called with the flags MESSAGE_EXIT
   set, the routine does not return */
void message(int flags, char *format, ...)
{
  va_list args ;

  if ( flags & MESSAGE_NL ) {	/* new line if not already */
    putc('\n', stderr) ;
  }

  if ( flags & MESSAGE_PROGRAM ) {
    fprintf (stderr, "%s: ", program);
  }

  va_start(args, format) ;
  if ( format != NULL )
    vfprintf(stderr, format, args);
  va_end(args) ;

  fflush(stderr);

  if ( flags & MESSAGE_EXIT )	/* don't return to program */
    exit(1) ;
}
