Rem
Rem $Header: emll/admin/scripts/collectconfig.sql /st_emll_10.3.8/1 2012/12/24 22:12:39 jsutton Exp $
Rem
Rem collectconfigVob.sql
Rem
Rem Copyright (c) 2005, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      collectconfigVob.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsutton     12/20/12 - clean up
Rem    jsutton     09/24/12 - use enquote_literal for acl name
Rem    jsutton     08/23/12 - one more alter for cdb/pdb
Rem    jsutton     03/21/12 - PDB support
Rem    jsutton     02/19/12 - grants modified per rdbms team
Rem    jsutton     02/14/12 - need another grant for pre-10
Rem    jsutton     02/01/12 - fix version check
Rem    ckalivar    01/09/12 - bug 11069555: add DBMS_SQL execute permissions to
Rem                           ORACLE_OCM user, incase public user dont have it
Rem    rpang       08/22/11 - Proj 32719: Grant/revoke inherit privileges
Rem    jsutton     12/08/10 - check for null privilege
Rem    jsutton     12/01/10 - fixups for acl handling
Rem    jsutton     11/22/10 - Fix ACL logic
Rem    ndutko      06/09/10 - Do not create the ACL for network interface
Rem                           objects if it already exists
Rem    jsutton     05/24/10 - remove extraneous retrieval of compatible info
Rem    jsutton     05/17/10 - add acl stuff for utl_inaddr access
Rem    jsutton     04/23/10 - RAC instance discovery
Rem    nmittal     08/12/09 - changes to make this file RCU compliant
Rem    jsutton     07/20/09 - Add priv grants for utl_inaddr
Rem    glavash     07/09/09 - remove 8222370 changes
Rem    pparida     06/04/09 - 8268571: Check for compatible param too.
Rem    glavash     05/28/09 - random password for ocm user
Rem    glavash     08/19/08 - grant explicit access to oracle_ocm user
Rem    dkapoor     08/03/07 - grant specific table acces
Rem    dkapoor     09/20/06 - give priv only if not given to public
Rem    dkapoor     09/15/06 - do not drop oracle_ocm if ocm packages not present
Rem    dkapoor     09/13/06 - grant execute on dbms_scheduler
Rem    dkapoor     09/13/06 - grant execute on dbms_job to oracle_ocm user
Rem    dkapoor     07/26/06 - define OCM_USER 
Rem    dkapoor     07/20/06 - fix 817 ocmjb file call 
Rem    dkapoor     06/06/06 - move directory creation after installing the 
Rem                           packages 
Rem    dkapoor     05/23/06 - use catocm 
Rem    dkapoor     05/25/06 - check for compatible param in 8.1.7 
Rem    dkapoor     03/27/06 - use fixed table to raise exception when db is 
Rem                           not open 
Rem    dkapoor     03/28/06 - grant execute on utl_file to ccr 
Rem    dkapoor     03/08/06 - remove livelink 
Rem    dkapoor     11/27/05 - check db is up 
Rem    dkapoor     11/15/05 - convert dbms_output to exception 
Rem    dkapoor     10/10/05 - use drop script 
Rem    dkapoor     10/10/05 - remove spool 
Rem    dkapoor     09/30/05 - impl 8.1.7 support 
Rem    dkapoor     09/08/05 - make livelink user expire on creation,add extra checks
Rem    ndutko      08/03/05 - ndutko_code_checkin
Rem    dkapoor     04/05/05 - Created
Rem

SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100
SET serveroutput on
SET escape on
SET VERIFY off
SET FEEDBACK 0
SET HEADING OFF

WHENEVER SQLERROR EXIT 1;

define OCM_DATA_DIR               = "&1"
define OCM_DATA_DIR2              = "&2"
define OCM_USER                   = "ORACLE_OCM"
define CONFIG_DIR_NAME            = "ORACLE_OCM_CONFIG_DIR"
define CONFIG_DIR_NAME2           = "ORACLE_OCM_CONFIG_DIR2"
define OCM_XDB_ACL                = "oracle-sysman-ocm-Resolve-Access.xml";

-- Check database open mode
DECLARE
   l_open_mode            VARCHAR2(10);
   l_num_users            number;
BEGIN
   select open_mode into l_open_mode from v$database;
   IF l_open_mode != 'READ WRITE' THEN
      -- Need to raise exception so that we exit
      -- when database is in mount state
      -- Calling a fixed view to raise exception
      -- because raise_application_error is not recognized when
      -- database is not open.
      select count(*) into l_num_users from dba_users;
   END IF;
END;
/
SET ECHO ON
-- Check database status
DECLARE
   l_vers            VARCHAR2(10);
BEGIN
   BEGIN
   select LPAD(version,10,'0') into l_vers from v$instance;
   IF l_vers < '08.1.7.0.0' THEN
      raise_application_error(-20000,'Oracle database version less than 8.1.7 is not supported.');
   END IF;
   EXCEPTION
      WHEN OTHERS THEN
         raise_application_error(-20002,SQLERRM);
  END;
END;
/
Rem job_package_prefix is '10' if db version is 10g or higher 
Rem otherwise, its empty ''.
VARIABLE job_package_prefix VARCHAR2(4000);

-- Check init param
DECLARE
   l_vers            v$instance.version%TYPE;
   l_compat_vers     v$parameter.value%TYPE;
   l_reqd_utl_file_dir_cnt   NUMBER;
   l_compatible   v$parameter.VALUE%TYPE;
   l_job_queue_processes_value   NUMBER;
   l_job_pkg_prefix VARCHAR2(4000);
   l_is_cdb VARCHAR2(5) := 'NO';
   l_con_id NUMBER := 0;
BEGIN
   BEGIN
   select substr(version,1,5) into l_vers from v$instance;
   begin
      select substr(value,1,5) into l_compat_vers from v$parameter where lower(name) = 'compatible';
   exception
      -- We do not catch TOO_MANY_ROWS because in that case we need to expose it. There should never
      -- be more than one compatible parameter in v$parameter.
      WHEN NO_DATA_FOUND THEN
         l_compat_vers := l_vers;
   end;

   IF l_vers = '9.0.1' OR l_vers = '8.1.7' OR l_compat_vers = '8.1.7' THEN
   -- 9.0.1, check if utl_file_dir has oracle_home/ccr/data in the path
   -- enumerate the four possible cases for this directory to be in utl_file_dir
      select count(*) into l_reqd_utl_file_dir_cnt from v$parameter
         where lower(name)= 'utl_file_dir' 
         and value  like '&OCM_DATA_DIR'  -- single dir
         or  value  like '&OCM_DATA_DIR, %'  -- the start dir
         or  value  like '%, &OCM_DATA_DIR'  -- the last dir
         or  value  like '%, &OCM_DATA_DIR, %';  -- the middle dir
      IF l_reqd_utl_file_dir_cnt = 0 THEN
         raise_application_error(-20003,'Add &OCM_DATA_DIR to the UTL_FILE_DIR, restart the database and then rerun collectconfig.sql.');
      END IF;
   END IF;

   -- Check for compatible parameter of equal or more than 8.1.0
   -- if the database is 8.1.7 
   IF l_vers = '8.1.7' THEN
      select SUBSTR(value,1,3) into l_compatible from v$parameter
         where lower(name)='compatible';
      IF  l_compatible < '8.1' THEN
         raise_application_error(-20009,'Set ''compatible'' database initialization paramater to a value of ''8.1.0'' or higher, restart the database and then rerun collectconfig.');
      END IF;
   END IF;

   select LPAD(version,10,'0') into l_vers from v$instance;
   -- Check for the value of job_queue_processes for less than 10g databases.
   IF l_vers < '10.0.0.0.0' THEN
      select value into l_job_queue_processes_value from v$parameter
         where lower(name)='job_queue_processes';
      IF l_job_queue_processes_value = '0' THEN
         raise_application_error(-20008,'Set ''JOB_QUEUE_PROCESSES'' database initialization paramater to a value of one or higher and then rerun collectconfig.');
      END IF;
      -- OCM job package prefix for pre10g db
      l_job_pkg_prefix := '';
      ELSE
      -- OCM job package prefix for 10g and higher db
      l_job_pkg_prefix := '10';
   END IF;
   :job_package_prefix := l_job_pkg_prefix;

   IF l_vers >= '12.1.0.0.0' THEN
     BEGIN
       execute immediate 'SELECT UPPER(CDB) FROM V$DATABASE' into l_is_cdb;
       EXCEPTION
         WHEN OTHERS THEN
           null;
       END;
     IF l_is_cdb = 'YES' THEN
       -- In CDB, CON_ID 1 is the ROOT. We only want to run our scripts in that container.
       execute immediate 'select sys_context(''USERENV'',''CON_ID'') from dual' into l_con_id;
       if l_con_id <> 1 then
         return;
       END IF;
       execute immediate 'ALTER SESSION SET "_oracle_script" = TRUE';
     END IF;
   END IF;

   EXCEPTION
      WHEN OTHERS THEN
         raise_application_error(-20004,SQLERRM);
  END;
END;
/

column job_package_prefix new_value job_package_prefix noprint;
select :job_package_prefix as job_package_prefix from dual;

-- Drop old schema CCR and its directory object
-- Drop new schema ORACLE_OCM and its directory object
@@dropocm

Rem Create the user 
set echo off
create user &OCM_USER identified by "OCM_3XP1R3D" account lock password expire;
set echo on

--Rem submit the job and run now
-- Create directory object if higher than 9.0.1
DECLARE
   l_vers            v$instance.version%TYPE;
   l_compat_vers     v$parameter.value%TYPE;
   l_dirobj_cnt      NUMBER;
   l_dirobj_priv_cnt NUMBER;
   l_priv_cnt        NUMBER;

   l_comp_cnt        NUMBER;
   l_acl_count       NUMBER;
   l_acl_priv        NUMBER;
   l_acl_name        VARCHAR2(4000);
   l_is_cdb          VARCHAR2(4) := 'NO';

BEGIN
   BEGIN
      select count(*) into l_priv_cnt from dba_tab_privs where 
         GRANTEE ='&OCM_USER' and TABLE_NAME='UTL_FILE' and 
         upper(PRIVILEGE) = 'EXECUTE';
      IF l_priv_cnt = 0 THEN
         -- Grant priv only if its not given to public.
         execute immediate 'GRANT EXECUTE ON SYS.UTL_FILE TO &OCM_USER';
      END IF;

      select count(*) into l_priv_cnt from dba_tab_privs where 
         GRANTEE ='&OCM_USER' and TABLE_NAME='UTL_INADDR' and 
         upper(PRIVILEGE) = 'EXECUTE';
      IF l_priv_cnt = 0 THEN
         -- Grant priv only if its not given to public.
         execute immediate 'GRANT EXECUTE ON SYS.UTL_INADDR TO &OCM_USER';
      END IF;

      select count(*) into l_priv_cnt from dba_tab_privs where
         GRANTEE ='&OCM_USER' and TABLE_NAME='DBMS_SQL' and
         upper(PRIVILEGE) = 'EXECUTE';
      IF l_priv_cnt = 0 THEN
         -- Grant priv only if its not given to public.
         execute immediate 'GRANT EXECUTE ON SYS.DBMS_SQL TO &OCM_USER';
      END IF;

      select LPAD(version,10,'0') into l_vers from v$instance;

      IF l_vers < '10.0.0.0.0' THEN
         -- Need to grant execute on dbms_job to OCM user.
         -- for database version less than 10.
         select count(*) into l_priv_cnt from dba_tab_privs where 
            GRANTEE ='&OCM_USER' and TABLE_NAME='DBMS_JOB' and 
            upper(PRIVILEGE) = 'EXECUTE';
         IF l_priv_cnt = 0 THEN
         -- Grant priv only if its not given to public.
            execute immediate 'GRANT EXECUTE ON SYS.DBMS_JOB TO &OCM_USER';
         END IF;
         -- also need for DBMS_FLASHBACK
         select count(*) into l_priv_cnt from dba_tab_privs where 
            GRANTEE ='&OCM_USER' and TABLE_NAME='DBMS_FLASHBACK' and 
            upper(PRIVILEGE) = 'EXECUTE';
         IF l_priv_cnt = 0 THEN
         -- Grant priv only if its not given to public.
            execute immediate 'GRANT EXECUTE ON SYS.DBMS_FLASHBACK TO &OCM_USER';
         END IF;

      ELSE
      -- Check privilege to use DBMS_SCHEDULER package
         select count(*) into l_priv_cnt from dba_tab_privs where 
            GRANTEE ='&OCM_USER' and TABLE_NAME='DBMS_SCHEDULER' and 
            upper(PRIVILEGE) = 'EXECUTE';
         IF l_priv_cnt = 0 THEN
            -- Grant priv only if its not given to public.
            execute immediate 'GRANT EXECUTE ON SYS.DBMS_SCHEDULER TO &OCM_USER';
         END IF;
         -- check for CREATE JOB privilege
         select count(*) into l_priv_cnt from dba_sys_privs where 
            GRANTEE ='&OCM_USER' and PRIVILEGE='CREATE JOB'; 
         IF l_priv_cnt = 0 THEN
            -- Grant priv
            execute immediate 'GRANT CREATE JOB TO &OCM_USER';
         END IF;
        
      END IF;

      -- Grant privilege to use UTL_INADDR via ACL if necessary
      IF l_vers >= '11.0.0.0.0' THEN
         -- check for XML DB installed
         execute immediate 'select count(*) from dba_registry '||
            'where COMP_NAME = ''Oracle XML Database'' and STATUS = ''VALID'''into l_comp_cnt ;

         IF l_comp_cnt > 0 THEN
            -- check for ACL assigned to localhost
            execute immediate 'select count(*) from dba_network_acls where host=''localhost''' into l_acl_count;
            IF (l_acl_count = 0) THEN
               -- create ACL and assign to localhost
               execute immediate 
               'BEGIN '||
               '  DBMS_NETWORK_ACL_ADMIN.CREATE_ACL(''&OCM_XDB_ACL'', ''OCM User Resolve Network Access using UTL_INADDR'', ''&OCM_USER'', TRUE, ''resolve'');' ||
               '  DBMS_NETWORK_ACL_ADMIN.ASSIGN_ACL(''&OCM_XDB_ACL'', ''localhost'');' ||
               '  COMMIT;' ||
               'END;';
            ELSE
            -- ACL for localhost exists
               -- check for resolve privilege for OCM user
               execute immediate
               'SELECT acl, DBMS_NETWORK_ACL_ADMIN.CHECK_PRIVILEGE_ACLID(aclid, ''&OCM_USER'', ''resolve'') ' ||
               '  FROM dba_network_acls WHERE host = ''localhost'''
                  INTO l_acl_name, l_acl_priv;
               IF (l_acl_priv IS NULL OR l_acl_priv = 0) THEN
                  -- add resolve privilege
                  execute immediate
                  'BEGIN ' ||
                  '  DBMS_NETWORK_ACL_ADMIN.ADD_PRIVILEGE(' || DBMS_ASSERT.ENQUOTE_LITERAL(l_acl_name) || ', ''&OCM_USER'', TRUE, ''resolve'');' ||
                  '  COMMIT;' ||
                  'END;';
               END IF;
            END IF;
         END IF;
      END IF;

      -- use the first 5 chars of version/compatible for remaining comparisons
      select substr(version,1,5) into l_vers from v$instance;
      begin
        select substr(value,1,5) into l_compat_vers from v$parameter where lower(name) = 'compatible';
      exception
        -- We do not catch TOO_MANY_ROWS because in that case we need to expose it. There should never
        -- be more than one compatible parameter in v$parameter.
        WHEN NO_DATA_FOUND THEN
          l_compat_vers := l_vers;
      end;

      IF l_vers != '9.0.1' AND l_vers != '8.1.7' AND l_compat_vers != '8.1.7' THEN
         select count(*) into l_dirobj_cnt from  dba_directories where DIRECTORY_NAME ='&CONFIG_DIR_NAME';
         IF l_dirobj_cnt = 0 THEN
            execute immediate 'CREATE OR REPLACE DIRECTORY &CONFIG_DIR_NAME AS ''&OCM_DATA_DIR''';
         END IF;
         select count(*) into l_dirobj_priv_cnt from dba_tab_privs where GRANTEE ='&OCM_USER' and TABLE_NAME='&CONFIG_DIR_NAME' and upper(PRIVILEGE) = 'READ';
         IF l_dirobj_priv_cnt = 0 THEN
            execute immediate 'GRANT READ ON DIRECTORY &CONFIG_DIR_NAME TO &OCM_USER';
         END IF;
         select count(*) into l_dirobj_priv_cnt from dba_tab_privs where GRANTEE ='&OCM_USER' and TABLE_NAME='&CONFIG_DIR_NAME' and upper(PRIVILEGE) = 'WRITE';
         IF l_dirobj_priv_cnt = 0 THEN
            execute immediate 'GRANT WRITE ON DIRECTORY &CONFIG_DIR_NAME TO &OCM_USER';
         END IF;
         -- Set up secondary config data dir
         select count(*) into l_dirobj_cnt from  dba_directories where DIRECTORY_NAME ='&CONFIG_DIR_NAME2';
         IF l_dirobj_cnt = 0 THEN
            execute immediate 'CREATE OR REPLACE DIRECTORY &CONFIG_DIR_NAME2 AS ''&OCM_DATA_DIR2''';
         END IF;
         select count(*) into l_dirobj_priv_cnt from dba_tab_privs where GRANTEE ='&OCM_USER' and TABLE_NAME='&CONFIG_DIR_NAME2' and upper(PRIVILEGE) = 'READ';
         IF l_dirobj_priv_cnt = 0 THEN
            execute immediate 'GRANT READ ON DIRECTORY &CONFIG_DIR_NAME2 TO &OCM_USER';
         END IF;
         select count(*) into l_dirobj_priv_cnt from dba_tab_privs where GRANTEE ='&OCM_USER' and TABLE_NAME='&CONFIG_DIR_NAME2' and upper(PRIVILEGE) = 'WRITE';
         IF l_dirobj_priv_cnt = 0 THEN
            execute immediate 'GRANT WRITE ON DIRECTORY &CONFIG_DIR_NAME2 TO &OCM_USER';
         END IF;
      END IF;

      -- Grant/revoke INHERIT PRIVILEGES for 12.1 or above
      select LPAD(version,10,'0') into l_vers from v$instance;
      IF l_vers >= '12.1.0.0.0' THEN
        execute immediate 'GRANT INHERIT ANY PRIVILEGES TO &OCM_USER';
        execute immediate 'GRANT INHERIT PRIVILEGES ON USER SYS TO &OCM_USER';
        BEGIN
          execute immediate 'SELECT UPPER(CDB) FROM V$DATABASE' into l_is_cdb;
          IF (l_is_cdb = 'YES') THEN
            execute immediate 'GRANT SET CONTAINER TO &OCM_USER CONTAINER=ALL';
            execute immediate 'ALTER USER &OCM_USER SET CONTAINER_DATA=ALL';
          END IF;
          EXCEPTION
            WHEN OTHERS THEN
              -- ignore any exception
              null;
        END;

        BEGIN
          execute immediate 'REVOKE INHERIT PRIVILEGES ON USER &OCM_USER FROM PUBLIC';
        EXCEPTION
          WHEN OTHERS THEN
            -- ignore any exception
            null;
        END;
      END IF;

      EXCEPTION
         WHEN OTHERS THEN
            raise_application_error(-20007,SQLERRM);
   END;
   COMMIT;
END;
/

Rem
Rem Create package for CCR
Rem
@@grntocmtabaccess.sql
@@ocmdbd.sql
@@ocmdbb.sql
@@ocmjd&job_package_prefix
@@ocmjb&job_package_prefix

--Rem submit the job and run now
BEGIN
  &OCM_USER..MGMT_CONFIG.submit_job();
  &OCM_USER..MGMT_CONFIG.run_now();
END;
/

spool off;
exit;
