SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100
SET serveroutput on
SET escape on
SET VERIFY off
SET FEEDBACK 0
SET HEADING OFF

WHENEVER SQLERROR EXIT 1;

define OCM_DATA_DIR                    = "&1"
define EMREP_PWD                       = "&2"
define EMREP_USER                      = "SYSMAN"
define CONFIG_DIR_NAME                 = "ORACLE_OCM_CONFIG_DIR"

DECLARE
  l_vers VARCHAR2(10);
BEGIN
  BEGIN
    select LPAD(version, 10, '0') into l_vers from v$instance;
    IF l_vers < '08.1.7.0.0' THEN
      raise_application_error(-20000, 'Oracle database version less than 8.1.7 is not supported.');
    END IF;
  EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20002, SQLERRM);
  END;
END;
/

DECLARE
  l_job_queue_processes_value   NUMBER;
BEGIN
   select value into l_job_queue_processes_value from  v$parameter where lower(name)='job_queue_processes';
   IF  l_job_queue_processes_value = '0' THEN
      	raise_application_error(-20008,'Set ''JOB_QUEUE_PROCESSES'' database initialization paramater to a value of one or higher and then rerun collectgcrep.');
   END IF;
END;
/

DECLARE
  l_emrep_ver VARCHAR2(10);
BEGIN
  BEGIN
    execute immediate 'select LPAD(version, 10, ''0'') from SYSMAN.mgmt_versions where component_name =''CORE''' into l_emrep_ver ;
    IF l_emrep_ver < '10.1.0.0.0' THEN
      raise_application_error(-20010, 'The repository version is invalid. This script can only be used against EM repository version greater than 10.1');
    END IF;
  EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20011, 'The SYSMAN schema does not contain a valid EM repository');
  END;
END;
/
     
-- Drop gcrep job and packages
@@dropemrep_collect 

DECLARE
  l_vers v$instance.version%TYPE;
  l_compat_vers     v$parameter.value%TYPE;
  l_reqd_utl_file_dir_cnt NUMBER;
  l_dirobj_cnt NUMBER;
  l_dirobj_priv_cnt NUMBER;
  l_b_commit BOOLEAN := FALSE;
BEGIN
   BEGIN
   select substr(version,1,5) into l_vers from v$instance;
   begin
     select substr(value,1,5) into l_compat_vers from v$parameter where lower(name) = 'compatible';
   exception
     WHEN NO_DATA_FOUND THEN
       l_compat_vers := l_vers;
   end;
   IF l_vers = '9.0.1' OR l_vers = '8.1.7' OR l_compat_vers = '8.1.7' THEN
   -- 9.0.1, check if utl_file_dir has oracle_home/livelink/data in the path
   -- enumerate the four possible cases for this directory to be in utl_file_dir
	select count(*) into l_reqd_utl_file_dir_cnt 
		from v$parameter where lower(name)= 'utl_file_dir' and 
		 value   like '&OCM_DATA_DIR'  -- single dir
		or value  like '&OCM_DATA_DIR, %'  -- the start dir
		or value  like '%, &OCM_DATA_DIR'  -- the last dir
		or value  like '%, &OCM_DATA_DIR, %';  -- the middle dir
	IF l_reqd_utl_file_dir_cnt = 0 THEN
		RAISE_APPLICATION_ERROR(-20000,'Add &OCM_DATA_DIR to the UTL_FILE_DIR, restart the database and then rerun collect.sql.');
	END IF;
   ELSE
        select count(*) into l_dirobj_cnt from  dba_directories where DIRECTORY_NAME ='&CONFIG_DIR_NAME';
        IF l_dirobj_cnt = 0 THEN
                execute immediate 'CREATE OR REPLACE DIRECTORY &CONFIG_DIR_NAME AS ''&OCM_DATA_DIR''';
		l_b_commit := TRUE;
        END IF;
	select count(*) into l_dirobj_priv_cnt from dba_tab_privs where GRANTEE ='&EMREP_USER' and TABLE_NAME='&CONFIG_DIR_NAME' and upper(PRIVILEGE) = 'READ';
        IF l_dirobj_priv_cnt = 0 THEN
        	execute immediate 'GRANT READ ON DIRECTORY &CONFIG_DIR_NAME TO &EMREP_USER';
		l_b_commit := TRUE;
	END IF;
	 select count(*) into l_dirobj_priv_cnt from dba_tab_privs where GRANTEE ='&EMREP_USER' and TABLE_NAME='&CONFIG_DIR_NAME' and upper(PRIVILEGE) = 'WRITE';
        IF l_dirobj_priv_cnt = 0 THEN
        	execute immediate 'GRANT WRITE ON DIRECTORY &CONFIG_DIR_NAME TO &EMREP_USER';
		l_b_commit := TRUE;
	END IF;
	IF l_b_commit THEN
        	COMMIT;
	END IF;
   END IF;
   EXCEPTION
	WHEN OTHERS THEN
      		RAISE_APPLICATION_ERROR(-20001,SQLERRM);
   END;
END;
/

SET ECHO OFF
--connect &EMREP_USER/"&EMREP_PWD"
ALTER SESSION SET CURRENT_SCHEMA=&EMREP_USER;
SET ECHO ON

Rem
Rem Create packages 
Rem

@@ocm_emrep_metrics_def.sql
@@ocm_emrep_metrics_body.sql
@@ocm_emrep_config_def.sql
@@ocm_emrep_config_body.sql

set serveroutput on

BEGIN
 MGMT_EMREP_CONFIG.install_job();
 MGMT_EMREP_CONFIG.run_now();
END;
/

exit;
