SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

DECLARE
  l_vers         v$instance.version%TYPE;
  l_compat_vers     v$parameter.value%TYPE;
  l_dirobj_cnt   NUMBER;
BEGIN
   select substr(version,1,5) into l_vers from v$instance;
   begin
     select substr(value,1,5) into l_compat_vers from v$parameter where lower(name) = 'compatible';
   exception
     WHEN NO_DATA_FOUND THEN
       l_compat_vers := l_vers;
   end;
   IF l_vers != '9.0.1' AND l_vers != '8.1.7' AND l_compat_vers != '8.1.7' THEN
   	select count(*) into l_dirobj_cnt from  dba_directories where DIRECTORY_NAME ='ORACLE_OCM_CONFIG_DIR';
       	IF l_dirobj_cnt = 1 THEN 
       		execute immediate 'DROP DIRECTORY ORACLE_OCM_CONFIG_DIR';
        END IF;
   END IF;
END;
/



set serveroutput on

declare
  l_emrepjob_cnt NUMBER;
  l_emrepconfigpkg_cnt NUMBER;
  l_emrepmetricspkg_cnt NUMBER;
  l_vers v$instance.version%TYPE;
  l_compat_vers     v$parameter.value%TYPE;
begin
 select substr(version,1,5) into l_vers from v$instance;
 begin
   select substr(value,1,5) into l_compat_vers from v$parameter where lower(name) = 'compatible';
 exception
   WHEN NO_DATA_FOUND THEN
     l_compat_vers := l_vers;
 end;

 select count(*) into l_emrepconfigpkg_cnt from all_objects where object_name = 'MGMT_EMREP_CONFIG' and object_type='PACKAGE' and owner = upper('SYSMAN');
 IF l_emrepconfigpkg_cnt > 0 THEN
   select count(*) into l_emrepjob_cnt from dba_jobs where what like 'MGMT_EMREP_METRICS.collect_config_metrics%' and schema_user = upper('SYSMAN');

   IF l_emrepjob_cnt > 0 AND l_vers != '8.1.7' AND l_compat_vers != '8.1.7' THEN
     execute immediate 'begin ' || 'SYSMAN' || '.MGMT_EMREP_CONFIG.stop_job; end;';      
   END IF;
   execute immediate 'drop package ' || 'SYSMAN' || '.MGMT_EMREP_CONFIG';
 END IF;

 select count(*) into l_emrepmetricspkg_cnt from all_objects where object_name = 'MGMT_EMREP_METRICS' and object_type='PACKAGE' and owner = upper('SYSMAN');
 IF l_emrepmetricspkg_cnt > 0 THEN
   execute immediate 'drop package ' || 'SYSMAN' || '.MGMT_EMREP_METRICS';
 END IF;

end;
/

set echo off
prompt
prompt   Drop of EMREP collection for OCM complete.
prompt

