Rem
Rem $Header: emll/admin/scripts/dropocm.sql /main/12 2011/09/21 06:07:35 jsutton Exp $
Rem
Rem dropocm.sql
Rem
Rem Copyright (c) 2006, 2011, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      dropocm.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsutton     09/19/11 - Fix drop of 2nd dir
Rem    jsutton     09/16/11 - hide syntax incompatible with 8i
Rem    glavash     03/02/11 - add begin end around network drop
Rem    jsutton     01/11/11 - be sure to drop old ACLs
Rem    jsutton     12/01/10 - fixups for acl handling
Rem    jsutton     12/01/10 - rework so no cursor needed, logic inside block if db is 11g+
Rem    jsutton     11/22/10 - Fix ACL logic
Rem    jsutton     07/21/10 - Check for XML option
Rem    ndutko      06/09/10 - Drop the DBMS Network ACLs where it was granted
Rem    jsutton     04/30/10 - remove 2nd directory object if it exists
Rem    pparida     06/04/09 - 8268571: Check for compatible param too.
Rem    dkapoor     09/18/06 - drop ocm
Rem    dkapoor     09/18/06 - Created
Rem
set echo on
SET serveroutput on
set verify off

-- handle 11+ databases (ACLs)
@@dropocm11plus

DECLARE
  l_user_dropped   BOOLEAN;

 /*
  * Procedure to drop user.
  * If p_throw_exp is TRUE, throw exception if user cannot be dropped.
  */
  PROCEDURE drop_user
     (p_user IN VARCHAR2, p_dir_name IN VARCHAR2, p_dir_name2 IN VARCHAR2, 
      p_throw_user_drop_exp BOOLEAN := FALSE,o_user_dropped OUT BOOLEAN)
  IS
    l_ll_user_exists       NUMBER;
    l_ll_pkg_exists       NUMBER;
    l_vers            v$instance.version%TYPE;
    l_compat_vers     v$parameter.value%TYPE;
    l_dirobj_cnt   NUMBER;
  BEGIN
    BEGIN
      select count(*) into l_ll_user_exists from dba_users where username = p_user;
      o_user_dropped := FALSE;
      IF l_ll_user_exists = 1 THEN
        SELECT count(*) into l_ll_pkg_exists FROM sys.user$ u, sys.obj$ o WHERE u.name = p_user AND o.name ='MGMT_DB_LL_METRICS' AND o.owner# = u.user# AND o.type# = 9 AND o.status LIKE '%' ;
        IF l_ll_pkg_exists = 1 THEN
          execute immediate 'drop user '|| p_user ||' cascade';
          o_user_dropped := TRUE;
        ELSIF p_throw_user_drop_exp  THEN
          RAISE_APPLICATION_ERROR(-20030,'Could not drop the OCM user ''' || p_user || '''. It does not contain OCM schema. Please drop this user to proceed.');
        END IF;
      END IF;
    EXCEPTION
      WHEN OTHERS THEN
        IF  p_throw_user_drop_exp  THEN
          raise_application_error(-20006,SQLERRM);
        ELSE
           NULL;
        END IF;
    END;
    select substr(version,1,5) into l_vers from v$instance;
    begin
      select substr(value,1,5) into l_compat_vers from v$parameter where lower(name) = 'compatible';
      exception
        WHEN NO_DATA_FOUND THEN
          l_compat_vers := l_vers;
    end;
    IF l_vers != '9.0.1' AND l_vers != '8.1.7' AND l_compat_vers != '8.1.7' THEN
      select count(*) into l_dirobj_cnt from  dba_directories where DIRECTORY_NAME = p_dir_name ;
      IF l_dirobj_cnt = 1 THEN
        execute immediate 'DROP DIRECTORY ' || p_dir_name;
      END IF;
      IF p_dir_name2 IS NOT NULL THEN
        select count(*) into l_dirobj_cnt from  dba_directories where DIRECTORY_NAME = p_dir_name2 ;
        IF l_dirobj_cnt = 1 THEN
          execute immediate 'DROP DIRECTORY ' || p_dir_name2;
        END IF;
      END IF;
    END IF;
  END drop_user; 

BEGIN
   -- Drop previous OCM user
   -- discard the return value
   drop_user('CCR','CCR_CONFIG_DIR',NULL,FALSE,l_user_dropped); 

   -- Drop current OCM user
   drop_user('ORACLE_OCM','ORACLE_OCM_CONFIG_DIR','ORACLE_OCM_CONFIG_DIR2',TRUE,l_user_dropped);
   if( l_user_dropped ) THEN
     DBMS_OUTPUT.PUT_LINE('Dropped previous OCM schema successfully.');
   ELSE
     DBMS_OUTPUT.PUT_LINE('No previous OCM schema to drop.');
   END IF;
END;
/
