Rem
Rem dropocm11plus.sql
Rem
Rem Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
Rem
Rem    NAME
Rem      dropocm11plus.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsutton     09/16/11 - put 11+ operations in separate file
Rem    jsutton     09/16/11 - Created
Rem

SET serveroutput on
set verify off

DECLARE
  l_instvers       VARCHAR2(100);
BEGIN

  -- Drop the Network ACL if the ACL was created.
  select LPAD(version,10,'0') into l_instvers from v$instance;
  IF l_instvers >= '11.0.0.0.0' THEN
  EXECUTE IMMEDIATE
'DECLARE
  l_comp_cnt       NUMBER;
  l_regexp_match   NUMBER;
  TYPE p_acl_ids_type  IS TABLE OF VARCHAR2(4000);
  TYPE p_acl_priv_type IS TABLE OF NUMBER;
  l_acl_ids        p_acl_ids_type;
  l_acl_privs      p_acl_priv_type;
  l_acl_cnt        NUMBER;
BEGIN
  -- check for XML DB installed
  select count(*) into l_comp_cnt from dba_registry where COMP_NAME = ''Oracle XML Database'' and STATUS = ''VALID'';
  IF l_comp_cnt > 0 THEN
    -- drop the entire ACL if it is the one we created
    select count(*) into l_regexp_match from dba_network_acls where regexp_like(acl,''.oracle-sysman-ocm-Resolve-Access.xml$'');
    IF (l_regexp_match > 0) THEN
      DBMS_NETWORK_ACL_ADMIN.DROP_ACL(''oracle-sysman-ocm-Resolve-Access.xml'');
      COMMIT;
    END IF;

    -- check for resolve privilege for OCM user
    -- get all ACLIDs and whether ORACLE_OCM has resolve privilege through each
    BEGIN
      SELECT acl, DBMS_NETWORK_ACL_ADMIN.CHECK_PRIVILEGE_ACLID(aclid, ''ORACLE_OCM'', ''resolve'') acl_priv 
        BULK COLLECT INTO l_acl_ids, l_acl_privs
        FROM dba_network_acls;
      EXCEPTION
        WHEN OTHERS THEN NULL;
    END;
    -- walk the collection
    FOR i IN 1..l_acl_ids.count LOOP
      BEGIN
        IF (l_acl_privs(i) IS NOT NULL AND l_acl_privs(i) > 0) THEN
          -- remove resolve privilege
          DBMS_NETWORK_ACL_ADMIN.DELETE_PRIVILEGE(acl => l_acl_ids(i),principal => ''ORACLE_OCM'');
          COMMIT;
        END IF;
        EXCEPTION
          WHEN OTHERS THEN NULL;
      END;
    END LOOP;
  END IF;
END;';

  END IF;
END;
/
