Rem
Rem $Header: emll/admin/scripts/ebs_collectconfig.sql /main/11 2012/08/03 10:19:08 rlandows Exp $
Rem
Rem Copyright (c) 2005, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      ebs_collectconfig.sql
Rem
Rem    DESCRIPTION
Rem      N/A
Rem
Rem    NOTES
Rem      N/A
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsutton     11/30/11 - need another grant
Rem    fmorshed    10/28/10 - Change EMREP_DIR_NAME to ORACLE_OCM_CONFIG_DIR so
Rem                           db, ebs, and gc all use the samedirectory object.
Rem    pparida     06/04/09 - 8268571: Check for compatible param too.
Rem    ppradhan    12/21/05 - Fix for bug 4768878 
Rem    dkapoor     11/15/05 - convert dbms_output to exception 
Rem    fle         10/04/05 - Validate DB version
Rem    fle         09/28/05 - verify LIVELINK_DATA_DIR existent
Rem    fle         09/28/05 - added pwd as program argument
Rem    dkapoor     09/21/05 - use separate directory object 
Rem    ndutko      08/03/05 - ndutko_code_checkin
Rem    dkapoor     04/05/05 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100
SET serveroutput on
SET escape on
SET VERIFY off
SET FEEDBACK 0
SET HEADING OFF

WHENEVER SQLERROR EXIT 1;

define LIVELINK_DATA_DIR               = "&1"
define APPS_USER                       = "&2"
define APPS_USER_PWD                   = "&3"
define CONFIG_DIR_NAME                 = "ORACLE_OCM_CONFIG_DIR"

DECLARE
  l_vers VARCHAR2(10);
BEGIN
  BEGIN
    select LPAD(version, 10, '0') into l_vers from v$instance;
    IF l_vers < '08.1.7.0.0' THEN
      raise_application_error(-20000, 'Oracle database version less than 8.1.7 is not supported.');
    END IF;
  EXCEPTION
    WHEN OTHERS THEN
      raise_application_error(-20002, SQLERRM);
  END;
END;
/

DECLARE
  l_job_queue_processes_value   NUMBER;
BEGIN
  select value into l_job_queue_processes_value from  v$parameter where lower(name)='job_queue_processes';
  IF l_job_queue_processes_value = '0' THEN
    raise_application_error(-20008,'Set ''JOB_QUEUE_PROCESSES'' database initialization paramater to a value of one or higher and then rerun ebs_collectconfig.');
  END IF;
END;
/

-- Drop ebs job and packages
@@ebs_dropccr &APPS_USER

DECLARE
  l_vers v$instance.version%TYPE;
  l_compat_vers v$parameter.value%TYPE;
  l_reqd_utl_file_dir_cnt NUMBER;
  l_dirobj_cnt NUMBER;
  l_dirobj_priv_cnt NUMBER;
  l_b_commit BOOLEAN := FALSE;
BEGIN
  BEGIN
    select substr(version,1,5) into l_vers from v$instance;
    begin
      select substr(value,1,5) into l_compat_vers from v$parameter where lower(name) = 'compatible';
    exception
      WHEN NO_DATA_FOUND THEN
        l_compat_vers := l_vers;
    end;
    IF l_vers = '9.0.1' OR l_vers = '8.1.7' OR l_compat_vers = '8.1.7' THEN
    -- 9.0.1, check if utl_file_dir has oracle_home/livelink/data in the path
    -- enumerate the four possible cases for this directory to be in utl_file_dir
      select count(*) into l_reqd_utl_file_dir_cnt 
        from v$parameter where lower(name)= 'utl_file_dir' 
        and value like '&LIVELINK_DATA_DIR'  -- single dir
        or  value like '&LIVELINK_DATA_DIR, %'  -- the start dir
        or  value like '%, &LIVELINK_DATA_DIR'  -- the last dir
        or  value like '%, &LIVELINK_DATA_DIR, %';  -- the middle dir
      IF l_reqd_utl_file_dir_cnt = 0 THEN
        RAISE_APPLICATION_ERROR(-20000,'Add &LIVELINK_DATA_DIR to the UTL_FILE_DIR, restart the database and then rerun collectconfig.sql.');
      END IF;
    ELSE
      select count(*) into l_dirobj_cnt from  dba_directories where DIRECTORY_NAME ='&CONFIG_DIR_NAME';
      IF l_dirobj_cnt = 0 THEN
        execute immediate 'CREATE OR REPLACE DIRECTORY &CONFIG_DIR_NAME AS ''&LIVELINK_DATA_DIR''';
        l_b_commit := TRUE;
      END IF;
      select count(*) into l_dirobj_priv_cnt from dba_tab_privs where GRANTEE ='&APPS_USER' and TABLE_NAME='&CONFIG_DIR_NAME' and upper(PRIVILEGE) = 'READ';
      IF l_dirobj_priv_cnt = 0 THEN
        execute immediate 'GRANT READ ON DIRECTORY &CONFIG_DIR_NAME TO &APPS_USER';
        l_b_commit := TRUE;
      END IF;
      select count(*) into l_dirobj_priv_cnt from dba_tab_privs where GRANTEE ='&APPS_USER' and TABLE_NAME='&CONFIG_DIR_NAME' and upper(PRIVILEGE) = 'WRITE';
      IF l_dirobj_priv_cnt = 0 THEN
        execute immediate 'GRANT WRITE ON DIRECTORY &CONFIG_DIR_NAME TO &APPS_USER';
        l_b_commit := TRUE;
      END IF;

      --14234278
      select count(*) into l_dirobj_priv_cnt from dba_tab_privs where GRANTEE ='ORACLE_OCM' and TABLE_NAME='&CONFIG_DIR_NAME' and upper(PRIVILEGE) = 'READ';
      IF l_dirobj_priv_cnt = 0 THEN
        execute immediate 'GRANT READ ON DIRECTORY &CONFIG_DIR_NAME TO ORACLE_OCM';
        l_b_commit := TRUE;
      END IF;
      select count(*) into l_dirobj_priv_cnt from dba_tab_privs where GRANTEE ='ORACLE_OCM' and TABLE_NAME='&CONFIG_DIR_NAME' and upper(PRIVILEGE) = 'WRITE';
      IF l_dirobj_priv_cnt = 0 THEN
        execute immediate 'GRANT WRITE ON DIRECTORY &CONFIG_DIR_NAME TO ORACLE_OCM';
        l_b_commit := TRUE;
      END IF;




      -- select on dba_registry needed for XML DB check
      select count(*) into l_dirobj_priv_cnt from dba_tab_privs where GRANTEE ='&APPS_USER' and TABLE_NAME='DBA_REGISTRY' and upper(PRIVILEGE) = 'SELECT';
      IF l_dirobj_priv_cnt = 0 THEN
        execute immediate 'GRANT SELECT ON DBA_REGISTRY TO &APPS_USER';
        l_b_commit := TRUE;
      END IF;

      IF l_b_commit THEN
        COMMIT;
      END IF;
    END IF;
    EXCEPTION
      WHEN OTHERS THEN
        RAISE_APPLICATION_ERROR(-20001,SQLERRM);
  END;
END;
/
/*
DECLARE
  l_file_handle utl_file.file_type;
BEGIN
  BEGIN
    l_file_handle := utl_file.fopen('&LIVELINK_DATA_DIR', 'dummy', 'A');
    utl_file.fclose(l_file_handle);
  EXCEPTION
    when utl_file.invalid_path then
      raise_application_error(-20000, 'Invalid path: ' || '&LIVELINK_DATA_DIR');
    when utl_file.file_open or utl_file.write_error then
      l_file_handle := NULL; -- It's ok!
    when others then
      raise_application_error(-20001, SQLERRM || '*** Hint: invalid LIVELINK_DATA_DIR value.');
  END;
END;
/
*/
SET ECHO OFF
connect &APPS_USER/"&APPS_USER_PWD"
SET ECHO ON

Rem
Rem Create package for apps user
Rem
@@ebs_ll_pkgdefs.sql
@@ebs_ll_pkgbodys.sql
@@ebs_lljob_pkgdefs.sql
@@ebs_lljob_pkgbodys.sql

set serveroutput on

execute MGMT_EBS_CONFIG.install_job;
execute MGMT_EBS_CONFIG.run_now;

exit;
