Rem
Rem $Header: emll/admin/scripts/ebs_dropccr.sql /main/8 2010/11/17 12:30:44 fmorshed Exp $
Rem
Rem ebs_dropccr.sql
Rem
Rem Copyright (c) 2005, 2010, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      ebs_dropccr.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Uninstall EBS components for CCR. Must execute this procedure
Rem	 as a user with sysdba privilege.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    fmorshed  10/28/10 - Change EBS_LL_CONFIG_DIR to ORACLE_OCM_CONFIG_DIR
Rem                         so db, ebs, and gc all use the same directory
Rem                         object.
Rem    pparida   06/04/09 - 8268571: Check for compatible param too.
Rem    kgupta    03/14/07 - Suppress echoing old and new values of subsituted
Rem                         variables (bug#5867702)
Rem    kgupta    12/26/06 - Set echo off by default
Rem    ppradhan  03/23/06 - For fixing bug 5109585 
Rem    ppradhan  12/22/05 - Remove whenever sqlerror continue 
Rem    ppradhan  12/21/05 - Fix for bug 4768878 
Rem    kkapur	   10/11/05 - Created
Rem    kkapur	   10/12/05 - Added drop package ...
Rem

SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100
SET VERIFY OFF

define APPS_USER                       = "&1"


DECLARE
  l_vers         v$instance.version%TYPE;
  l_compat_vers     v$parameter.value%TYPE;
  l_dirobj_cnt   NUMBER;
BEGIN
   select substr(version,1,5) into l_vers from v$instance;
   begin
     select substr(value,1,5) into l_compat_vers from v$parameter where lower(name) = 'compatible';
   exception
     WHEN NO_DATA_FOUND THEN
       l_compat_vers := l_vers;
   end;
   IF l_vers != '9.0.1' AND l_vers != '8.1.7' AND l_compat_vers != '8.1.7' THEN
   	select count(*) into l_dirobj_cnt from  dba_directories where DIRECTORY_NAME ='ORACLE_OCM_CONFIG_DIR';
       	IF l_dirobj_cnt = 1 THEN
       		execute immediate 'DROP DIRECTORY ORACLE_OCM_CONFIG_DIR';
        END IF;
   END IF;
END;
/



set serveroutput on

declare
  l_ebsjob_cnt NUMBER;
  l_ebsconfigpkg_cnt NUMBER;
  l_ebsllmetricspkg_cnt NUMBER;
  l_vers v$instance.version%TYPE;
  l_compat_vers     v$parameter.value%TYPE;
begin
 select substr(version,1,5) into l_vers from v$instance;
 begin
   select substr(value,1,5) into l_compat_vers from v$parameter where lower(name) = 'compatible';
 exception
   WHEN NO_DATA_FOUND THEN
     l_compat_vers := l_vers;
 end;

 select count(*) into l_ebsconfigpkg_cnt from all_objects where object_name = 'MGMT_EBS_CONFIG' and object_type='PACKAGE' and owner = upper('&APPS_USER');
 IF l_ebsconfigpkg_cnt > 0 THEN
   select count(*) into l_ebsjob_cnt from dba_jobs where what like 'MGMT_EBS_LL_METRICS.collect_config_metrics%' and schema_user = upper('&APPS_USER');

   --
   -- As fix for bug 5109585, adding check for 8.1.7 as the SYSDBA user does
   -- not see the APPS job in 8.1.7, hence the stop_job API throws an
   -- exception.
   --   
   IF l_ebsjob_cnt > 0 AND l_vers != '8.1.7' AND l_compat_vers != '8.1.7' THEN
     execute immediate 'begin ' || '&APPS_USER' || '.MGMT_EBS_CONFIG.stop_job; end;';      
   END IF;
   execute immediate 'drop package ' || '&APPS_USER' || '.MGMT_EBS_CONFIG';
 END IF;

 select count(*) into l_ebsllmetricspkg_cnt from all_objects where object_name = 'MGMT_EBS_LL_METRICS' and object_type='PACKAGE' and owner = upper('&APPS_USER');
 IF l_ebsllmetricspkg_cnt > 0 THEN
   execute immediate 'drop package ' || '&APPS_USER' || '.MGMT_EBS_LL_METRICS';
 END IF;

end;
/

set echo off
prompt
prompt   Drop EBS CCR complete. 
prompt

