REM
REM $Header: emll/admin/scripts/ebs_ll_pkgbodys.sql /main/37 2011/12/06 09:20:23 jsutton Exp $
REM
REM Copyright (c) 2005, 2011, Oracle and/or its affiliates. 
REM All rights reserved. 
REM
REM    NAME
REM      ebs_ll_pkgbodys.sql
REM
REM    DESCRIPTION
REM      n/a
REM
REM    NOTES
REM      n/a
REM
REM    MODIFIED   (MM/DD/YY)
REM    jsutton     12/01/11 - catch exceptions around calls to UTL_FILE
REM    jsutton     03/07/11 - Flush output so as not to consume PGA per bug
REM                           8738709
REM    aghanti     10/26/10 - Bumping up META_VER
REM    aghanti     10/14/10 - Bug 9033775 - Write end marker to
REM                           .ll*/.ccr/.emrep file
REM    rlandows    08/23/10 - fix for 9880657
REM    jsutton     08/04/10 - Add check for XMLDB around calls to UTL_INADDR
REM    rlandows    04/08/10 - to fix 9552245
REM    aghanti     09/17/09 - Bump up META_VER to 10.3.3.0.0
REM    jsutton     07/24/09 - catch exceptions when writing header
REM    jsutton     06/10/09 - Add IP address info to data
REM    rlandows    05/27/09 - to fix 7113315
REM    aghanti     04/26/09 - Collect NLS_CHARACTERSET & add it as config
REM                           property to .ll file
REM    glavash     12/12/07 - update metadata version
REM    glavash     12/12/07 - escape seperators
REM    pferguso    07/23/07 - 5886369: No longer using DBA_PROCEDURES to check
REM                           version of OWA_UTIL
REM    ppradhan    09/17/06 - Updating version to 10.2.4
REM    ppradhan    06/22/06 - To add ad_bugs metric 
REM    ppradhan    04/06/06 - Updating version to 10.2.3 
REM    ppradhan    03/23/06 - For fixing bug 5109585 
REM    ppradhan    03/08/06 - Added -RAC for cm ll file if rac database 
REM    ppradhan    03/08/06 - Fix for bug 5030010 
REM    ppradhan    03/10/06 - Fixing bug 5084698 
REM    ppradhan    03/09/06 - Fix for bug 5084719
REM    ppradhan    03/06/06 - For removing metric registered oracle users per 
REM                           bug 5060966  
REM    ppradhan    03/07/06 - Fix for bug 4743782 
REM    ppradhan    03/06/06 - Minor modifications per code review 
REM    ppradhan    03/05/06 - Fixing bug 5060894 
REM    ppradhan    02/14/06 - XbranchMerge ppradhan_bug-5038392 from 
REM                           st_emll_10.2.2 
REM    ppradhan    02/14/06 - To fix timestamp format for collection timestamp 
REM    dkapoor     12/06/05 - update versions 
REM    ppradhan    11/14/05 - Added fix for bug 4737737
REM    fle         11/04/05 - Collect applied_patches and comprising_patches in 12 months.
REM    fle         10/28/05 - Disable metric 'applied_forms_versions'.
REM    fle         10/20/05 - Change 1001 to 10001.
REM    fle         10/12/05 - Change 'TO_CHAR(current_timestamp' to 'TO_CHAR(sysdate'
REM    fle         09/16/05 - Added ad_comprising_patches metric
REM    fle         09/11/05 - Added new metrics
REM

CREATE OR REPLACE PACKAGE body MGMT_EBS_LL_METRICS AS

g_config_handle UTL_FILE.FILE_TYPE := NULL;

METRIC_END_MARKER constant VARCHAR2(4) := ':End';
METRIC_BEGIN_MARKER constant VARCHAR2(6) := ':Begin';
ORACLE_EBS_META_VER CONSTANT VARCHAR(17) := '10.3.5.0.0';

/*
Put marker for the metric	
*/
PROCEDURE  put_metric_marker( marker in VARCHAR2, metric in VARCHAR2)
IS
BEGIN
    UTL_FILE.PUT_LINE(g_config_handle,metric||marker);
END put_metric_marker;

/*
 Generic function to write to the config dump file
*/
PROCEDURE  write_metric( metric IN VARCHAR2,query  IN VARCHAR2, separator IN VARCHAR2 default '|')
IS
    l_em_result_cur INTEGER DEFAULT DBMS_SQL.OPEN_CURSOR;
    l_col_cnt       NUMBER DEFAULT 0;
    l_columnValue   VARCHAR2(4000);
    l_status        NUMBER ;
    l_begin_done    BOOLEAN DEFAULT FALSE;
    l_end_done      BOOLEAN DEFAULT FALSE;
BEGIN
   BEGIN
    dbms_sql.parse(l_em_result_cur,  query, dbms_sql.native );

   /* define all the columns */
    FOR i IN 1 .. 255 LOOP
        BEGIN
            dbms_sql.define_column( l_em_result_cur, i, l_columnValue, 4000 );
            l_col_cnt := i;
        EXCEPTION
            WHEN OTHERS THEN
                IF ( sqlcode = -1007 ) THEN exit; 
                ELSE
                    RAISE;
                END IF;
        END;
    END LOOP;

    dbms_sql.define_column( l_em_result_cur, 1, l_columnValue, 4000 );
    l_status := DBMS_SQL.EXECUTE (l_em_result_cur);

    put_metric_marker(METRIC_BEGIN_MARKER,metric);
    l_begin_done := TRUE;
    LOOP
        exit when ( dbms_sql.fetch_rows(l_em_result_cur) <= 0 );
        UTL_FILE.PUT( g_config_handle, 'em_result=');
        FOR i IN 1 .. l_col_cnt LOOP
	    IF i != 1 THEN
            	UTL_FILE.PUT( g_config_handle, separator);
	    END IF;
            dbms_sql.column_value( l_em_result_cur, i, l_columnValue );
            /* replace seperators with escaped separators */
            l_columnValue := replace(l_columnValue,'#','##');
            l_columnValue := replace(l_columnValue,separator,'#'|| separator);
 
            UTL_FILE.PUT( g_config_handle, l_columnValue );
        END LOOP;
        UTL_FILE.NEW_LINE(g_config_handle );
    END LOOP;

    dbms_sql.close_cursor(l_em_result_cur);

   /* Should be the last callout in the block*/
    put_metric_marker(METRIC_END_MARKER,metric);
    l_end_done   := TRUE;
  EXCEPTION
	WHEN UTL_FILE.INVALID_FILEHANDLE OR UTL_FILE.INVALID_OPERATION OR UTL_FILE.WRITE_ERROR THEN
		IF DBMS_SQL.IS_OPEN(l_em_result_cur) = TRUE
		THEN
    			dbms_sql.close_cursor(l_em_result_cur);
		END IF;
		RAISE;
    	WHEN OTHERS THEN
		IF DBMS_SQL.IS_OPEN(l_em_result_cur) = TRUE
		THEN
    			dbms_sql.close_cursor(l_em_result_cur);
		END IF;
		/*
		On any non-utl file exceptions, log as em_error
		for the metric.
		If the BEGIN marker is not write, need to write it.
		If the END marker is not write, need to write it.
		There won't be the case that END marker is written and we reach HERE.
		*/
		IF not l_begin_done THEN
    			put_metric_marker(METRIC_BEGIN_MARKER,metric);
		END IF;
    		UTL_FILE.PUT_LINE(g_config_handle,'em_error=' || 'SQLERRM: '
					|| SQLERRM || ' SQLCODE: ' 
					|| SQLCODE);
		IF l_end_done  THEN
			RAISE;
		END IF;
    		put_metric_marker(METRIC_END_MARKER,metric);
  END;
  UTL_FILE.FFLUSH(g_config_handle);
END write_metric;

/*
Internal API to check if a column exists in a table
*/
function does_column_exist (
	p_table varchar2, p_column varchar2) return boolean 
IS
   v_cnt number := 0;
BEGIN
   -- Using all_tab_columns instead of all_tab_cols as all_tab_cols
   -- did not exist in 8.1.7
   select count(*) into v_cnt from all_tab_columns 
	where table_name = p_table
	and column_name = p_column;
   if (v_cnt > 0) then
     return true;
   end if;
   return false;
END does_column_exist;

/*
Internal API to check if an object exists
*/
function does_object_exist (
	p_object_name varchar2, p_object_type varchar2) return boolean
IS
  v_cnt number := 0;  
BEGIN
  select count(*) into v_cnt from all_objects 
	where object_name = p_object_name
	and object_type = p_object_type;
  if (v_cnt > 0) then
     return true;
  end if;
  return false;
END does_object_exist;

/*
Private procedure
Collect metric=apps_summary
*/
procedure collect_apps_summary IS
BEGIN
    write_metric('apps_summary',
		'select applications_system_name, release_name, multi_org_flag, multi_lingual_flag, multi_currency_flag from fnd_product_groups');
END collect_apps_summary;


--added for 7113315
procedure get_context_values (p_context_file in clob,
                              p_support_admin out varchar2,
                              p_support_cp out varchar2,
                              p_support_forms out varchar2,
                              p_support_web out varchar2) is


  l_parser xmlParser.parser;
  l_doc xmldom.domdocument;
  
  l_node_list xmldom.DOMNodeList;
  
  l_list_length number;

  l_temp_node xmldom.DOMNode;
  l_child_node xmldom.DOMNode;
  l_att_node xmldom.domnode;

  l_var varchar2(100);
  l_value varchar2(100);
  l_att_map xmldom.DOMNamedNodeMap;



  s_root_status varchar2(20);
  s_batch_status varchar2(20);
  s_web_applications_status varchar2(20);
  s_web_entry_status varchar2(20);


BEGIN


  l_parser := xmlparser.newParser;
  xmlparser.parseClob(l_parser, p_context_file);
  l_doc := xmlparser.getDocument(l_parser);


  l_node_list := xmldom.getElementsByTagName(l_doc,'oa_service_group_status');



  l_list_length := xmldom.getLength(l_node_list);


  for i in 0 .. l_list_length-1 loop

    l_temp_node := xmldom.item(l_node_list, i);

    l_att_map := xmldom.getAttributes(l_temp_node);
    l_att_node := xmldom.getNamedItem(l_att_map,'oa_var');
    l_var := ltrim(rtrim(xmldom.getNodevalue(l_att_node)));
    l_child_node := xmldom.getFirstChild(l_temp_node);
    l_value := ltrim(rtrim(xmldom.getNodeValue(l_child_node)));  --enabled/disabled



    if (l_var = 's_root_status') then
      s_root_status := l_value;
    elsif (l_var = 's_web_entry_status') then
      s_web_entry_status := l_value;
    elsif (l_var = 's_web_applications_status') then
      s_web_applications_status := l_value;
    elsif (l_var = 's_batch_status') then
      s_batch_status := l_value;
    end if;

  end loop;


  if s_batch_status = 'enabled' then
    p_support_cp := 'Y';
  else
    p_support_cp := 'N';
  end if;


  if s_root_status = 'enabled' then
    p_support_admin := 'Y';
    if s_web_applications_status = 'enabled' then
      p_support_forms := 'Y';
    else
      p_support_forms := 'N';
    end if;

    if s_web_entry_status = 'enabled' then
      p_support_web := 'Y';
    else
      p_support_web := 'N';
    end if;

  else

    p_support_admin := 'N';
    p_support_forms := 'N';
    p_support_web := 'N';

  end if;


END;

/*
Private procedure
Collect metric=apps_topology
*/
procedure collect_apps_topology IS

  l_release varchar2(50);
  l_context_file clob;
 
  stmt_nodes varchar2(500);
  stmt_ctx varchar2(500);
  stmt_count varchar2(500);

  
  type t_crs is ref cursor;
  nodecrs  t_crs;
  
  
  l_ctx_type varchar2(1);
  
  l_node_name varchar2(512);
  l_count integer;
  
  l_support_admin varchar2(1);
  l_support_db varchar2(1);
  l_support_cp varchar2(1);
  l_support_forms varchar2(1);
  l_support_web varchar2(1);
  l_platform varchar2(80);

BEGIN

  --all the r12 stuff below added for bug 7113315
  execute immediate 'select release_name from fnd_product_groups' into l_release;

  if(substrb(l_release,0,2)='12') then

    put_metric_marker(METRIC_BEGIN_MARKER,'apps_topology');
    
    
    stmt_nodes := 'select upper(node_name), fl.meaning, support_db from fnd_nodes fn, fnd_lookups fl '||
                  'where upper(fn.node_mode) = ''O'' and fl.lookup_code = fn.platform_code '||
                  'and (upper(fn.support_cp) = ''Y'' or upper(fn.support_forms) = ''Y'' or upper(fn.support_web) = ''Y'' ' ||
                  'or upper(fn.support_admin) = ''Y'' or upper(fn.support_db) = ''Y'') '||
                  'and upper(fl.lookup_type) =''PLATFORM'' ';
    
    
    stmt_count := 'SELECT count(*) FROM fnd_oam_context_files WHERE status in (''S'',''F'') '||
                  'and name not in (''METADATA'', ''TEMPLATE'') and ctx_type in (''A'',''D'') '||
                  'and upper(node_name) = :1';

    
    --9552245, modified so we don't error when fnd_oan_context_files is corrupted
    stmt_ctx := 'select text from('||
                'SELECT text ' ||
                'FROM fnd_oam_context_files '||
                'WHERE status in (''S'',''F'') and name not in (''METADATA'', ''TEMPLATE'') '||
                'and ctx_type = ''A'' and upper(node_name) = :1 order by last_update_date desc '||
                ') where rownum=1'; 
    
    --9880657, putting code below into a block to catch any exceptions (such as bad xml for context file)
    begin
    
      open nodecrs for stmt_nodes;
      loop
        fetch nodecrs into l_node_name, l_platform, l_support_db;
        exit when nodecrs%notfound;
            
        begin
          execute immediate stmt_count into l_count using l_node_name;
        exception
          when others then l_count:=0;
        end;

        if(l_support_db = 'Y' AND l_count = 1) then
        --only a db node
          UTL_FILE.PUT_LINE(g_config_handle,'em_result=' ||l_node_name || '|' || l_platform || '|' || 'N' || '|' ||
                                           l_support_db || '|' || 'N' || '|' || 'N' || '|' || 'N');
                                           
        elsif (l_count > 0) then  --this condition is here just in case fnd_oam_context_files is missing data (should never happen)
        --node could contain a db and mid tier, or just a mid tier
          execute immediate stmt_ctx into l_context_file using l_node_name;
          get_context_values(l_context_file, l_support_admin, l_support_cp, l_support_forms,l_support_web);
          UTL_FILE.PUT_LINE(g_config_handle,'em_result=' ||l_node_name || '|' || l_platform || '|' || l_support_admin || '|' ||
                                           l_support_db || '|' || l_support_cp || '|' || l_support_forms || '|' || l_support_web);
      
        end if;
    
      end loop;
      close nodecrs;

      put_metric_marker(METRIC_END_MARKER,'apps_topology');
    exception
      when others then 
      put_metric_marker(METRIC_END_MARKER,'apps_topology');
    end;

    UTL_FILE.FFLUSH(g_config_handle);

  else --not release 12

    if (does_column_exist('FND_NODES','SUPPORT_DB') = true) then
      write_metric('apps_topology',
		'select node_name, fl.meaning platform, support_admin admin,support_db database,support_cp cp , support_forms forms, support_web web from fnd_nodes fn, fnd_lookups fl where upper(fn.node_mode) = ''O'' and (upper(fn.support_cp) = ''Y'' or upper(fn.support_forms) = ''Y'' or upper(fn.support_web) = ''Y'' or upper(fn.support_admin) = ''Y'' or upper(fn.support_db) = ''Y'' ) and fl.lookup_code = fn.platform_code and upper(fl.lookup_type) =''PLATFORM''');
    else
      write_metric('apps_topology',
		'select node_name, fl.meaning platform, support_admin admin,'''' database,support_cp cp , support_forms forms, support_web web from fnd_nodes fn, fnd_lookups fl where upper(fn.node_mode) = ''O'' and (upper(fn.support_cp) = ''Y'' or upper(fn.support_forms) = ''Y'' or upper(fn.support_web) = ''Y'' or upper(fn.support_admin) = ''Y'' ) and fl.lookup_code = fn.platform_code and upper(fl.lookup_type) =''PLATFORM''');
    end if;

  end if;
END collect_apps_topology;


/*
Private procedure
Collect metric=patchset_info
*/
--7148849, modified to include projects pseudo products
procedure collect_patchset_info IS
BEGIN
  write_metric('patchset_info',
    'select application_short_name, APPLICATION_NAME, patch_level, to_char(pi.creation_date, ''yyyy-MM-dd HH:mm:ss'') creation_date, product_version, status Status from FND_PRODUCT_INSTALLATIONS pi , fnd_application_vl  app where pi.APPLICATION_ID = app.APPLICATION_ID union SELECT DECODE(fpo.profile_option_name,''PA_COSTING_LICENSED'',''PJC'', ''PA_PJT_LICENSED'', ''PJT'', ''PA_BILLING_LICENSED'', ''PJB'', ''PA_PJL_LICENSED'', ''PJL'', ''PA'') application_short_name, DECODE(fpo.profile_option_name, ''PA_COSTING_LICENSED'', ''Oracle Project Costing'', ''PA_PJT_LICENSED'', ''Oracle Project Management'', ''PA_BILLING_LICENSED'', ''Oracle Project Billing'', ''PA_PJL_LICENSED'', ''Oracle Project Collaboration'', NULL) APPLICATION_NAME, patch_level, TO_CHAR(fi.creation_date, ''yyyy-MM-dd HH:mm:ss'') creation_date, product_version, DECODE(fpov.profile_option_value,''N'',''N'', ''Y'',''I'', ''N'') Status FROM fnd_profile_option_values fpov, fnd_profile_options fpo, fnd_application fa, fnd_product_installations fi WHERE fa.application_id = fpo.application_id AND fa.application_short_name = ''PA'' AND fi.application_id= fa.application_id AND fpov.level_id(+)= 10001 AND fpov.profile_option_id(+) = fpo.profile_option_id AND fpo.profile_option_name  IN (''PA_COSTING_LICENSED'', ''PA_PJT_LICENSED'', ''PA_BILLING_LICENSED'', ''PA_PJL_LICENSED'') order by application_name');
END collect_patchset_info;


/*
Private procedure
Collect metric=process_mfg
*/
procedure collect_process_mfg IS
BEGIN
    write_metric('process_mfg',
        'select decode(count(1), 9, ''In Use.'', ''Not In Use.'') as usage_yes_no from all_users where username in (''GMA'', ''GMI'', ''GMD'', ''GME'', ''GMP'', ''GMF'', ''GML'', ''GR'', ''PMI'')');
END collect_process_mfg;


/*
Private procedure
Collect metric=nls_language
*/
procedure collect_nls_languages IS
BEGIN
    write_metric('nls_languages',
        'select installed_flag, language_code as Language_Code, nls_language as NLS_Language from fnd_languages where installed_flag in (''I'', ''B'')');
END collect_nls_languages;


/*
Private procedure
Collect metric=character_set
*/
procedure collect_character_set IS
BEGIN
    write_metric('character_set',
        'select userenv(''LANGUAGE'') as EBS_Lang_Characterset from dual');
END collect_character_set;


/*
Private procedure
Collect metric=nls_date_format
*/
procedure collect_nls_date_format IS
BEGIN
    write_metric('nls_date_format',
        'select value as NLS_Date_Format from V$NLS_PARAMETERS where parameter = ''NLS_DATE_FORMAT''');
END collect_nls_date_format;


/*
Private procedure
Collect metric=localization_modules
*/
procedure collect_localization_modules IS
BEGIN
    write_metric('localization_modules',
        'select fav.application_short_name,
           fou.oracle_username as Oracle_User_Name, 
           fmi.module_short_name, 
           fmi.module_version, 
           fmi.status, 
           to_char(fmi.last_update_date, ''yyyy-MM-dd HH:mm:ss'') last_update_date
         from fnd_oracle_userid fou, fnd_application_vl fav, fnd_module_installations fmi where fmi.application_id = fav.application_id(+) and fmi.oracle_id = fou.oracle_id(+) and fmi.status = ''I''');
END collect_localization_modules;


/*
Private procedure
Collect metric=data_groups
*/
procedure collect_data_groups IS
BEGIN
    write_metric('data_groups',
        'select data_group_id, 
           data_group_name, 
           default_group_flag,
           to_char(creation_date, ''yyyy-MM-dd HH:mm:ss'') creation_date
         from fnd_data_groups');
END collect_data_groups;


/*
Private procedure
Collect metric=profile_options
*/
procedure collect_profile_options IS
BEGIN
  write_metric('profile_options',
   'SELECT
      fpo.profile_option_name,
      fpo.profile_option_id,
      replace(fpov.profile_option_value, ''|'', ''pipe''),
      fpov.level_id,
      fa.application_short_name,
      substr(fpot.user_profile_option_name, 1, 80),
      null,
      fpot.description
    FROM FND_PROFILE_OPTIONS_VL fpot, FND_PROFILE_OPTIONS fpo, FND_PROFILE_OPTION_VALUES fpov, fnd_application fa
    WHERE fpot.profile_option_name = fpo.profile_option_name
            AND fpo.application_id = fpov.application_id
            AND fpo.application_id = fa.application_id
            AND fpo.profile_option_id= fpov.profile_option_id
            AND fpov.level_id= 10001
   ');
END collect_profile_options;


/*
Private procedure
Collect metric=cust_app_prof_opts
*/
procedure collect_cust_app_prof_opts IS
BEGIN
  write_metric('cust_app_prof_opts',
   'SELECT
      fpo.profile_option_name,
        fna.application_short_name,
        fpo.user_profile_option_name,
        DECODE( FPO.SQL_VALIDATION, NULL, ''No'', ''Yes'' ) AS SQL_Validation,
        fpo.description
FROM  FND_PROFILE_OPTIONS_VL fpo, FND_APPLICATION  fna
WHERE FNA.APPLICATION_ID = FPO.APPLICATION_ID
AND FNA.APPLICATION_ID > 19999
ORDER BY
DECODE( FPO.SQL_VALIDATION, NULL, ''No'', ''Yes'' ), fna.application_short_name, fpo.profile_option_name');
END collect_cust_app_prof_opts;


/*
Private procedure
Collect metric=reg_oracle_users
*/
/* commented out per bug 5060966
procedure collect_reg_oracle_users IS
BEGIN
    write_metric('reg_oracle_users',
        'SELECT fou.oracle_username AS Oracle_User_Name,
        fou.install_group_num AS Install_Group_Number,
        fou.read_only_flag,
        DECODE(NVL(du.username,'' X ''),'' X '',''No'',''Yes'') AS In_Dba_Users,
              NVL(du.default_tablespace,''UNKNOWN'') AS Default_Tablespace,
              NVL(du.temporary_tablespace,''UNKNOWN'') AS Temporary_Tablespace
        FROM DBA_USERS du, FND_ORACLE_USERID fou
        WHERE du.username(+) = fou.oracle_username');
END collect_reg_oracle_users;
*/

/*
Private procedure
Collect metric=active_users
*/
/*
procedure collect_active_users IS
BEGIN
    write_metric('active_users',
        'SELECT COUNT( 1 ) Num_Of_Active_Users
         FROM FND_USER
         WHERE ( END_DATE > SYSDATE OR END_DATE IS NULL )');
END collect_active_users;
*/

/*
Private procedure
Collect metric=enddated_users
*/
/*
procedure collect_enddated_users IS
BEGIN
  write_metric('enddated_users',
   'SELECT count(1) num_of_enddated_users 
    FROM fnd_user FU
    WHERE TRUNC(NVL(end_date,SYSDATE)) < TRUNC(SYSDATE)
         ORDER BY FU.end_date ASC');
END collect_enddated_users;
*/

/*
Private Procedure
Collects metrics active_users *AND* enddated_users
Added as a fix for bug 5084698 to avoid a full table scan
on fnd_users
*/
procedure collect_user_metrics IS
 v_active_users number;
 v_enddated_users number;
BEGIN
   -- First execute combined query to get both metric values
   select sum(decode(end_date, 
                   null,1, 
                   decode(greatest(end_date,sysdate), 
                        sysdate,0,1))) num_of_active_users, 
       sum(decode(end_date, 
                  null,0, 
                   decode(greatest(trunc(end_date),trunc(sysdate)), 
                          trunc(sysdate),1,0))) num_of_enddated_users
		into v_active_users, v_enddated_users
   from fnd_user fu; 

   -- Now write out the metrics 
   UTL_FILE.PUT_LINE(g_config_handle, 'active_users:Begin');
   UTL_FILE.PUT_LINE(g_config_handle,'em_result=' || v_active_users);
   UTL_FILE.PUT_LINE(g_config_handle, 'active_users:End');

   UTL_FILE.PUT_LINE(g_config_handle, 'enddated_users:Begin');
   UTL_FILE.PUT_LINE(g_config_handle,'em_result=' || v_enddated_users);
   UTL_FILE.PUT_LINE(g_config_handle, 'enddated_users:End');

   UTL_FILE.FFLUSH(g_config_handle);

END collect_user_metrics;

/*
Private procedure
Collect metric=printers
*/
procedure collect_printers IS
BEGIN
    write_metric('printers',
        'SELECT printer_name, printer_type
         FROM FND_PRINTER
         WHERE created_by != 1 AND LAST_UPDATED_BY != 1');
END collect_printers;


/*
Private procedure
Collect metric=printer_drivers
*/
procedure collect_printer_drivers IS
BEGIN
    write_metric('printer_drivers',
        'SELECT user_printer_driver_name AS Printer_Driver_Name,Description
         FROM FND_PRINTER_DRIVERS
         WHERE created_by != 1 AND LAST_UPDATED_BY != 1');
END collect_printer_drivers;


/*
Private procedure
Collect metric=cust_apps
*/
procedure collect_cust_apps IS
BEGIN
    write_metric('cust_apps',
        'SELECT APPLICATION_SHORT_NAME, APPLICATION_NAME, BASEPATH
         FROM FND_APPLICATION_VL  FA
         WHERE APPLICATION_ID > 19999
         ORDER BY APPLICATION_SHORT_NAME');
END collect_cust_apps;


/*
Private procedure
Collect metric=cust_alerts
*/
procedure collect_cust_alerts IS
BEGIN
    write_metric('cust_alerts',
        'SELECT aal.alert_name, ''Alert'' AS ALERT, 
           fna.application_short_name AS Application_Name,
           aal.table_name,
           aal.description
         FROM alr_alerts aal, fnd_application fna
         WHERE fna.application_id = aal.application_id
           AND AAL.ENABLED_FLAG = ''Y''
           AND AAL.LAST_UPDATED_BY NOT IN ( 1, 2, 3) 
        ORDER BY 1');
END collect_cust_alerts;


/*
Private procedure
Collect metric=cust_triggers
*/
procedure collect_cust_triggers IS
BEGIN
  write_metric('cust_triggers',
   'SELECT AT.TRIGGER_NAME, 
      ''TRIGGER'' AS object_type,
      AT.OWNER, 
      AT.STATUS
    FROM ALL_TRIGGERS  AT
         WHERE SUBSTR( AT.TRIGGER_NAME, 1, INSTR(AT.TRIGGER_NAME, ''_'') - 1 ) 
         IN (
         SELECT SUBSTR( FA.BASEPATH, 1, INSTR( FA.BASEPATH, ''_'' ) - 1 )
         FROM FND_APPLICATION_VL  FA
         WHERE APPLICATION_ID > 19999
         UNION SELECT ''XX'' FROM DUAL)
         ORDER BY AT.STATUS, AT.OWNER, AT.TRIGGER_NAME');
END collect_cust_triggers;


/*
Private procedure
Collect metric=cust_workflows
*/
procedure collect_cust_workflows IS
BEGIN
    write_metric('cust_workflows',
        'SELECT DISTINCT wit.name AS Object,
           ''Workflow'' AS Type,
           REPLACE(WIT.DESCRIPTION,CHR(10),'','') AS Description
         FROM WF_ACTIVITIES_VL WAV, WF_ITEM_TYPES_VL WIT
         WHERE WAV.ITEM_TYPE = WIT.NAME
           AND WAV.END_DATE IS NOT NULL
           AND WAV.CUSTOM_LEVEL >= 100');
END collect_cust_workflows;


/*
Private procedure
Collect metric=cust_db_objects
*/
procedure collect_cust_db_objects IS
BEGIN
    write_metric('cust_db_objects',
        'SELECT alo.object_name, alo.object_type,
           alo.owner, alo.status
         FROM all_objects alo
         WHERE SUBSTR( alo.object_name, 1, INSTR( alo.object_name, ''_'' ) - 1 ) IN (
           SELECT SUBSTR( FA.BASEPATH, 1, INSTR( FA.BASEPATH, ''_'' ) - 1 )
           FROM FND_APPLICATION_VL  FA
           WHERE APPLICATION_ID > 19999
           UNION SELECT ''XX'' FROM DUAL)
           AND ALO.OBJECT_TYPE != ''TRIGGER'' 
           AND OBJECT_TYPE !=''PACKAGE BODY''
           AND OBJECT_TYPE != ''SYNONYM''
           AND ALO.OWNER != ''APPS'' 
         ORDER BY alo.object_type, ALO.STATUS, alo.object_name');
END collect_cust_db_objects;


/*
Private procedure
Collect metric=cust_objs_apps_schema
*/
procedure collect_cust_objs_apps_schema IS
BEGIN
    write_metric('cust_objs_apps_schema',
        'SELECT alo.object_name,
       alo.object_type,
       alo.owner,
       alo.status
FROM   all_objects  alo
WHERE SUBSTR( ALO.OBJECT_NAME, 1, INSTR( ALO.OBJECT_NAME, ''_'' ) - 1 ) IN
(
SELECT
SUBSTR( FA.BASEPATH, 1, INSTR( FA.BASEPATH, ''_'' ) - 1 )
FROM FND_APPLICATION_VL  FA
WHERE APPLICATION_ID > 19999
UNION SELECT ''XX'' FROM DUAL
)
AND OWNER = ''APPS''
ORDER BY alo.object_type, ALO.STATUS,  alo.object_name');
END collect_cust_objs_apps_schema;


/*
Private procedure
Collect metric=cust_value_sets
*/
procedure collect_cust_value_sets IS
BEGIN
    write_metric('cust_value_sets',
        'SELECT  fvs.flex_value_set_name,
        fvs.description AS Description,
        fnl2.meaning
FROM   fnd_flex_value_sets  fvs
,      fnd_lookups  fnl2  -- validation_type
WHERE SUBSTR( FVS.FLEX_VALUE_SET_NAME, 1, INSTR( FVS.FLEX_VALUE_SET_NAME, ''_'' ) - 1 ) IN
(
SELECT
SUBSTR( FA.BASEPATH, 1, INSTR( FA.BASEPATH, ''_'' ) - 1 )
FROM FND_APPLICATION_VL  FA
WHERE APPLICATION_ID > 19999
UNION SELECT ''XX'' FROM DUAL
)
AND fvs.validation_type = ''F''
AND    fnl2.lookup_type = ''SEG_VAL_TYPES''
AND    fnl2.lookup_code = fvs.validation_type
ORDER BY fvs.flex_value_set_name, fnl2.meaning
');
END collect_cust_value_sets;


/*
Private procedure
Collect metric=other_customizations
*/
procedure collect_other_customizations IS
BEGIN
    write_metric('other_customizations',
        'SELECT FFFV.FUNCTION_NAME, USER_FUNCTION_NAME AS NAME,
        FFFV.TYPE,
        APPLICATION_NAME AS APPLICATION,
        WEB_HTML_CALL AS HTML_CALL
FROM
        FND_FORM_FUNCTIONS_VL FFFV 
        ,FND_APPLICATION_VL FAV
WHERE FFFV.APPLICATION_ID = FAV.APPLICATION_ID(+)
AND FFFV.TYPE != ''FORM''
AND FFFV.LAST_UPDATED_BY NOT IN ( 1, 2 )
ORDER BY FFFV.TYPE
');
END collect_other_customizations;


/*
Private procedure
Collect metric=cust_hooks
*/
procedure collect_cust_hooks IS
BEGIN
    write_metric('cust_hooks',
        'SELECT
        ''HR'' AS Module,
        CALL_PACKAGE,
        CALL_PROCEDURE
FROM
        HR_API_HOOK_CALLS
WHERE ENABLED_FLAG = ''Y''
AND CALL_PACKAGE LIKE ''XX%''');
END collect_cust_hooks;


/*
Private procedure
Collect metric=jtf_hooks
*/
procedure collect_jtf_hooks IS
BEGIN
    write_metric('jtf_hooks',
        'SELECT COUNT( 1 ) AS Num_Of_Custom_JTF_Hooks
         FROM JTF_USER_HOOKS
         WHERE PKG_NAME LIKE ''XX%''');
END collect_jtf_hooks;


/*
Private procedure
Collect metric=cust_request_sets
*/
procedure collect_cust_request_sets IS
BEGIN
  write_metric('cust_request_sets',
   'SELECT frl.request_set_name, frl.user_request_set_name,
      ''Request Set'' AS Request_set,
      fna.application_short_name
    FROM fnd_request_sets_VL frl, fnd_application fna
    WHERE  fna.application_id = frl.APPLICATION_ID
      AND FNA.APPLICATION_ID > 19999
      ORDER BY 1');
END collect_cust_request_sets;


/*
Private procedure
Collect metric=cust_audit_grps
*/
procedure collect_cust_audit_grps IS
BEGIN
    write_metric('cust_audit_grps',
        'SELECT fnt.table_name AS Table_Name,
         ''Table'' AS Table_Value,
       ''E'' AS E,
       fna.application_short_name AS Application_Short_Name,
       fag.group_name AS Group_Name,
      fag.description AS Description,
      fnt.user_table_name AS UserTable_Name
FROM  fnd_audit_groups  fag
,     fnd_audit_tables  fat
,     fnd_tables  fnt
,     fnd_application  fna
WHERE fna.application_id     = fat.table_app_id
AND   fnt.table_id           = fat.table_id
AND   fnt.application_id     = fat.table_app_id
AND   fag.audit_group_id     = fat.audit_group_id
AND   fag.application_id     = fat.audit_group_app_id
ORDER BY fnt.table_name');
END collect_cust_audit_grps;


/*
Private procedure
Collect metric=open_ifaces_in_use
*/
procedure collect_open_ifaces_in_use IS
BEGIN
  write_metric('open_ifaces_in_use',
   'SELECT DISTINCT FCP.CONCURRENT_PROGRAM_NAME AS Open_Interface_Pgm_Name,
      fcp.user_concurrent_program_name
FROM
     FND_CONCURRENT_REQUESTS FCR
     ,FND_CONCURRENT_PROGRAMS_VL FCP
WHERE
     fcp.concurrent_program_id=fcr.concurrent_program_id
AND  fcp.application_id=fcr.program_application_id
AND  concurrent_program_name IN (
        ''FAACCR''
        ,''FASCB''
        ,''FAMACR''
        ,''FAUPPR''
        ,''FARXPBSH''
        ,''GLBBSU''
        ,''GLLEZL''
        ,''INVCIINT''
        ,''INCDCM''
        ,''INCRVL''
        ,''INCTCM''
        ,''APXCCINV''
        ,''APXIIMPT''
        ,''PAXTRTRX''
        ,''RAXMTR''
        ,''APXXTR''
        ,''RVCTP''
        ,''RACUST''
        ,''INCOIN''
        ,''BMCOIN''
        ,''REQIMPORT''
        ,''ARPLABIM''
)');
END collect_open_ifaces_in_use;


/*
Private procedure
Collect metric=edi_progs_in_use
*/
procedure collect_edi_progs_in_use IS
BEGIN
    write_metric('edi_progs_in_use',
        'SELECT DISTINCT FCPV.USER_CONCURRENT_PROGRAM_NAME AS Program_Name
FROM
  FND_CONCURRENT_PROGRAMS_VL FCPV
 ,FND_CONCURRENT_REQUESTS FCR
 ,FND_APPLICATION FNA
WHERE FCPV.APPLICATION_ID=FNA.APPLICATION_ID
        AND FCPV.CONCURRENT_PROGRAM_ID = FCR.CONCURRENT_PROGRAM_ID
        AND FCPV.ENABLED_FLAG = ''Y''
        AND FNA.APPLICATION_SHORT_NAME = ''EC''');
END collect_edi_progs_in_use;


/*
Private procedure
Collect metric=cust_msg_count
*/
procedure collect_cust_msg_count IS
BEGIN
    write_metric('cust_msg_count',
        'SELECT APPLICATION_SHORT_NAME AS APPLICATION_SHORT_NAME, COUNT( 1 ) AS Num_Of_Custom_Messages
FROM FND_NEW_MESSAGES FM, FND_APPLICATION_VL FA
WHERE FM.APPLICATION_ID = FA.APPLICATION_ID
AND FM.CREATED_BY NOT IN ( 1, 2, 3, -1 ) 
GROUP BY FA.APPLICATION_SHORT_NAME');
END collect_cust_msg_count;


/*
Private procedure
Collect metric=cust_resp
*/
procedure collect_cust_resp IS
BEGIN
    write_metric('cust_resp',
        'SELECT APPLICATION_SHORT_NAME AS Application_Short_Name, COUNT( 1 ) AS Num_Of_User_Defined_Resp
FROM FND_RESPONSIBILITY FR, FND_APPLICATION_VL FA
WHERE FR.APPLICATION_ID = FA.APPLICATION_ID
AND FR.CREATED_BY NOT IN (1, 2, 3 )
GROUP BY FA.APPLICATION_SHORT_NAME');
END collect_cust_resp;


/*
Private procedure
Collect metric=cust_val_sets_x
*/
procedure collect_cust_val_sets_x IS
BEGIN
    write_metric('cust_val_sets_x',
        'SELECT fvs.flex_value_set_name,
               fvs.description AS Description,
               fnl2.meaning
        FROM   fnd_flex_value_sets  fvs
        ,      fnd_lookups  fnl2  -- validation_type
        WHERE SUBSTR( fvs.flex_value_set_name, 1, INSTR( fvs.flex_value_set_name, ''_'' ) - 1 ) IN
        (
        SELECT
        SUBSTR( FA.BASEPATH, 1, INSTR( FA.BASEPATH, ''_'' ) - 1 )
        FROM FND_APPLICATION_VL  FA
        WHERE APPLICATION_ID > 19999
        UNION SELECT ''XX'' FROM DUAL
        )
        AND fvs.validation_type <> ''F''
        AND    fnl2.lookup_type = ''SEG_VAL_TYPES''
        AND    fnl2.lookup_code = fvs.validation_type
        ORDER BY fnl2.meaning, fvs.flex_value_set_name');
END collect_cust_val_sets_x;


/*
Private procedure
Collect metric=apps_cust_forms
*/
procedure collect_apps_cust_forms IS
BEGIN
    write_metric('apps_cust_forms',
        'SELECT fm.menu_name,
       b.entry_sequence AS SEQUENCE,
       fm1.menu_name AS SUBMENU,
       fff.function_name,
       fff.type,
       t.prompt,
       t.description,
       fna.application_short_name,
       FF.FORM_NAME
  FROM FND_MENUS fm
, FND_MENUS fm1
, FND_MENU_ENTRIES_VL t
, FND_MENU_ENTRIES b
, FND_FORM FF
, FND_FORM_FUNCTIONS fff
, FND_APPLICATION fna
 WHERE fm.menu_id=t.menu_id
   AND fm1.menu_id=b.menu_id
   AND b.menu_id = t.menu_id
   AND T.PROMPT IS NOT NULL -- To select only those forms which have prompt(navigation)
   AND  b.entry_sequence = t.entry_sequence
   AND FF.APPLICATION_ID = FFF.APPLICATION_ID
   AND FF.FORM_ID = FFF.FORM_ID
   AND  fff.function_id=b.function_id
   AND  fff.application_id=fna.application_id
   AND FNA.APPLICATION_ID > 19999
ORDER BY FF.FORM_NAME');
END collect_apps_cust_forms;


/*
Private procedure
Collect metric=concurrent_progs
*/
procedure collect_concurrent_progs IS
BEGIN
    write_metric('concurrent_progs',
        'SELECT FCPV.USER_CONCURRENT_PROGRAM_NAME AS User_Concurrent_Program_Name,
       FLP.MEANING as type,
       ''M'' AS COMPLEXITY,
       ROUND( SUM((ACTUAL_COMPLETION_DATE - ACTUAL_START_DATE ) * 24 )/ COUNT(1 ), 4 ) AS Completion_time,
       FNA.APPLICATION_SHORT_NAME,
       FLP.MEANING AS Executable_Type,
       FEV.USER_EXECUTABLE_NAME AS Executable_Name,
       FNAX.APPLICATION_SHORT_NAME AS Executable_Application_Name,
       FEV.EXECUTION_FILE_NAME
FROM
  FND_CONCURRENT_PROGRAMS_VL FCPV
 ,FND_CONCURRENT_REQUESTS FCR
 ,FND_EXECUTABLES_VL  FEV
 ,FND_APPLICATION FNA
 ,FND_APPLICATION FNAX
 ,FND_LOOKUPS FLP
WHERE
        FNAX.APPLICATION_ID = FEV.APPLICATION_ID
         AND FCPV.CONCURRENT_PROGRAM_ID = FCR.CONCURRENT_PROGRAM_ID(+)
         AND FEV.EXECUTABLE_ID = FCPV.EXECUTABLE_ID
         AND FEV.EXECUTION_METHOD_CODE=FLP.LOOKUP_CODE
         AND FCPV.APPLICATION_ID=FNA.APPLICATION_ID
        AND  FCPV.ENABLED_FLAG = ''Y''
         AND FLP.LOOKUP_TYPE=''CP_EXECUTION_METHOD_CODE''
AND FEV.APPLICATION_ID > 19999 -- Select all executables on custom tops, corresponding
GROUP BY FEV.EXECUTION_METHOD_CODE, FEV.USER_EXECUTABLE_NAME
        ,FEV.EXECUTION_FILE_NAME
      ,FCPV.USER_CONCURRENT_PROGRAM_NAME
        ,FNA.APPLICATION_SHORT_NAME
        ,FLP.MEANING
        ,FNAX.APPLICATION_SHORT_NAME
ORDER BY FLP.MEANING, FEV.EXECUTION_FILE_NAME, FEV.USER_EXECUTABLE_NAME, FCPV.USER_CONCURRENT_PROGRAM_NAME,
ROUND( SUM((ACTUAL_COMPLETION_DATE - ACTUAL_START_DATE ) * 24 )/ COUNT(1 ), 4 ) DESC');
END collect_concurrent_progs;


/*
Private procedure
Collect metric=applied_forms_versions
NOTE: This metric is currently NOT being collected.
*/
procedure collect_applied_forms_versions IS
BEGIN
  write_metric('applied_forms_versions',
    'select b.FILE_VERSION_ID File_Version_id,
       b.FILE_ID File_id,
       decode(app_short_name, ''_TOP/'', subdir, ''/'', filename) File_Path,
       to_char(b.creation_date, ''yyyy-MM-dd HH:mm:ss'') Creation_Date,
       b.version Version
     from 
       ad_files a, ad_file_versions b
     where
       a.file_id = b.file_id and a.filename like ''%fmb'' order by 3, 4 asc');
END collect_applied_forms_versions;

/*
Private procedure
Collect metric=gsc
*/
procedure collect_gsc IS
BEGIN
  if (does_object_exist('FND_SVC_COMPONENTS_V','VIEW') = true) then
    write_metric('gsc',
      'select
        component_id,
        component_name,
        component_type,
        component_type_display_name,
        concurrent_queue_name,
        concurrent_queue_display_name,
        container_type,
        container_type_display_name,
        inbound_agent_name,
        inbound_agent_display_name,
        outbound_agent_name,
        outbound_agent_display_name,
        max_idle_time,
        startup_mode,
        startup_mode_display_name
      from
        fnd_svc_components_v');
  end if;
END collect_gsc;


/*
Private procedure
Collect metric=gsc_params
*/
procedure collect_gsc_params IS
BEGIN
  if (does_object_exist('FND_SVC_COMP_PARAM_VALS_V','VIEW') = true) then
    write_metric('gsc_params',
      'select
        component_id,
        component_parameter_id,
        parameter_name,
        parameter_display_name,
        decode(encrypted_flag, ''N'', parameter_value, ''Y'', '''', parameter_value) parameter_value,
        decode(encrypted_flag, ''N'', default_parameter_value, ''Y'', '''', default_parameter_value) default_parameter_value,
        encrypted_flag,
        allow_reload_flag
      from
        FND_SVC_COMP_PARAM_VALS_V');
  end if;
END collect_gsc_params;


/*
Private procedure
Collect metric=TODO
*/
procedure collect_TODO IS
BEGIN
  write_metric('TODO',
    '');
END collect_TODO;


/*
Private procedure
Collect metric=db_version
*/
procedure collect_db_version IS
BEGIN
    write_metric('db_version',
		'select decode(banner,null,''-'',banner) banner from v$version');
END collect_db_version;


/*
Private procedure
Collect metric=comp_version
*/
procedure collect_comp_version IS
BEGIN
    write_metric('comp_version',
		'SELECT DISTINCT ''Workflow'' AS ' ||
       'comp_name, SUBSTR(TEXT,1,3) AS version FROM WF_RESOURCES WHERE TYPE = ''WFTKN'' AND NAME = ''WF_VERSION''');
END collect_comp_version;

--6346318, convert to GMT
PROCEDURE collect_applied_patches(month IN VARCHAR2) IS
BEGIN
  write_metric('applied_patches_' || month,
   'select applied_patch_id,
      patch_name patch_number,
      patch_type,
      to_char(cast(creation_date as timestamp) AT TIME ZONE ''GMT'', ''yyyy-MM-dd HH:mm:ss'') applied_date
    from ad_applied_patches 
    where to_char(creation_date, ''MON'') = ''' || upper(month) || '''');
END;

PROCEDURE collect_comprising_patches(month IN VARCHAR2) IS
BEGIN
  write_metric('comprising_patches_' || month,
   'select distinct dr.applied_patch_id,
      substr(b.bug_number, 1, 10) patch_name
    from ad_patch_drivers dr,
      ad_comprising_patches cp,
      ad_bugs b,
      ad_applied_patches ap
    where dr.patch_driver_id = cp.patch_driver_id
      and cp.bug_id = b.bug_id
      and dr.applied_patch_id = ap.applied_patch_id
      and to_char(ap.creation_date, ''MON'') = ''' || upper(month) || '''');
END;

/*
Private procedure
Collect metric=ad_bugs
*/
procedure collect_ad_bugs IS
BEGIN
    if (does_column_exist('AD_BUGS','BASELINE_NAME') = true) then
      -- R12 case where baseline_name column was introduced
      write_metric('ad_bugs',
		'select bug_number,aru_release_name,nvl(baseline_name,''UNKNOWN''),to_char(last_update_date, ''yyyy-MM-dd HH:mm:ss'') from ad_bugs');
    else
      -- 11i case where baseline_name did not exist
      write_metric('ad_bugs',
		'select bug_number,aru_release_name,''UNKNOWN'',to_char(last_update_date, ''yyyy-MM-dd HH:mm:ss'') from ad_bugs');
    end if;
END collect_ad_bugs;

/*
Private procedure
Collect metric=txk_inv_db

Note: This procedure was added manually to collect pieces of the techstack
inventory that is retrieved from the database.
*/
procedure collect_txk_inv_db IS
    l_db_vers NUMBER;
BEGIN
    UTL_FILE.PUT_LINE(g_config_handle, 'txk_inv_db:Begin');

    select to_number(substr(version,1,instr(version,'.',1,2) - 1))
	into l_db_vers 
	from v$instance
	where rownum = 1;

    -- Version of OWA packages
    DECLARE
  	OWA_UTIL_VERSION VARCHAR2(30);
	OWA_UTIL_EXIST NUMBER := 0;

    BEGIN
        begin
	    EXECUTE IMMEDIATE 'SELECT OWA_UTIL.GET_VERSION  FROM DUAL' INTO OWA_UTIL_VERSION ;
	exception
	    when others then
              SELECT COUNT(*) into OWA_UTIL_EXIST
	        FROM DBA_OBJECTS WHERE OBJECT_NAME='OWA_UTIL' AND OWNER='SYS';
	      if (OWA_UTIL_EXIST > 0) then
		OWA_UTIL_VERSION := 'WebDB2.5';	
	      else
		OWA_UTIL_VERSION := 'No OWA_UTIL in SYS';	
	      end if;
        end;

      	UTL_FILE.PUT_LINE(g_config_handle,'em_result=' || 
		'Version of OWA packages' || '|' ||
		OWA_UTIL_VERSION);
    END;


    -- Package OWA_MATCH exists in SYS schema
    DECLARE
	CURSOR em_result_cur IS
    		SELECT decode(COUNT(*), 0, 'FALSE', 'TRUE') owa_match_exists FROM DBA_OBJECTS WHERE OBJECT_NAME='OWA_MATCH' AND OWNER='SYS';
   
    BEGIN
	FOR metric_row in em_result_cur LOOP
      		UTL_FILE.PUT_LINE(g_config_handle,'em_result=' || 
        	  'Package OWA_MATCH exists in SYS Schema' || '|' ||
        	  metric_row.owa_match_exists);
  	END LOOP;
    END;	

    -- Materialized view patch 2328821 has been applied
    DECLARE
	CURSOR em_result_cur IS
    		SELECT decode(Count(column_name), 4, 'TRUE', 'FALSE') mat_patch_appl
		  FROM all_ind_columns 
             	  WHERE index_owner='SYS' AND index_name='I_SUMKEY\$_1';
	v_mat_patch_appl VARCHAR2(6);
    BEGIN
	if (l_db_vers >= 9.2) then
	 FOR metric_row in em_result_cur LOOP
    	   v_mat_patch_appl := metric_row.mat_patch_appl;
  	 END LOOP;
	else
	 v_mat_patch_appl := 'TRUE';
	end if;

      	UTL_FILE.PUT_LINE(g_config_handle,'em_result=' || 
        	  'Materialized view patch 2328821 has been applied to the Database Oracle Home.' || '|' ||
        	  v_mat_patch_appl);
    END;

    -- Amount of temporary tablespace in MB assigned to the apps schema
    DECLARE
	CURSOR em_result_cur IS
    		SELECT Sum(bytes)/(1024*1024) temp_ts FROM dba_temp_files 
          	 WHERE tablespace_name = (
		  SELECT temporary_tablespace FROM dba_users 
             	   WHERE username=user );

   
    BEGIN
	FOR metric_row in em_result_cur LOOP
      	UTL_FILE.PUT_LINE(g_config_handle,'em_result=' || 
        	  'Amount of temporary tablespace in MB assigned to the Apps Schema' || '|' ||
        	  metric_row.temp_ts);
  	END LOOP;
    END; 

    -- UTL_RECOMP package is found in the database
    DECLARE
	CURSOR em_result_cur IS
    		SELECT 'TRUE' utl_recomp_found FROM dba_source WHERE name='UTL_RECOMP' 
          	 AND owner = 'SYS' AND type = 'PACKAGE BODY' 
      		 AND 0 < Instr(text,'dbms_rule.evaluate');

	v_utl_recomp_found VARCHAR2(6) := 'FALSE';
    BEGIN
	if (l_db_vers >= 9.2) then
	 FOR metric_row in em_result_cur LOOP
    	   v_utl_recomp_found := metric_row.utl_recomp_found;
  	 END LOOP;
	else
	 v_utl_recomp_found := 'TRUE';
	end if;

      	UTL_FILE.PUT_LINE(g_config_handle,'em_result=' || 
        	  'UTL_RECOMP package is found in the database' || '|' ||
        	  v_utl_recomp_found);
    END;

    -- SYSTEM tablespace size in MB
    DECLARE
	CURSOR em_result_cur IS
    		SELECT SUM(BYTES)/(1024*1024) sys_ts
  		 FROM DBA_DATA_FILES WHERE TABLESPACE_NAME='SYSTEM';
   
    BEGIN
	FOR metric_row in em_result_cur LOOP
      	UTL_FILE.PUT_LINE(g_config_handle,'em_result=' || 
        	  'SYSTEM tablespace size in MB' || '|' ||
        	  metric_row.sys_ts);
  	END LOOP;
    END; 

    -- Your Applications database contains portal version
    DECLARE
  	portal_user      VARCHAR2(64);
  	portal_user_name VARCHAR2(64);
  	portal_ver       VARCHAR2(10);
    BEGIN
      begin
  	EXECUTE IMMEDIATE 'SELECT fnd_oracle_schema.getouvalue(''PORTAL'') FROM dual' INTO portal_user;
  	BEGIN
    	  EXECUTE IMMEDIATE 'SELECT user_name FROM fnd_user WHERE user_name LIKE upper('''||portal_user||''')' INTO portal_user_name;
    	  IF portal_user IS NOT NULL THEN
      	    EXECUTE IMMEDIATE 'SELECT version FROM '||portal_user||'.wwc_version\$' INTO portal_ver;
      	    
    	  END IF;
    	EXCEPTION
    	  WHEN NO_DATA_FOUND THEN
      	    null;
    	END;
      exception
        when others then
	  null;
      end;
	
      UTL_FILE.PUT_LINE(g_config_handle,'em_result=' || 
		'Your Applications database contains Portal version' || '|' ||
		portal_ver);
    END;

    -- Your Applications database contains Login Server version
    DECLARE
  	sso_user      VARCHAR2(64);
  	sso_user_name VARCHAR2(64);
  	sso_ver       VARCHAR2(10);
    BEGIN
      begin
  	EXECUTE IMMEDIATE 'SELECT fnd_oracle_schema.getouvalue(''LOGINSERVER'') FROM dual' INTO sso_user;
  	BEGIN
    	  EXECUTE IMMEDIATE 'SELECT user_name FROM fnd_user WHERE user_name LIKE upper('''||sso_user||''')' INTO sso_user_name;
    	  IF sso_user IS NOT NULL THEN
      	    EXECUTE IMMEDIATE 'SELECT version FROM '||sso_user||'.wwc_version\$' INTO sso_ver;
    	  END IF;
  	EXCEPTION
    	  WHEN NO_DATA_FOUND THEN
      	    null;
  	END;
      exception
	when others then
	  null;
      end;

      UTL_FILE.PUT_LINE(g_config_handle,'em_result=' || 
		'Your Applications database contains Login Server version' || '|' ||
		sso_ver);
    END;

    UTL_FILE.PUT_LINE(g_config_handle, 'txk_inv_db:End');

    UTL_FILE.FFLUSH(g_config_handle);

END collect_txk_inv_db;


/* 
The implementation procedure which does the collection.
*/ 
procedure collect_configMetrics_impl
IS
   l_db_characterset VARCHAR2(20);
   l_vers            v$instance.version%TYPE;
   l_comp_cnt        NUMBER;
   l_checkXMLdb      VARCHAR2(500);
BEGIN
   select value into l_db_characterset from NLS_DATABASE_PARAMETERS where parameter = 'NLS_CHARACTERSET';
   UTL_FILE.PUT_LINE(g_config_handle,'META_VER=' || ORACLE_EBS_META_VER);
   UTL_FILE.PUT_LINE(g_config_handle,'TIMESTAMP=' || TO_CHAR(sysdate, 'yyyy-mm-dd hh24:mi:ss')); 
   UTL_FILE.PUT_LINE(g_config_handle,'NLS_CHARACTERSET=' || l_db_characterset);

   select LPAD(version,10,'0') into l_vers from v$instance;
   IF l_vers >= '11.0.0.0.0' THEN
      l_checkXMLdb :=
         'select count(*) from dba_registry where COMP_NAME = ''Oracle XML Database'' ' ||
         'and STATUS = ''VALID''' ;
       -- check for XML DB installed
       execute immediate l_checkXMLdb into l_comp_cnt;
   ELSE
      l_comp_cnt := 1;
   END IF;

   IF l_comp_cnt > 0 THEN
      -- wrap with exception block
      BEGIN
         UTL_FILE.PUT_LINE(g_config_handle,'IP_ADDRESS=' || UTL_INADDR.GET_HOST_ADDRESS);
         UTL_FILE.PUT_LINE(g_config_handle,'HOSTNAME='   || UTL_INADDR.GET_HOST_NAME);
      EXCEPTION
         WHEN OTHERS THEN NULL;
      END;
   END IF;

   UTL_FILE.FFLUSH(g_config_handle);

   collect_apps_topology;
   collect_patchset_info;
   collect_nls_languages;
   collect_localization_modules;
   collect_data_groups;
   collect_profile_options;
--   commenting out per bug 5060966
--   collect_reg_oracle_users;
   collect_user_metrics; -- combined user metrics for bug 5084698
   collect_printers;
   collect_printer_drivers;
   collect_cust_apps;
   collect_cust_alerts;
   collect_cust_triggers;
   collect_cust_workflows;
   collect_cust_db_objects;
   collect_cust_objs_apps_schema;
   collect_cust_app_prof_opts;
   collect_cust_value_sets;
   collect_other_customizations;
   collect_cust_hooks;
   collect_jtf_hooks;
   collect_cust_request_sets;
   collect_cust_audit_grps;
   collect_cust_msg_count;
   collect_cust_resp;
   collect_cust_val_sets_x;
   collect_apps_cust_forms;
   collect_db_version;
   collect_comp_version;
   collect_applied_patches('jan');
   collect_applied_patches('feb');
   collect_applied_patches('mar');
   collect_applied_patches('apr');
   collect_applied_patches('may');
   collect_applied_patches('jun');
   collect_applied_patches('jul');
   collect_applied_patches('aug');
   collect_applied_patches('sep');
   collect_applied_patches('oct');
   collect_applied_patches('nov');
   collect_applied_patches('dec');
   collect_comprising_patches('jan');
   collect_comprising_patches('feb');
   collect_comprising_patches('mar');
   collect_comprising_patches('apr');
   collect_comprising_patches('may');
   collect_comprising_patches('jun');
   collect_comprising_patches('jul');
   collect_comprising_patches('aug');
   collect_comprising_patches('sep');
   collect_comprising_patches('oct');
   collect_comprising_patches('nov');
   collect_comprising_patches('dec');
   collect_txk_inv_db;
   collect_apps_summary;
   collect_gsc;
   collect_gsc_params;
   -- Added for bug 5353110
   collect_ad_bugs;

   -- Write file footer/end marker
   UTL_FILE.PUT_LINE(g_config_handle,'_CCR_EOF_');

   UTL_FILE.FFLUSH(g_config_handle);

END collect_configMetrics_impl;

/*
Private procedure
Collect metric=cm_summary_config
*/
procedure collect_cm_summary_config IS
BEGIN
  write_metric('cm_summary_config',
    'select ''PCP'' "Setting", value "Status" 
     from fnd_env_context 
     where variable_name = ''APPLDCP'' and concurrent_process_id = (select max(concurrent_process_id) from fnd_concurrent_processes where concurrent_queue_id = 1)
     UNION ALL
     select ''RAC'' "Setting", decode(count(*), 0, ''N'', 1, ''N'', ''Y'') "Status" from V$thread
     UNION ALL
     select ''GSM'' "Setting", NVL(v.profile_option_value, ''N'') "Status" 
     from fnd_profile_options p, fnd_profile_option_values v
     where p.profile_option_name = ''CONC_GSM_ENABLED''
       and p.profile_option_id = v.profile_option_id
       and p.application_id = v.application_id');
END collect_cm_summary_config;

/*
Private procedure
Collect metric=cm_cp_profile_options
*/
procedure collect_cm_cp_profile_options IS
BEGIN
  write_metric('cm_cp_profile_options',
   'SELECT fpo.profile_option_name,
      fpo.profile_option_id,
      fpov.profile_option_value,
      fpov.level_id,
      fa.application_short_name,
      fpo.user_profile_option_name,
      fpo.sql_validation,
      fpo.description
    FROM FND_PROFILE_OPTIONS_VL fpo, FND_PROFILE_OPTION_VALUES fpov, fnd_application fa
     where fpo.application_id = 0 
       and fpo.site_enabled_flag = ''Y'' 
       and (fpo.profile_option_name like ''CONC_%'' 
       or fpo.profile_option_name like ''FS_%'' 
       or fpo.profile_option_name like ''PRINTER%'' 
       or fpo.profile_option_name in (''EDITOR_CHAR'', ''FNDCPVWR_FONT_SIZE'', ''MAX_PAGE_LENGTH'', ''APPLWRK''))
       and fpo.profile_option_id = fpov.profile_option_id
       and fpo.application_id = fpov.application_id
       and fpo.application_id = fa.application_id
       and fpov.level_id = 10001');
END collect_cm_cp_profile_options;

/*
Private procedure
Collect metric=cm_service_instances
*/
procedure collect_cm_service_instances IS
BEGIN
  write_metric('cm_service_instances',
    'select fcq.application_id "Application Id", 
       fcq.concurrent_queue_name, fcq.user_concurrent_queue_name "Service", 
       fa.application_short_name, fcq.target_node "Node", 
       fcq.max_processes "Target", 
       fcq.node_name "Primary", fcq.node_name2 "Secondary", 
       fcq.enabled_flag "Enabled", fcq.cache_size "Cache Size", 
       fcq.resource_consumer_group "Resource Consumer Group", fcp.concurrent_processor_name "Program Library",
       diagnostic_level, sleep_seconds 
     from fnd_concurrent_queues_vl fcq, fnd_application fa, fnd_concurrent_processors fcp 
     where fcq.application_id = fa.application_id 
       and fcq.processor_application_id = fcp.application_id 
       and fcq.concurrent_processor_id = fcp.concurrent_processor_id');
END collect_cm_service_instances;

/*
Private procedure
Collect metric=cm_special_rules
*/
procedure collect_cm_special_rules IS
BEGIN
  write_metric('cm_special_rules',
    'select q.application_id, q.concurrent_queue_name, 
       q.user_concurrent_queue_name "Manager", l1.meaning "Action", 
       l2.meaning "Type", p.user_concurrent_program_name "Object"
     from fnd_concurrent_queue_content c, fnd_concurrent_queues_vl q, 
       fnd_concurrent_programs_vl p, fnd_lookups l1, fnd_lookups l2 
     where q.concurrent_queue_id = c.concurrent_queue_id 
       and q.application_id = c.queue_application_id
       and c.type_code = ''P''
       and c.type_id = p.concurrent_program_id
       and c.type_application_id = p.application_id
       and l1.lookup_code = c.include_flag and l1.lookup_type = ''INCLUDE_EXCLUDE''
       and l2.lookup_code = ''P'' and l2.lookup_type = ''CP_SPECIAL_RULES''
     UNION ALL
     select q.application_id, q.concurrent_queue_name,
       q.user_concurrent_queue_name "Manager", l1.meaning "Action", 
       ''Application'' "Type", a.application_name "Object"
     from fnd_concurrent_queue_content c, fnd_concurrent_queues_vl q, 
       fnd_application_vl a, fnd_lookups l1
     where q.concurrent_queue_id = c.concurrent_queue_id 
       and q.application_id = c.queue_application_id
       and c.type_code = ''P''
       and c.type_id is null
       and c.type_application_id = a.application_id
       and l1.lookup_code = c.include_flag and l1.lookup_type = ''INCLUDE_EXCLUDE''
     UNION ALL
     select q.application_id, q.concurrent_queue_name,
       q.user_concurrent_queue_name "Manager", l1.meaning "Action", 
       l2.meaning "Type", x.complex_rule_name "Object"
     from fnd_concurrent_queue_content c, fnd_concurrent_queues_vl q, fnd_concurrent_complex_rules x,
       fnd_lookups l1, fnd_lookups l2 
     where q.concurrent_queue_id = c.concurrent_queue_id 
       and q.application_id = c.queue_application_id
       and c.type_code = ''C''
       and c.type_id = x.complex_rule_id
       and c.type_application_id = x.application_id
       and l1.lookup_code = c.include_flag and l1.lookup_type = ''INCLUDE_EXCLUDE''
       and l2.lookup_code = ''C'' and l2.lookup_type = ''CP_SPECIAL_RULES''
     UNION ALL
     select q.application_id, q.concurrent_queue_name,
       q.user_concurrent_queue_name "Manager", l1.meaning "Action", l2.meaning "Type", r.request_class_name "Object"
     from fnd_concurrent_queue_content c, fnd_concurrent_queues_vl q, fnd_concurrent_request_class r,
       fnd_lookups l1, fnd_lookups l2 
     where q.concurrent_queue_id = c.concurrent_queue_id 
       and q.application_id = c.queue_application_id
       and c.type_code = ''R''
       and c.type_id = r.request_class_id
       and c.type_application_id = r.application_id
       and l1.lookup_code = c.include_flag and l1.lookup_type = ''INCLUDE_EXCLUDE''
       and l2.lookup_code = ''R'' and l2.lookup_type = ''CP_SPECIAL_RULES''
     UNION ALL
     select q.application_id, q.concurrent_queue_name,q.user_concurrent_queue_name "Manager", l1.meaning "Action", l2.meaning "Type", o.oracle_username "Object"
     from fnd_concurrent_queue_content c, fnd_concurrent_queues_vl q, fnd_oracle_userid o,
       fnd_lookups l1, fnd_lookups l2 
     where q.concurrent_queue_id = c.concurrent_queue_id 
       and q.application_id = c.queue_application_id
       and c.type_code = ''O''
       and c.type_id = o.oracle_id
       and l1.lookup_code = c.include_flag and l1.lookup_type = ''INCLUDE_EXCLUDE''
       and l2.lookup_code = ''O'' and l2.lookup_type = ''CP_SPECIAL_RULES''
     UNION ALL
     select q.application_id, q.concurrent_queue_name,q.user_concurrent_queue_name "Manager", l1.meaning "Action", l2.meaning "Type", u.user_name "Object"
     from fnd_concurrent_queue_content c, fnd_concurrent_queues_vl q, fnd_user u,
       fnd_lookups l1, fnd_lookups l2 
     where q.concurrent_queue_id = c.concurrent_queue_id 
       and q.application_id = c.queue_application_id
       and c.type_code = ''U''
       and c.type_id = u.user_id
       and l1.lookup_code = c.include_flag and l1.lookup_type = ''INCLUDE_EXCLUDE''
       and l2.lookup_code = ''U'' and l2.lookup_type = ''CP_SPECIAL_RULES''
     UNION ALL
     select q.application_id, q.concurrent_queue_name,q.user_concurrent_queue_name "Manager", l1.meaning "Action", l2.meaning "Type", to_char(c.type_id) "Object"
     from fnd_concurrent_queue_content c, fnd_concurrent_queues_vl q,
       fnd_lookups l1, fnd_lookups l2 
     where q.concurrent_queue_id = c.concurrent_queue_id 
       and q.application_id = c.queue_application_id
       and c.type_code not in (''C'',''P'',''O'',''R'', ''U'')
       and l1.lookup_code = c.include_flag and l1.lookup_type = ''INCLUDE_EXCLUDE''
       and l2.lookup_code = c.type_code and l2.lookup_type = ''CP_SPECIAL_RULES''');
END collect_cm_special_rules;

/*
Private procedure
Collect metric=cm_workshifts
*/
procedure collect_cm_workshifts IS
BEGIN
  write_metric('cm_workshifts',
    'select 
     fcq.application_id, 
     fcq.concurrent_queue_name, 
     fcq.user_concurrent_queue_name,
     ftp.application_id,	
     ftp.concurrent_time_period_name,
     fa.application_short_name,
     ftp.description,
     fcqs.min_processes,
     fcqs.max_processes,
     fcqs.sleep_seconds,
     fcqs.service_parameters
     from fnd_concurrent_queues_vl fcq,
     fnd_concurrent_queue_size fcqs,
     fnd_concurrent_time_periods ftp,
       fnd_application fa
     where
       fcq.application_id = fcqs.queue_application_id
       and fcq.concurrent_queue_id = fcqs.concurrent_queue_id
       and fcqs.period_application_id = ftp.application_id
       and fcqs.concurrent_time_period_id = ftp.concurrent_time_period_id
       and ftp.application_id = fa.application_id');
END collect_cm_workshifts;

/*
Private procedure
Collect metric=cm_icm_settings
*/
procedure collect_cm_icm_settings IS
BEGIN
  write_metric('cm_icm_settings',
    'select name, value from fnd_concurrent_queue_params where queue_application_id = 0 and concurrent_queue_id = 1');
END collect_cm_icm_settings;

/*
Private procedure
Collect metric=cm_cp_pkg_versions
*/
procedure collect_cm_cp_pkg_versions IS
BEGIN
  write_metric('cm_cp_pkg_versions',
    'select name "Package", 
       type, 
       substr(text, instr(text,''A''),19) "Version"
     from dba_source 
     where type in (''PACKAGE'', ''PACKAGE BODY'') 
       and (name like ''FND_CONC%'' or name like ''FND_CP%'' 
       or name like ''FNDCP_%'' or name like ''FND_REQUEST%''
       or name in (''FND_DCP'',''FND_EXECUTABLES_PKG'', ''FND_FILE'', ''FND_FILE_PRIVATE'',
         ''FND_GSM_UTIL'',''FND_MANAGER'', ''FND_MLS_REQUEST'', ''FND_PRINTER_PKG'', 
         ''FND_PRINTER_STYLES_PKG'', ''FND_PROGRAM'', ''FND_RESUB'',
         ''FND_RESUB_PRIVATE'', ''FND_SET'', ''FND_SET_COPY'', 
         ''FND_STAGE_FN_PARAMETERS_PKG'', ''FND_SUBMIT'', ''FND_TM_TESTER'',
         ''FND_TRANSACTION'', ''FND_WEBFILE'', ''FND_WEBFILEPUB''))
       and line = 2
     order by name');
END collect_cm_cp_pkg_versions;

procedure collect_cm_metrics_impl
IS
   l_db_characterset VARCHAR2(20);
   l_vers            v$instance.version%TYPE;
   l_comp_cnt        NUMBER;
   l_checkXMLdb      VARCHAR2(500);
BEGIN
   select value into l_db_characterset from NLS_DATABASE_PARAMETERS where parameter = 'NLS_CHARACTERSET';
   UTL_FILE.PUT_LINE(g_config_handle, 'META_VER=' || ORACLE_EBS_META_VER);
   UTL_FILE.PUT_LINE(g_config_handle, 'TIMESTAMP=' || TO_CHAR(sysdate, 'yyyy-mm-dd hh24:mi:ss')); 
   UTL_FILE.PUT_LINE(g_config_handle,'NLS_CHARACTERSET=' || l_db_characterset);
   -- If 11+, check for XML DB before calling UTL_INADDR package, otherwise go ahead
   select LPAD(version,10,'0') into l_vers from v$instance;
   IF l_vers >= '11.0.0.0.0' THEN
      l_checkXMLdb :=
         'select count(*) from dba_registry where COMP_NAME = ''Oracle XML Database'' ' ||
         'and STATUS = ''VALID''' ;
       -- check for XML DB installed
       execute immediate l_checkXMLdb into l_comp_cnt;
   ELSE
      l_comp_cnt := 1;
   END IF;

   IF l_comp_cnt > 0 THEN
      -- wrap with exception block
      BEGIN
         UTL_FILE.PUT_LINE(g_config_handle,'IP_ADDRESS=' || UTL_INADDR.GET_HOST_ADDRESS);
         UTL_FILE.PUT_LINE(g_config_handle,'HOSTNAME='   || UTL_INADDR.GET_HOST_NAME);
      EXCEPTION
         WHEN OTHERS THEN NULL;
      END;
   END IF;
   UTL_FILE.FFLUSH(g_config_handle);

   collect_cm_summary_config;
   collect_cm_cp_profile_options;
   collect_cm_service_instances;
   collect_cm_special_rules;
   collect_cm_workshifts;
   collect_cm_icm_settings;
   collect_cm_cp_pkg_versions;

   -- Write file footer/end marker
   UTL_FILE.PUT_LINE(g_config_handle,'_CCR_EOF_');

   UTL_FILE.FFLUSH(g_config_handle);

END collect_cm_metrics_impl;

/*
Puts the config data into the file
*/
procedure collect_config_metrics(directory_location IN VARCHAR2) IS
l_db_name  v$database.name%TYPE;
l_par v$instance.PARALLEL%TYPE;
BEGIN
  BEGIN
  SELECT  name into l_db_name FROM v$database ;
  /*
    Check if the database is running in RAC mode.	
    If so, name the file as <db_name>-RAC.ll
  */
  BEGIN
    select PARALLEL into l_par  from v$instance;
    IF l_par = 'YES' THEN
      g_config_handle := UTL_FILE.FOPEN(directory_location,l_db_name || '-RAC-apps_db.ll','W',32767);
    ELSE
      g_config_handle := UTL_FILE.FOPEN(directory_location,l_db_name || '-apps_db.ll','W',32767);
    END IF;
    collect_configMetrics_impl;
    UTL_FILE.FCLOSE(g_config_handle);
    g_config_handle := NULL;
    EXCEPTION
      WHEN UTL_FILE.INVALID_FILEHANDLE OR 
           UTL_FILE.INVALID_PATH OR
           UTL_FILE.INVALID_OPERATION OR 
           UTL_FILE.WRITE_ERROR THEN
        -- Just bail out, we cannot open or write to the ll file(s)
        RETURN;
  END;

  /* Add to support new target oracle_apps_cm. */
  IF l_par = 'YES' THEN  
    g_config_handle := UTL_FILE.FOPEN(directory_location, l_db_name || '-RAC-apps_cm.ll', 'W', 32767);
  ELSE
    g_config_handle := UTL_FILE.FOPEN(directory_location, l_db_name || '-apps_cm.ll', 'W', 32767);
  END IF;

  collect_cm_metrics_impl;
  UTL_FILE.FCLOSE(g_config_handle);
  g_config_handle := NULL;

  EXCEPTION
    WHEN OTHERS THEN
      IF UTL_FILE.IS_OPEN (g_config_handle) = TRUE THEN
        UTL_FILE.FCLOSE(g_config_handle); 
      END IF;
      g_config_handle := null;
      /* Needs to modify this to log the error into alert log and don't rais any exception*/
      RAISE_APPLICATION_ERROR(-20000,'SQLERRM: ' || SQLERRM || ' SQLCODE: '|| SQLCODE);
  END;
END collect_config_metrics;

END MGMT_EBS_LL_METRICS;
/
show errors package body MGMT_EBS_LL_METRICS;

