Rem
Rem $Header: emll/admin/scripts/ebs_lljob_pkgbodys.sql /main/5 2009/06/11 14:08:16 pparida Exp $
Rem
Rem ebs_ll_job_pkgbodysVob.sql
Rem
Rem Copyright (c) 2005, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      ebs_ll_job_pkgbodysVob.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pparida     06/04/09 - 8268571: Check for compatible param too.
Rem    ppradhan    03/23/06 - For fixing bug 5109585 
Rem    fle         10/12/05 - Check for db version 8.1.7 in get_job_what.
Rem                         - Change 'LL_CONFIG_DIR' to '&CONFIG_DIR_NAME' (EBS_LL_CONFIG_DIR).
Rem    ndutko      08/03/05 - ndutko_code_checkin
Rem    dkapoor     04/12/05 - Created
Rem


CREATE OR REPLACE PACKAGE body MGMT_EBS_CONFIG AS

/*
 Get WHAT for the job
*/
FUNCTION get_job_what RETURN VARCHAR2 IS
  l_vers    v$instance.version%TYPE;
  l_compat_vers     v$parameter.value%TYPE;
BEGIN 
  select substr(version,1,5) into l_vers from v$instance;
  begin
    select substr(value,1,5) into l_compat_vers from v$parameter where lower(name) = 'compatible';
  exception
    WHEN NO_DATA_FOUND THEN
      l_compat_vers := l_vers;
  end;
  IF l_vers = '9.0.1' OR l_vers = '8.1.7' OR l_compat_vers = '8.1.7' THEN
    return 'MGMT_EBS_LL_METRICS.collect_config_metrics(''&LIVELINK_DATA_DIR'');';
  ELSE
    return 'MGMT_EBS_LL_METRICS.collect_config_metrics(''&CONFIG_DIR_NAME'');';
  END IF;
END get_job_what;

/*
 Checks to see if the job already exists
*/
FUNCTION job_exists RETURN BOOLEAN IS
  l_job_cnt NUMBER;
BEGIN
   select count(*) into l_job_cnt from 
      user_jobs where what like 'MGMT_EBS_LL_METRICS.collect_config_metrics%';
  if l_job_cnt = 0
  THEN
    return FALSE;
  ELSE
    return TRUE;
  END IF;
END job_exists;

FUNCTION get_job_num RETURN NUMBER IS
  l_job NUMBER;
BEGIN
     select job into l_job from 
        user_jobs where what like 'MGMT_EBS_LL_METRICS.collect_config_metrics%';
     return l_job;
     EXCEPTION
      WHEN TOO_MANY_ROWS THEN
        RAISE_APPLICATION_ERROR(-20000,'There are more than one database '
                || 'configuration collection job. These are jobs with WHAT for job like '
                || '"MGMT_EBS_LL_METRICS.collect_config_metrics%"');
      WHEN NO_DATA_FOUND THEN
        RAISE_APPLICATION_ERROR(-20000,'There is no database '
                || 'configuration collection job. '
                || 'Create one using "MGMT_EBS_CONFIG.submit_job"');
      WHEN OTHERS THEN
	RAISE;
END get_job_num;


/*
Installs a job to collect the configuration.
Stop the old job, if exists, and then submit a new one.
*/
procedure install_job IS
BEGIN
  IF job_exists THEN  
      stop_job; 
     COMMIT;
  END IF;
  submit_job;
END install_job;

/*
Submit a job to collect the configuration.
Basically, a job with what->collect_config_metrics(<collection directory>
*/
procedure submit_job IS
 l_job NUMBER;
BEGIN
  IF not job_exists THEN  
      SYS.DBMS_JOB.SUBMIT(l_job, 
            get_job_what(),
            TRUNC(SYSDATE) + 1/24, 'TRUNC(SYSDATE) + 1 + 1/24');
     COMMIT;
  ELSE
      RAISE_APPLICATION_ERROR(-20000,'Cannot resubmit. A job already exists.');
  END IF;
END submit_job;

/*
Runs the configuration collection job now.
*/
procedure run_now IS
    l_job NUMBER;
BEGIN
    	l_job := get_job_num;
   	SYS.DBMS_JOB.RUN(l_job);
  	COMMIT;
END run_now;

/*
Print the job details.
*/
procedure print_job_details IS
l_next_date user_jobs.next_date%TYPE;
l_next_sec user_jobs.next_sec%TYPE;
l_job NUMBER;
BEGIN
        l_job := get_job_num;
        SELECT next_date ,next_sec INTO l_next_date , l_next_sec
        FROM user_jobs WHERE job = l_job;
        dbms_output.put_line('Next Date: '|| to_char(l_next_date,'MM-DD-YYYY'));
        dbms_output.put_line('Time: '|| l_next_sec);
END print_job_details;

/*
Stop the job.
*/
procedure stop_job IS
 l_job NUMBER;
BEGIN
    l_job := get_job_num;
    SYS.DBMS_JOB.remove(l_job);
    COMMIT;
END stop_job;

/*
Change interval of the job.
*/
procedure change_interval(l_interval IN VARCHAR2) IS
 l_job NUMBER;
BEGIN
    l_job := get_job_num;
   	SYS.DBMS_JOB.interval(l_job,l_interval);
  	COMMIT;
END change_interval;


/*
Change next date of the job.
*/
procedure change_next_date(next In Date) IS
 l_job NUMBER;
BEGIN
    l_job := get_job_num;
   	SYS.DBMS_JOB.next_date(l_job,next);
  	COMMIT;
END change_next_date;

END MGMT_EBS_CONFIG;
/
show errors package body MGMT_EBS_CONFIG;
