#!/bin/sh
#
# $Header: emll/admin/scripts/installCCRSQL.sh /main/31 2010/07/27 10:09:23 jsutton Exp $
#
# installCCRSQL.sh
#
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      installCCRSQL.sh - Script to install Database and EBS SQL Packages for CCR
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsutton     06/18/10 - fix parameters for ebs_collectconfig and
#                           collectemrep calls
#    jsutton     04/29/10 - RAC instance collection - for ADR data
#    aghanti     02/02/10 - Re-added definition of STTY, which was missed out
#                           in prev txn
#    aghanti     10/08/09 - Removal of dependency on xpg4 utilities
#    jsutton     04/11/08 - Handle upgrade scenario properly
#    pparida     02/26/08 - Fix bug 6629297: Check for ORA-12638.
#    pparida     12/05/07 - Fix bug 6664051: Put quotes around variable in -z
#                           check.
#    jsutton     09/28/07 - Fix check for CCR_HOME env var
#    jsutton     08/14/07 - Fixups for shared Oracle Home support
#    kgupta      07/20/07 - support for shared Oracle Homes
#    ndutko      04/10/07 - Handle case of missing arguments
#    ndutko      03/14/07 - Use Solaris specific GREP that supports expressions
#                           (Bug 5902660)
#    pparida     01/11/07 - Fix bug 5706203: Unset $SQLPATH before running sql
#                           and cd to ccr/admin/scripts dir to avoid login.sql
#    kgupta      12/20/06 - Fixing 5549378
#    cvaishna    12/11/06 - Fixing PWD issue
#    jsutton     10/03/06 - Fix usage msg
#    ndutko      10/03/06 - Specify requirement that all scripts require SYSDBA
#                           access
#    ndutko      10/03/06 - XbranchMerge ndutko_bug-5579223 from st_emll_10.2.4
#    ndutko      09/24/06 - Display a better message in the case that SQL*Plus
#                           is not present in the ORACLE_HOME
#    dkapoor     09/15/06 - fix the problem when running using relative path
#    rstorrie    09/14/06 - Enable prompting of password for sysman
#    rstorrie    09/04/06 - Correction of usage for emrep collection, under bug
#                           5502251
#    rstorrie    07/31/06 - Addition of emrep collection
#    ndutko      04/03/06 - Add conformance to Posix shell 
#    dkapoor     03/08/06 - exit with non-zero error code on error 
#    dkapoor     01/04/06 - prompt for passwords 
#    dkapoor     12/06/05 - fix porting exception 
#    dkapoor     11/27/05 - check for 01034 
#    dkapoor     10/13/05 - add the option -r in usage 
#    dkapoor     10/12/05 - SPECIFICATION OF USER OTHER THAN SYS 
#    dkapoor     10/10/05 - dkapoor_bug-4590410
#    dkapoor     10/10/05 - Creation

# Define the paths for /usr/bin. These are used in subsequent path
# specifications for native commands.
_binDir=/bin
_usrBinDir=/usr/bin

# Set the variables that map to explicit paths to prevent from trojan
# horse type attacks and allow for more consistent installation experience
# by eliminating the use of aliases.
CD=cd
DIRNAME=${_usrBinDir}/dirname
ECHO=${_binDir}/echo
RM=${_binDir}/rm
SED=${_binDir}/sed
STTY=${_binDir}/stty
TR=${_usrBinDir}/tr

if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

if [ -f ${_binDir}/uname ]
then
    UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
    UNAME=${_usrBinDir}/uname
fi

AWK=${_binDir}/awk
PLATFORM=`$UNAME | $CUT -f1`
if [ "$PLATFORM" = "SunOS" ]
then
    if [ -f ${_binDir}/nawk ]
    then
        AWK=${_binDir}/nawk
    elif [ -f ${_usrBinDir}/nawk ]
    then
        AWK=${_usrBinDir}/nawk
    fi
fi

if [ -f ${_binDir}/egrep ]
then
    EGREP=${_binDir}/egrep
elif [ -f ${_usrBinDir}/egrep ]
then
    EGREP=${_usrBinDir}/egrep
fi

if [ -f ${_usrBinDir}/printf ]
then
    PRINTF=${_usrBinDir}/printf
elif [ -f ${_binDir}/printf ]
then
    PRINTF=${_binDir}/printf
fi

#
# Set the umask for all operations
umask 077

if [ $PLATFORM = "OSF1" ]
then
    if [ -z "$BIN_SH" ]
    then
        BIN_SH=xpg4
        export BIN_SH
        $0 "$@"
        exit $?
    fi
fi 

ROOTCHAR=`$DIRNAME $0 | $CUT -b1`
if [ "$ROOTCHAR" != "/" -a -z "$PWD" ]
then
    $ECHO "The current shell is not supported for executing commands using relative paths."
    $ECHO "Either execute the command under the bash or ksh shells, or execute the "
    $ECHO "command using the absolute path."
    exit 1
fi

# Extract the binary directory specification where this script resides. 
# The enclosed code will come up with an absolute path. 
_ccrBinDir=`$DIRNAME $0 | $TR -s '/'`
# First remove './'s in the beginning
_ccrBinDir=`$ECHO $_ccrBinDir | $AWK '{ if (match($0,/^(\.\/)*/)){ sub(/^(\.\/)*/,"",$0) }; print $0; }'`
# Next replace all '/./'s in between with '/'
_ccrBinDir=`$ECHO $_ccrBinDir | $AWK '{ if (match($0,/\/(\.\/)+/)){ gsub(/\/(\.\/)+/,"/",$0) }; print $0;}'`
# Lastly remove '/.' at the end
_ccrBinDir=`$ECHO $_ccrBinDir | $AWK '{ if (match($0,/\/\.$/)){ sub(/\/\.$/,"",$0) }; print $0; }'`
# Now convert to absolute path
_ccrBinDir=`$ECHO $_ccrBinDir | $AWK -f ${_ccrBinDir}/../../bin/strip_path.awk PWD=$PWD`
_ccrBinDir=`$DIRNAME $_ccrBinDir`
_ccrBinDir=`$DIRNAME $_ccrBinDir`
CCR_HOME=${_ccrBinDir}

ORACLE_HOME=`$DIRNAME ${_ccrBinDir}`
export ORACLE_HOME

usage()
{
    cat <<EOF
Usage: $0 <script> [<option>]
where <script> = collectconfig | ebs_collectconfig | collectemrep
      <option> = one or more of the following:
        -s <ORACLE_SID>
        -r <DB-USER>     where <DB-USER> is the database user with 
                         SYSDBA privileges 
        -p <DB-PWD>      where <DB-PWD> is the password for the <DB-USER> 
        -u <APPS-USER>   where <APPS-USER> is the database user associated with
                         Oracle Applications
        -w <APPS_PWD>    where <APPS-PWD> is the password for the <APPS-USER> 
        -e <SYSMAN_PWD>  where <SYSMAN_PWD> is the password for the SYSMAN repository schema

 All configuration instrumentation (collectconfig, ebs_collectconfig and
 collectemrep) require connection to the database with an account holding
 SYSDBA privilege. Specify the -r and optionally -p if host authentication
 is not enabled for the database instance.

Note: If you have not specified the passwords, you will be prompted to do so when you run the script.
EOF
}

validateArgs()
{
    if [ -z "$_script" ]
    then
        $ECHO The configuration collection script to run was not specified.
        usage
        exit 1
    fi

    if [ "$_script" != "collectconfig" -a \
         "$_script" != "ebs_collectconfig" -a \
         "$_script" != "collectemrep" ]
    then
        $ECHO "Incorrect SQL script was specified."
        usage
        exit 1
    fi

    if [ "$_script" = "collectconfig" ]
    then
        COMMAND="${COMMAND} ${CCR_HOME}/state"
    fi

    if [ "$_script" = "ebs_collectconfig" ]
    then
    	if [ -z "$APPS_USER" ] 
	then
        	$ECHO "APPS user is not specified."
        	usage
        	exit 1
	fi
    	if [ -z "$APPS_PSWD" ] 
	then
		$PRINTF "Provide password for \"$APPS_USER\": "
		oldmodes=`${STTY} -g`
		${STTY} -echo
		read APPS_PSWD
		${STTY} $oldmodes
		$ECHO ""
	fi

    	if [ -z "$APPS_PSWD" ] 
	then
        	$ECHO "Password for the APPS user is not specified."
        	usage
        	exit 1
	fi
        COMMAND="${COMMAND} $APPS_USER $APPS_PSWD"
    fi

    if [ "$_script" = "collectemrep" ]
    then
        if [ -z "$EMREP_PWD" ]
        then
                $PRINTF "Provide password for SYSMAN: "
                oldmodes=`${STTY} -g`
                ${STTY} -echo
                read EMREP_PWD
                ${STTY} $oldmodes
                $ECHO ""
        fi

        if [ -z "$EMREP_PWD" ]
        then
                $ECHO "SYSMAN password is not specified."
                usage
                exit 1
        fi
        COMMAND="${COMMAND} $EMREP_PWD"
    fi

    if [ -z "$ORACLE_SID" ] 
    then
        $ECHO "ORACLE_SID is not defined."
	usage
        exit 1
    fi

    if [ ! -d ${ORACLE_HOME}/ccr ]
    then
        $ECHO "The CCR collector is not installed in the home specified by the ORACLE_HOME variable."
        exit 1
    fi

    if [ ! -f ${ORACLE_HOME}/bin/sqlplus ]
    then
        $ECHO "InstallCCRSQL can only be run in a database ORACLE_HOME, SQL*Plus not found."
        exit 1
    fi

}

getOptions()
{
    while getopts s:p:u:w:e:r: _option 
    do
        case "${_option}"
        in
            s)      ORACLE_SID=${OPTARG}
                    export ORACLE_SID;;
            p)      SYS_DBA_PSWD=${OPTARG};;
            u)      APPS_USER=${OPTARG};;
            w)      APPS_PSWD=${OPTARG};;
            e)      EMREP_PWD=${OPTARG};;
            r)      SYS_USER=${OPTARG};;
            :)      $ECHO "Missing required argument for \"-${OPTARG}\""
                    $ECHO ""
                    usage
                    exit 1;;
            *)      $ECHO "Invalid command qualifier \"${OPTARG}\""
                    $ECHO ""
                    usage
                    exit 1;;
        esac
    done
}
validatePassword()
{
        # The empty line before the connect string avoids prompt 
        # related problems that might arise due to glogin.sql
	${ORACLE_HOME}/bin/sqlplus -silent /nolog > ${CCR_CONFIG_HOME}/log/$_script${ORACLE_SID}_chk.log 2>&1 << EOF   

    	connect ${SYS_USER}/${SYS_DBA_PSWD} as sysdba
	select * from dual;
	exit
EOF

	if [ -f ${CCR_CONFIG_HOME}/log/$_script${ORACLE_SID}_chk.log ]
	then
                errors1=`$EGREP -c 'ORA-01031'  ${CCR_CONFIG_HOME}/log/$_script${ORACLE_SID}_chk.log`;
                errors2=`$EGREP -c 'ORA-12638'  ${CCR_CONFIG_HOME}/log/$_script${ORACLE_SID}_chk.log`;
                if [ -z "$CCR_INSTALL_DEBUG" ]
                then
                  $RM ${CCR_CONFIG_HOME}/log/$_script${ORACLE_SID}_chk.log
                fi
    		if [ $errors1 != 0 ]
    		then
			$ECHO "Password for the SYSDBA user \"$SYS_USER\" is not correct!"
			$ECHO ""
			usage
			exit 1
    		fi
    		if [ $errors2 != 0 ]
    		then
			$ECHO "Credential retrieval failed."
			$ECHO ""
			usage
			exit 1
    		fi
	fi
}

isOCMConfigured()
{
  _licenseAccepted=0

  if [ -f ${CCR_CONFIG_HOME}/config/collector.properties ]
  then
    _acceptee=`$EGREP '^ccr.agreement_signer=' ${CCR_CONFIG_HOME}/config/collector.properties | $SED -e "s?^ccr.agreement_signer=\s*??"`
    if [ ! -z "$_acceptee" ] 
    then
      _licenseAccepted=1
    fi
  fi
}

setHostName()
{
  CCR_HOST_NAME=`hostname`

  export CCR_HOST_NAME
}

setOCMDirPaths()
{
  # Check whether its a 10.2.7+ OCM install vs upgrade
  if [ -d ${CCR_HOME}/hosts ]
  then
    if [ -z "${ORACLE_CONFIG_HOME}" ]
    then
      CCR_CONFIG_HOME="${CCR_HOME}/hosts/${CCR_HOST_NAME}"
    elif [ -d ${ORACLE_CONFIG_HOME} ]
    then
      CCR_CONFIG_HOME="${ORACLE_CONFIG_HOME}/ccr"
    else
      $ECHO '$ORACLE_CONFIG_HOME should point to the directory containing OCM configurations for the host.'
      exit -1
    fi
  else
    CCR_CONFIG_HOME=${CCR_HOME}
  fi

  # OCM should be configured for this host/home, if its NOT
  # Exit
  isOCMConfigured
  if [ $_licenseAccepted -ne 1 ]
  then
     $ECHO "OCM is not configured for this host or ORACLE_CONFIG_HOME. Please configure OCM first!!!!"
     exit -1
  fi

  export CCR_CONFIG_HOME
}

executeScripts()
{
    if [ -z "$LD_LIBRARY_PATH" ]
    then
        LD_LIBRARY_PATH=${ORACLE_HOME}/lib
    else
        LD_LIBRARY_PATH=${ORACLE_HOME}/lib:${LD_LIBRARY_PATH}
    fi
    export LD_LIBRARY_PATH
    
   #If sys user is specified in command line but password is missed
   #prompt for it
    if [  ! -z "$SYS_USER"  -a \
		-z "$SYS_DBA_PSWD" ] 
    then
	$PRINTF "Provide password for the SYSDBA user \"$SYS_USER\": "
	oldmodes=`${STTY} -g`
	${STTY} -echo
	read SYS_DBA_PSWD
	${STTY} $oldmodes
	$ECHO ""
    fi

    if [ ! -z "$SYS_DBA_PSWD" ]
    then
        if [ "$SYS_USER" = "" ]
        then
                SYS_USER="sys"
        fi
    fi 

    validatePassword;

    # The empty line before the connect string avoids prompt 
    # related problems that might arise due to glogin.sql  
    ${ORACLE_HOME}/bin/sqlplus /nolog > ${CCR_CONFIG_HOME}/log/$_script${ORACLE_SID}.log 2>&1 << EOF   

    connect ${SYS_USER}/${SYS_DBA_PSWD} as sysdba
    set echo off
    ${COMMAND};
    exit
EOF
	error_code=$?
	errors="0"
	if [ -f ${CCR_CONFIG_HOME}/log/$_script${ORACLE_SID}.log ]
	then
		if [ `$EGREP -c 'ORA-01034'  ${CCR_CONFIG_HOME}/log/$_script${ORACLE_SID}.log` != 0 ]
		then
                        if [ -z "$CCR_INSTALL_DEBUG" ]
                        then
                          $RM ${CCR_CONFIG_HOME}/log/$_script${ORACLE_SID}.log
                        fi
			$ECHO "The database with SID=\"${ORACLE_SID}\" and ORACLE_HOME=\"${ORACLE_HOME}\" is not up. Startup the database and then rerun $0."
			exit 1
    		fi
    		errors=`$EGREP -c -e 'ORA-' -e 'SP2-'  ${CCR_CONFIG_HOME}/log/$_script${ORACLE_SID}.log`;
	fi

	if [ $errors != 0 ] || [ $error_code != 0 ] 
	then
		$ECHO "An error had occured."
		$ECHO "For details, check the log file at ${CCR_CONFIG_HOME}/log/$_script${ORACLE_SID}.log"
		exit 1
    	else
		$ECHO "Successfully installed $_script in the database with SID=${ORACLE_SID}."
                if [ -z "$CCR_INSTALL_DEBUG" ]
                then
                  $RM ${CCR_CONFIG_HOME}/log/$_script${ORACLE_SID}.log
                fi
    	fi
}
_script=$1
if [ $# -eq 0 ]
then
   $ECHO "The type of configuration instrumentation was not specified."
   usage
   exit 1
fi

shift 

# shared OH support requires these
#

setHostName
setOCMDirPaths

SYS_DBA_PSWD=""
SYS_USER=""
APPS_USER=""
APPS_PSWD=""
GCREP_PWD=""
COMMAND="@${ORACLE_HOME}/ccr/admin/scripts/${_script} ${CCR_CONFIG_HOME}/state"

# Unset SQLPATH to avoid login.sql
SQLPATH=""
export SQLPATH

# Save cwd and cd to ccr/admin/scripts since
# login.sql is also searched for in cwd
CWD=$PWD
$CD ${ORACLE_HOME}/ccr/admin/scripts

getOptions $@

validateArgs
executeScripts

# Return to previous directory
$CD $CWD
