#!/bin/sh
#
# $Header: emll/admin/scripts/instrumentEM.sh /main/1 2008/09/25 02:22:01 nmittal Exp $
#
# instrumentEM.sh
#
# Copyright (c) 2008, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      instrumentEM.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      Script to instrument EM repository for OCM collection. 
#      This script calls ocm_instrumentation.pl.
#      Execute "instrumentEM.sh -help" for usage.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nmittal     09/17/08 - Creation
#

if [ "$ORACLE_HOME" = "" ]
then
  printf "$ORACLE_HOME environment variable should be set to create EM repository...\n"
  exit 1
fi

#look in OH in both a view and an install
EMDW_HOME=$ORACLE_HOME

PERL5LIB_TMP=$ORACLE_HOME/perl/lib:$ORACLE_HOME/perl/lib/site_perl:$ORACLE_HOME/perl/libwww-perl/lib:$ORACLE_HOME/perl/ext/POSIX:$ORACLE_HOME/perl/URI:$ORACLE_HOME/perl/HTML_Parser:$ORACLE_HOME/perl/HTML-Parser/lib:$EMDROOT/sysman/admin/scripts:$EMDROOT/bin:$ORACLE_HOME/sysman/admin/emdrep/bin:$ORACLE_HOME/sysman/install:$ORACLE_HOME/sysman/install/install

if [ "$PERL5LIB" = "" ] ;
then
   PERL5LIB=${PERL5LIB_TMP}
else
   PERL5LIB=${PERL5LIB_TMP}:${PERL5LIB}
fi

if [ "$LD_LIBRARY_PATH" = "" ] ; then
   LD_LIBRARY_PATH=$ORACLE_HOME/lib32:$ORACLE_HOME/lib:$ORACLE_HOME/network/lib32:$ORACLE_HOME/network/lib:$ORACLE_HOME/perl/lib:$EMDROOT/lib
else
   LD_LIBRARY_PATH=$ORACLE_HOME/lib32:$ORACLE_HOME/lib:$ORACLE_HOME/network/lib32:$ORACLE_HOME/network/lib:$ORACLE_HOME/perl/lib:$EMDROOT/lib:$LD_LIBRARY_PATH
fi

if [ "$SHLIB_PATH" = "" ] ; then
   SHLIB_PATH=$ORACLE_HOME/lib32:$ORACLE_HOME/network/lib32:$ORACLE_HOME/perl/lib:$EMDROOT/lib32
else
   SHLIB_PATH=$ORACLE_HOME/lib32:$ORACLE_HOME/network/lib32:$ORACLE_HOME/perl/lib:$EMDROOT/lib32:$SHLIB_PATH
fi

if [ "$LIBPATH" = "" ] ; then
   LIBPATH=$ORACLE_HOME/lib32:$ORACLE_HOME/lib:$ORACLE_HOME/network/lib32:$ORACLE_HOME/network/lib:$ORACLE_HOME/perl/lib:$EMDROOT/lib32:$EMDROOT/lib
else
   LIBPATH=$ORACLE_HOME/lib32:$ORACLE_HOME/lib:$ORACLE_HOME/network/lib32:$ORACLE_HOME/network/lib:$ORACLE_HOME/perl/lib:$EMDROOT/lib32:$EMDROOT/lib:$LIBPATH
fi


export PERL5LIB
export LD_LIBRARY_PATH
export SHLIB_PATH
export LIBPATH

$ORACLE_HOME/perl/bin/perl $EMDW_HOME/sysman/admin/scripts/ocm/ocm_instrumentation.pl $*

# Exit with thre return value from perl
exit $?
