Rem
Rem $Header: emll/admin/scripts/ocm_instrumentation.sql /main/1 2008/09/25 02:22:01 nmittal Exp $
Rem
Rem ocm_instrumentation.sql
Rem
Rem Copyright (c) 2008, Oracle and/or its affiliates. All rights reserved.
Rem
Rem    NAME
Rem      ocm_instrumentation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    nmittal     09/16/08 - Created
Rem

SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100
SET serveroutput on
SET escape on
SET VERIFY off
SET FEEDBACK 0
SET HEADING OFF

VARIABLE ocm_dir VARCHAR2(4000);

define OCM_SCRIPT = "&1";

DECLARE
  pfid        NUMBER;  
  --hostname    VARCHAR2(250);
  root        VARCHAR2(2000);
  l_ocm_dir_path VARCHAR2(4000);
  PLATFORM_WINDOWS32    CONSTANT BINARY_INTEGER := 7;
  PLATFORM_WINDOWS64    CONSTANT BINARY_INTEGER := 8;
  PLATFORM_OPENVMS      CONSTANT BINARY_INTEGER := 15;
BEGIN
    -- get the platform id
    SELECT platform_id INTO pfid FROM v$database;
    
    --host name with domain name
    --hostname := UTL_INADDR.get_host_name(UTL_INADDR.get_host_address);

    IF pfid = PLATFORM_OPENVMS THEN
      -- ORA_ROOT is a VMS logical name
      :ocm_dir := 'ORA_ROOT:[ccr.state]';
    ELSE
      -- Get ORACLE_HOME
      BEGIN
       -- for 10.2+ db version dbms_sysmtem_get_env. For other version this with throws exception
       execute immediate 'BEGIN DBMS_SYSTEM.GET_ENV(''ORACLE_HOME'', :1); END;' using out root;
      EXCEPTION
       WHEN OTHERS then
        -- for pre 10.2 db 
        select NVL(substr(file_spec, 1, instr(file_spec, '\', -1, 2) -1) ,
                   substr(file_spec, 1, instr(file_spec, '/', -1, 2) -1)) folder
               into root
        from dba_libraries
        where library_name = 'DBMS_SUMADV_LIB';
      END;
 
      -- Return platform-specific string
      IF pfid = PLATFORM_WINDOWS32 OR pfid = PLATFORM_WINDOWS64
      THEN
        --:ocm_dir := root || '\ccr\hosts\' || hostname || '\state';
        :ocm_dir := root || '\ccr\state';
      ELSE
        --:ocm_dir := root || '/ccr/hosts/' || hostname || '/state';
        :ocm_dir := root || '/ccr/state';
      END IF;
    END IF;
END;
/

column ocm_dir new_value ocm_dir noprint;
select :ocm_dir as ocm_dir from dual;

@&OCM_SCRIPT &ocm_dir
