Rem
Rem $Header: emll/admin/scripts/ocm_lms_emgc.sql /main/1 2008/12/01 14:52:04 ndutko Exp $
Rem
Rem ocm_lms_emgc.sql
Rem
Rem Copyright (c) 2008, Oracle and/or its affiliates.All rights reserved. 
Rem
Rem    NAME
Rem      ocm_lms_emgc.sql - Collects supplemental Grid control usage info
Rem
Rem    DESCRIPTION
Rem      This is an optional script that gathers Oracle Grid Control usage
Rem      
Rem      The information gathered includes the packs that are licensed and
Rem      configured
Rem
Rem      This script could be used by Oracle License Management Services to 
Rem      determine the product Packs enabled.
Rem
Rem      Script Execution:
Rem      1. Log into the Grid Control repository with a privileged account
Rem      2. Execute this script by entering the command: START ocm_lms_emgc.sql
Rem      3. Send the resulting file created in the default folder called: OCM_emgc.txt
Rem
Rem    NOTES
Rem      This script will work for Oracle Grid Control 10.2 onwards
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    BHSRINIV    12/01/08 - Created
Rem

SPOOL ./OCM_emgc.txt

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

define OEMOWNER=SYSMAN
col OEMOWNER new_val OEMOWNER format a30 wrap
select 'OEM REPOSITORY SCHEMA:' C_, owner as OEMOWNER from dba_tables where
table_name = 'MGMT_ADMIN_LICENSES';
select a.pack_display_label as OEM_PACK,
       a.target_type, 
       decode(b.pack_name, null, 'NO', 'YES') as ACCESS_GRANTED
  from &&OEMOWNER..MGMT_LICENSE_DEFINITIONS a,
       &&OEMOWNER..MGMT_ADMIN_LICENSES      b
  where a.pack_label = b.pack_name   (+)
  order by 1, 2, 3; 
