Rem
Rem $Header: emll/admin/scripts/ocm_lms_rdbms.sql /main/1 2008/12/01 14:52:04 ndutko Exp $
Rem
Rem ocm_lms_rdbms.sql
Rem
Rem Copyright (c) 2008, Oracle and/or its affiliates.All rights reserved. 
Rem
Rem    NAME
Rem      ocm_lms_rdbms.sql - Collects Partitioning usage information
Rem
Rem    DESCRIPTION
Rem      This is an optional script that gathers RDBMS Partitioning statistics
Rem      
Rem      The information gathers the owner, segment type and name as well as 
Rem      counts of partitions.
Rem
Rem      This script could be used by Oracle License Management Services to
Rem      determine the Partioning usage.
Rem
Rem      Script Execution:
Rem      1. Log into the repository with an account with SYSDBA privilege
Rem      2. Execute this script by entering the command: START ocm_lms_rdbms.sql
Rem      3. Send the resulting file created in the default folder called: OCM_rdbms.txt
Rem
Rem    NOTES
Rem      This script will work for Oracle RDBMS 9.2 onwards
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    BHSRINIV    12/01/08 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

SELECT
OWNER,
SEGMENT_TYPE,
SEGMENT_NAME,
COUNT(*),
MIN(PARTITION_NAME),
MAX(PARTITION_NAME)FROM DBA_SEGMENTS
WHERE SEGMENT_TYPE LIKE '%PARTITION%'
   OR PARTITION_NAME IS NOT NULL
GROUP BY OWNER, SEGMENT_TYPE, SEGMENT_NAME
ORDER BY 1; 
