Rem     
Rem $Header: ocm_oausers_11i.sql 22-oct-2007.09:01:56 ndutko Exp $
Rem
Rem ocm_oausers_11i.sql
Rem
Rem Copyright (c) 2005, 2007, Oracle. All rights reserved.
Rem
Rem    NAME
Rem      ocm_oausers_11i.sql - Optional License On Demand Script
Rem
Rem    DESCRIPTION
Rem      This is an optional script that gathers Oracle Ebusiness suite Users.
Rem
Rem      The information gathered includes user details, responsiblities and 
Rem      applications accessed.
Rem
Rem      This script could be used by Oracle License Management Services to 
Rem      determine the number of user licenses needed,
Rem
Rem      Script Execution:
Rem      1. Log into the APPLSYS schema where the Oracle Applications tables are installed
Rem      2. Execute this script by entering the command: START ocm_oausers_11i.sql
Rem      3. Send the resulting file created in the default folder called: OCM_OAUsers.txt
Rem
Rem    NOTES
Rem      This script will work for Oracle Application 11i onwards (11.5.4 and above)
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    BHSRINIV    10/22/07 - Created
Rem

SPOOL ./OCM_OAUsers.txt
SET SERVEROUTPUT ON;
SET HEADING OFF;

SELECT 'USER NAME, USER ID, DESCRIPTION, START DATE, END DATE, LAST LOGON DATE, RESPONSIBILITY_ID,'||
	 'USER RESP END DATE, RESPONSIBILITY NAME, RESP END DATE, APPLICATION ID, APPLICATION NAME, APPL SHORT NAME' FROM DUAL;
 
select fu.user_name||','||fur.user_id||','||fu.description||','||fu.start_date||','||
	 fu.end_Date||','||fu.last_logon_date||','||fur.responsibility_id||','||fur.end_date||','||
	 fr.responsibility_name||','||fr.end_date||','||fr.application_id||','||fal.application_name||','||
	fa.application_short_name
from fnd_user fu, fnd_user_resp_groups fur, fnd_responsibility fr,
    fnd_application_tl fal, fnd_application fa
where fu.user_id= fur.user_id
and   fur.responsibility_id = fr.responsibility_id
and   fr.application_id= fal.application_id
and   fal.application_id = fa.application_id;

SPOOL OFF
/

