Rem
Rem $Header: ocmjb.sql 31-jul-2007.09:01:57 dkapoor Exp $
Rem
Rem ocmjb.sql
Rem
Rem Copyright (c) 2005, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ocmjb.sql - OCM db config collection Job package Body for pre 10g
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dkapoor     07/31/07 - add stats job for pre-10g
Rem    dkapoor     09/14/06 - call show errors at the end
Rem    dkapoor     07/26/06 - dont use define 
Rem    dkapoor     06/02/06 - change ccr_user to ocm 
Rem    dkapoor     10/10/05 - change user to ccr 
Rem    dkapoor     09/30/05 - impl 8.1.7 support 
Rem    ndutko      08/03/05 - ndutko_code_checkin
Rem    dkapoor     04/12/05 - Created
Rem


CREATE OR REPLACE PACKAGE body ORACLE_OCM.MGMT_CONFIG AS

JOB_NAME constant VARCHAR2(40) := 'ORACLE_OCM.MGMT_CONFIG.collect_config;';
STATS_JOB_NAME constant VARCHAR2(60) := 'ORACLE_OCM.MGMT_CONFIG.collect_stats;';

CONFIG_PROC_NAME constant VARCHAR2(60) := 'ORACLE_OCM.MGMT_DB_LL_METRICS.collect_config_metrics';
STATS_PROC_NAME constant VARCHAR2(60) := 'ORACLE_OCM.MGMT_DB_LL_METRICS.collect_stats_metrics';

/*
 Get WHAT for the job
*/
FUNCTION get_job_what(p_proc_name IN VARCHAR2 DEFAULT CONFIG_PROC_NAME)
 RETURN VARCHAR2 IS
BEGIN 
     IF 
	MGMT_DB_LL_METRICS.get_version_category() = MGMT_DB_LL_METRICS.VERSION_9i OR
	MGMT_DB_LL_METRICS.get_version_category() = MGMT_DB_LL_METRICS.VERSION_817 THEN
            return p_proc_name ||'(''&1'');';
     ELSE
            return p_proc_name ||'(''ORACLE_OCM_CONFIG_DIR'');';
     END IF;
END get_job_what;

/*
 Checks to see if the job already exists
*/
FUNCTION job_exists(p_job_name IN VARCHAR2 DEFAULT JOB_NAME) RETURN BOOLEAN IS
  l_job_cnt NUMBER;
BEGIN
   select count(*) into l_job_cnt from 
      dba_jobs where what =  p_job_name and SCHEMA_USER ='ORACLE_OCM';
  if l_job_cnt = 0
  THEN
    return FALSE;
  ELSE
    return TRUE;
  END IF;
END job_exists;

FUNCTION get_job_num(p_job_name IN VARCHAR2 DEFAULT JOB_NAME) RETURN NUMBER IS
  l_job NUMBER;
BEGIN
     select job into l_job from 
        dba_jobs where what = p_job_name and SCHEMA_USER ='ORACLE_OCM';
     return l_job;
     EXCEPTION
      WHEN TOO_MANY_ROWS THEN
        RAISE_APPLICATION_ERROR(-20000,'There are more than one database '
                || 'configuration collection job. These are jobs with WHAT for job ='
                || '"'|| p_job_name || '"');
      WHEN NO_DATA_FOUND THEN
        RAISE_APPLICATION_ERROR(-20000,'There is no database '
                || 'configuration collection job. '
                || 'Create one using "MGMT_CONFIG.submit_job"');
      WHEN OTHERS THEN
	RAISE;
END get_job_num;


/*
Submit a job to collect the configuration.
Basically, a job with what->collect_config
*/
procedure submit_job IS
 l_job NUMBER;
BEGIN
  IF not job_exists THEN  
      DBMS_JOB.SUBMIT(l_job, 
            JOB_NAME,
            TRUNC(SYSDATE) + 1/24, 'TRUNC(SYSDATE) + 1 + 1/24');
     COMMIT;
  ELSE
      RAISE_APPLICATION_ERROR(-20000,'Cannot resubmit. A configuration collection job already exists.');
  END IF;

  IF not job_exists(STATS_JOB_NAME) THEN  
      DBMS_JOB.SUBMIT(l_job, 
            STATS_JOB_NAME,
            TRUNC(LAST_DAY(SYSDATE)) + 1/24, 
            'TRUNC(LAST_DAY(SYSDATE) + 1) + 1/24');
     COMMIT;
  ELSE
      RAISE_APPLICATION_ERROR(-20000,'Cannot resubmit. A statistics collection job already exists.');
  END IF;
END submit_job;

/*
Submit a job to collect the configuration.
Basically, a job with what->collect_config_metrics(<collection directory>
*/
procedure submit_job_for_inst(p_what IN VARCHAR2,inst_id IN BINARY_INTEGER DEFAULT NULL) IS
 l_job NUMBER;
BEGIN
    DBMS_JOB.SUBMIT(l_job, 
            p_what,
            SYSDATE, NULL,FALSE,inst_id);
    COMMIT;
END submit_job_for_inst ;

/*
Runs the configuration collection job now.
*/
procedure run_now IS
    l_job NUMBER;
BEGIN
	l_job := get_job_num;
	DBMS_JOB.RUN(l_job);
	COMMIT;

	l_job := get_job_num(STATS_JOB_NAME);
	DBMS_JOB.RUN(l_job);
	COMMIT;
END run_now;

/*
Print the job details.
*/
procedure print_job_details IS
l_next_date dba_jobs.next_date%TYPE;
l_next_sec dba_jobs.next_sec%TYPE;
l_job NUMBER;
BEGIN
        l_job := get_job_num;
        SELECT next_date ,next_sec INTO l_next_date , l_next_sec
        FROM dba_jobs WHERE job = l_job and SCHEMA_USER ='ORACLE_OCM';
        dbms_output.put_line('Next Date: '|| to_char(l_next_date,'MM-DD-YYYY'));
        dbms_output.put_line('Time: '|| l_next_sec);
END print_job_details;

/*
Stop the job.
*/
procedure stop_job IS
 l_job NUMBER;
BEGIN
    l_job := get_job_num;
    DBMS_JOB.remove(l_job);
    COMMIT;

    l_job := get_job_num(STATS_JOB_NAME);
    DBMS_JOB.remove(l_job);
    COMMIT;
END stop_job;

/*
Change interval of the job.
*/
procedure change_interval(l_interval IN VARCHAR2) IS
 l_job NUMBER;
BEGIN
    l_job := get_job_num;
   	DBMS_JOB.interval(l_job,l_interval);
  	COMMIT;
END change_interval;


/*
Change next date of the job.
*/
procedure change_next_date(next In Date) IS
 l_job NUMBER;
BEGIN
    l_job := get_job_num;
   	DBMS_JOB.next_date(l_job,next);
  	COMMIT;
END change_next_date;

/*
Config collection job
*/
procedure collect_config IS
  CURSOR l_res_cur IS select inst_id from gv$instance;
BEGIN
	FOR inst_id_row in l_res_cur LOOP
		submit_job_for_inst(get_job_what(),inst_id_row.inst_id);
	END LOOP;
END collect_config;

/*
Statistics collection job
*/
procedure collect_stats IS
  CURSOR l_res_cur IS select inst_id from gv$instance;
BEGIN
  FOR inst_id_row in l_res_cur LOOP
    submit_job_for_inst(get_job_what(STATS_PROC_NAME),inst_id_row.inst_id);
  END LOOP;
END collect_stats;

END MGMT_CONFIG;
/
show errors package body ORACLE_OCM.MGMT_CONFIG;
