Rem
Rem $Header: ocmjd.sql 31-jul-2007.09:01:56 dkapoor Exp $
Rem
Rem ocmjd.sql
Rem
Rem Copyright (c) 2005, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ocmjd.sql - OCM db config collection Job package Definition for pre 10g
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dkapoor     07/31/07 - add stats job for pre-10g
Rem    dkapoor     06/02/06 - change ccr_user to ocm 
Rem    dkapoor     10/10/05 - change user to ccr 
Rem    ndutko      08/03/05 - ndutko_code_checkin
Rem    dkapoor     04/08/05 - Created
Rem

CREATE OR REPLACE PACKAGE ORACLE_OCM.MGMT_CONFIG AS
/*
Submit a job to collect the configuration.
Basically, a job with what->printCollectConfigMetrics(<collection directory>
*/
procedure submit_job;

/*
Runs the configuration collection job now.
*/
procedure run_now;

/*
Stop the job.
*/
procedure stop_job;

/*
Print the job details.
*/
procedure print_job_details;

/*
Change interval of the job.
*/
procedure change_interval(l_interval IN VARCHAR2);

/*
Change next date of the job.
*/
procedure change_next_date(next In Date);

/*
Config collection job
*/
procedure collect_config;


/*
Statistics collection job
*/
procedure collect_stats;

END MGMT_CONFIG;
/
show errors package MGMT_CONFIG;

