<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:include href="../../admin/xsl/host_preview.xsl" />
<xsl:include href="../../admin/xsl/oracle_home_preview.xsl" />
<xsl:include href="db_preview.xsl" />

<xsl:template match="UPLOAD">
  <html>
  <head>
  <link rel="stylesheet" type="text/css"  href="../../admin/css/oracle.css" media="all"/>
  </head>
  <body>
  	<table border="1">
  	<th style="background:rgb(204,204,153)">
	  	<center><h1 class="x18">Oracle Configuration Manager Collection Report</h1></center>
  	</th>
  	<tr>
  		<td>
    <h2 class="x18">Configuration Information for
       <xsl:value-of select=
         "ROWSET[@TABLE='MGMT_ECM_LIVE_LINK_TARGETS']/ROW/HOST_NAME"/>
    </h2>

    <span class="x56">Data Collected at: </span> 
    <span class="x55"><xsl:value-of select="@COLLECTION_TIMESTAMP"/></span>
    <br />

    <xsl:apply-templates/>

    <p style="font-family:arial,helvetica,geneva,sans-serif; font-size:xx-small">
    Copyright 2005, 2006,Oracle. All Rights Reserved.
    </p>

  		</td>
  	</tr>
  	</table>
  	
  </body>
  </html>
</xsl:template>
<xsl:template match="ROWSET">
<p>
<h3 class="x18">

	<xsl:choose>
		<xsl:when test="//ROWSET[@TABLE='MGMT_ECM_LIVE_LINK_TARGETS']/ROW/TARGET_TYPE = 'host' ">
	    	<xsl:call-template name="host_titles"/>
		</xsl:when>
		<xsl:when test="//ROWSET[@TABLE='MGMT_ECM_LIVE_LINK_TARGETS']/ROW/TARGET_TYPE = 'oracle_home' ">
	    	<xsl:call-template name="oracle_home_titles"/>
		</xsl:when>
		<xsl:when test="//ROWSET[@TABLE='MGMT_ECM_LIVE_LINK_TARGETS']/ROW/TARGET_TYPE = 'oracle_database' ">
	    	<xsl:call-template name="db_titles"/>
		</xsl:when>
	</xsl:choose>
</h3>
	<xsl:choose>
	  <xsl:when test="count(ROW)=1">
	    <table class="x1h" border="0" cellspacing="1" cellpadding="1">
	    <xsl:for-each select="ROW">
	      <xsl:for-each select="*">
	        <tr>
	          		<td align="right" class="x1r x4j" ><xsl:value-of select='name()'/></td>
	          <td align="left" class="x1l x4x"  style="background:rgb(247,247,231)"><xsl:value-of select='.'/></td>
	        </tr>
	      </xsl:for-each>
	    </xsl:for-each>
	    </table>
	  </xsl:when>
	  <xsl:otherwise>
	    <table class="x1h" >
	    <tr>
	      <xsl:for-each select="ROW[1]/*">
	        <th align="center" class="x1r x4j">
	          <xsl:value-of select='name()'/>
	        </th>
	      </xsl:for-each>
	    </tr>
	    <xsl:for-each select="ROW">
	      <tr >
	        <xsl:for-each select="*">
	          <td align="left" class="x1l x4x" >
	            <xsl:value-of select='.'/>
	          </td>
	        </xsl:for-each>
	      </tr>
	    </xsl:for-each>
	    </table>
	  </xsl:otherwise>
	</xsl:choose>
</p>    
<br />
</xsl:template>



</xsl:stylesheet>


