<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="Targets">
  <html>
  <head>
  <link rel="stylesheet" type="text/css"  href="../../admin/css/oracle.css" media="all"/>
  </head>
  <body>
  	<table border="1">
  	<th style="background:rgb(204,204,153)">
	  	<center><h1 class="x18">Oracle Configuration Manager Collection Report</h1></center>
  	</th>
  	<tr>
  		<td>
    <h2 class="x56">Configuration Information for
       <xsl:value-of select="@host_name"/>
    </h2>

    <span class="x56">Data Collected at: </span> 
    	<span class="x55"><xsl:value-of select="@collection_time"/></span>
    <br />

	<table class="x1h" border="1">
	<tr class="x1r x4j" >
		<th>
			Target Type
		</th>
		<th>
			Name
		</th>
		<th>
			Collections
		</th>
	</tr>
    <xsl:apply-templates/>
	</table>
    <p style="font-family:arial,helvetica,geneva,sans-serif; font-size:xx-small">
    Copyright 2005, 2006,Oracle. All Rights Reserved.
    </p>

  		</td>
  	</tr>
  	</table>
  	
  </body>
  </html>
</xsl:template>
<xsl:template match="Target">
	<tr >
		<td class="OraTableCellText OraTableBorder1111 x5a">
			<xsl:value-of select="@type"/>
		</td>
		<td class="OraTableCellText OraTableBorder1111 x5a">
			<xsl:value-of select="@name"/> 
		</td>
		<td class="OraTableCellText OraTableBorder1111 x5a" >
			<table width="100%" class="OraTableContent" border="0">
    			<xsl:apply-templates/>			
			</table>
		
		</td>
	</tr>
</xsl:template>

<xsl:template match="Collection">
	<tr>
		<td width="100%" class="OraTableCellText OraTableBorder1111">
			<a> 
			  <xsl:attribute name="href">
			    <xsl:value-of select="@file" />
			  </xsl:attribute>
			<xsl:value-of select="@name"/> 
			</a > 
		</td>
	</tr>
</xsl:template>
</xsl:stylesheet>


