#!/bin/sh
#
# $Header: emll/bin/getUsersCentralPropsLocAndOwner.sh /main/1 2012/06/14 11:40:59 fmorshed Exp $
#
# getUsersCentralPropsLocAndOwner.sh
#
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getUsersCentralPropsLocAndOwner.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    03/17/12 - Creation
#
_binDir=/bin
_usrBinDir=/usr/bin

SU=${_binDir}/su
MKDIR=${_binDir}/mkdir
CHOWN=${_binDir}/chown
CHGRP=${_binDir}/chgrp
LS=${_binDir}/ls
CHMOD=${_binDir}/chmod
if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

if [ -f ${_binDir}/uname ]
then
    UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
    UNAME=${_usrBinDir}/uname
fi
AWK=${_binDir}/awk
PLATFORM=`$UNAME | $CUT -f1`
ECHO=${_binDir}/echo
if [ "$PLATFORM" = "SunOS" ]
then
    if [ -f ${_binDir}/nawk ]
    then
        AWK=${_binDir}/nawk
    elif [ -f ${_usrBinDir}/nawk ]
    then
        AWK=${_usrBinDir}/nawk
    fi
fi

# 
filePassedIn=$1
owner=`ls -Lld ${filePassedIn} | awk '{print $3}'`
if [ "${owner}" = "root" ]
then
    if [ "$PLATFORM" = "SunOS" ]
    then
    	$ECHO "/var/ocm\c"
        $ECHO ",\c"
        $ECHO "${owner}\c"
    else
        echo -n "/var/ocm","${owner}"
    fi
    exit 0
fi
home=`csh -fc "echo ~${owner}"`
if [ "$PLATFORM" = "SunOS" ]
then
    $ECHO "${home}\c"
    $ECHO ",\c"
    $ECHO "${owner}\c"
else
    echo -n "${home}","${owner}"
fi
