#!/bin/sh
#
# $Header: emll/bin/makeDirSameOwner.sh /main/1 2012/06/14 11:40:59 fmorshed Exp $
#
# makeDirSameOwner.sh
#
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      makeDirSameOwner.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    02/24/12 - For creating a state directory for a ccr home for max upload purposes.
#    fmorshed    02/24/12 - Creation
#
_binDir=/bin
_usrBinDir=/usr/bin

MKDIR=${_binDir}/mkdir
CHOWN=${_binDir}/chown
CHGRP=${_binDir}/chgrp
LS=${_binDir}/ls
CHMOD=${_binDir}/chmod
if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

if [ -f ${_binDir}/uname ]
then
    UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
    UNAME=${_usrBinDir}/uname
fi
AWK=${_binDir}/awk
PLATFORM=`$UNAME | $CUT -f1`
if [ "$PLATFORM" = "SunOS" ]
then
    if [ -f ${_binDir}/nawk ]
    then
        AWK=${_binDir}/nawk
    elif [ -f ${_usrBinDir}/nawk ]
    then
        AWK=${_usrBinDir}/nawk
    fi
fi


# Create a directory by the name of the first parameter under the directory path specified by the second
# parameter.  Change the owner and group of the created directory to the specified directory.
parentDirPath=$1
dirNameToCreate=$2
$MKDIR ${parentDirPath}/${dirNameToCreate}
OWNER=`$LS -Llnd ${parentDirPath} |$AWK '{print $3}'`
$CHOWN ${OWNER} ${parentDirPath}/${dirNameToCreate}
GROUP=`$LS -Llnd ${parentDirPath} |$AWK '{print $4}'`
$CHGRP ${GROUP} ${parentDirPath}/${dirNameToCreate}
$CHMOD 740 ${parentDirPath}/${dirNameToCreate}
