#
# Converts a path string to remove the relativeness of path elements
# to short concise path. 
#
# Assumes the PWD variable was set when AWK is launched to the current
# working directory. 
#
{ 
  DIR = $0;
  PSEP = "/";

  # Add a trailing slash if one is not present.
  if (substr(DIR, length(DIR)) != "/") DIR = DIR PSEP;
  
  if (DIR == "./") DIR = PWD PSEP;
  else if (DIR !~ /^\//) DIR = PWD PSEP DIR;

  # 
  # While there is a relative directory specification, remove the 
  # relative pathness iteratively till there are no entries
  while ( DIR ~ /\/\.\.\// )
  {
     DIRC = split(DIR, DIR_ELEM, PSEP);

     for (idx = 1; idx < DIRC+1; idx++)
        if (DIR_ELEM[idx] == "..") break;

     DIR = "";
     for (n = 2; n < idx-1; n++)
        DIR = DIR "/" DIR_ELEM[n];

     for (n=idx+1; n < DIRC+1; n++)
        DIR = DIR "/" DIR_ELEM[n];
  }
}
END { print substr(DIR,0,length(DIR)-1) }
