#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/P6_discover.pl /main/2 2009/07/31 13:09:56 snathan Exp $
#
# P6_discover.pl
# 
# Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      P6_discover.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      Discovers the P6 Target
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nmittal     07/03/09 - Creation
# 

use strict;
use File::Spec;
use Cwd;
use Cwd 'abs_path';
use File::Basename;

my ($emdRoot,$hostName) = @ARGV;
my $p6_bootstrap_file;
my $bFound = 0;

my $P6_HOME = $ENV{PRIMAVERA_HOME};

## Uncomment this line to explicitly set P6_HOME folder
## $P6_HOME = "c:/PVHome70";

if (length($P6_HOME) > 0)
{
    $p6_bootstrap_file = File::Spec->catfile($P6_HOME, "BREBootStrap.xml");
    if (-e $p6_bootstrap_file)
    {
        $bFound = 1;
    }
}

if (!$bFound)
{
    my $thisScriptPath = abs_path(dirname($0));
    $P6_HOME = dirname($thisScriptPath);
    
    for (my $i = 0; $i < 5; $i++)
    {
        $p6_bootstrap_file = File::Spec->catfile($P6_HOME, "BREBootStrap.xml");
        if (-e $p6_bootstrap_file)
        {
            $bFound = 1;
            last;
        }
        $P6_HOME = abs_path($P6_HOME."/..");
    }

}

if ($bFound)
{
    $P6_HOME = abs_path($P6_HOME);
    printf ("<Target NAME=\"Oracle Primavera P6\" TYPE=\"PrimaveraP6\">\n");
    printf "    <Property NAME=\"P6HOME\" VALUE=\"$P6_HOME\"/>\n";
    print  "</Target>\n";
}
