#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/coh_discover.pl /main/3 2012/01/10 13:43:13 prbhoj Exp $
#
# coh_discover.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      coh_discover.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    prbhoj      01/09/12 - Fix bug 13572101 - Change Exalogic rack type from
#                           exalogic_rack to exa_rack
#    prbhoj      10/28/11 - Add modifications for Exalogic and non-Coherence*Web deployments
#    prbhoj      02/10/11 - Creation
# 

BEGIN
{
    require "emd_common.pl";
}

use strict;
#use LL_OH_Utilities;
use ias::propertiesFileParser;
use ias::simpleXPath;
use fmw::Targets;
use mwm::exalogicUtil;

my ( $emdRoot, $hostName ) = @ARGV;

# Get the middleware home from BEA_HOME environment variable
my $middlewareHome = $ENV{'BEA_HOME'};
# Since OCM support for Coherence is only for Coherence installed as part of FMW deployment so 
# if BEA_HOME is not defined, exit discovery
if (!defined($middlewareHome))
{
    EMD_PERL_DEBUG("COH: No BEA_HOME defined, aborting Coherence discovery");
    exit;
}

# Determine commEnv.sh file to get COHERENCE_HOME environment variable value
# Below logic is commented since there may be more than 1 WL Home per MW_HOME
# This is per Weblogic team. Leaving the code in in case we have to revert
# to supporting getting COHERENCE_HOME from commEnv.sh

#my $wlsHome = LL_OH_Utilities::getWLSOracleHome($middlewareHome);
#my $commEnvFileName = "$wlsHome/common/bin/commEnv.sh";

#EMD_PERL_DEBUG("COH: WLS Common Enviroment file is $commEnvFileName");

my $coherenceHome;

# Look for COHERENCE_HOME property in commEnv.sh. Use this if one is available
# otherwise use mwHome/coherence if present else use mwHome/coherence_<ver> if present
#if (-e $commEnvFileName)
#{
    #my %configProperties =  parsePropertiesFile($commEnvFileName);

    #for my $propName (keys %configProperties)
    #{
   	#my $cohProp = "COHERENCE_HOME";
   	#if ($propName eq $cohProp)
   	#{
            #$coherenceHome = $configProperties{$propName};
        #}
    #}
#}

# Look for existence of mwhome/coherence_<ver> directory. This will
# be set as oldCoherenceHome too. oldCoherenceHome is used to set
# OLD_ORACLE_HOME for out-of-place upgrade from 10.3.5 or 10.3.6 to 10.3.7

opendir(DIR, $middlewareHome);
my @coherenceFiles = grep{/^coherence_/} readdir(DIR);
my $coherenceVerDir = $coherenceFiles[0];
my $oldCoherenceHome;
if (defined ($coherenceVerDir)) {
   $oldCoherenceHome = "$middlewareHome/$coherenceVerDir";
}
closedir(DIR);

if (!defined($coherenceHome))
{
   my $coherenceDir = "$middlewareHome/coherence";

   if (!-d $coherenceDir) {
        $coherenceHome = $oldCoherenceHome;
   }
   else {
        $coherenceHome = $coherenceDir;
   }
}

$coherenceHome =~ tr/"//d;
$oldCoherenceHome =~ tr/"//d;

EMD_PERL_DEBUG("COH: Coherence home is $coherenceHome");
        
my $cohProdFile = "$coherenceHome/product.xml";
# Look for product.xml file in Coherence home. Exit if not present.
# Coherence version is collected from product.xml. The only metric
# collected for Coherence is version.
if (!-e $cohProdFile)
{
   EMD_PERL_DEBUG("COH: No product.xml in coherence home: $coherenceHome; skipping");
   exit;
}

# Fetch the Coherence product version from product.xml in Coherence home directory
my $cohConfig = ias::simpleXPath::parseFile($cohProdFile);
my @prNodes = ias::simpleXPath::queryForNodes($cohConfig, 'product/version');
my $cohVersion = ias::simpleXPath::getAttribute($prNodes[0], "value");

my $isCoherenceWeb = "false";
my $noDomainLocations = "false";

my $assocType = "member_of";

# Make sure the domain locations file exists
my $domainsFileName = "$middlewareHome/utils/ccr/domainlocation.properties";
if (!-e $domainsFileName)
{
    EMD_PERL_DEBUG("COH: No domainlocation.properties file found, aborting coherence discovery");
    $noDomainLocations = "true";
}

# Parse the domain locations file to find all domain homes on this host
if ($noDomainLocations eq "false")
{
    my %domainLocations = parsePropertiesFile($domainsFileName);
    my @domainHomes;
    for my $domainHost (keys %domainLocations)
    {
        my $lcDomainHost = lc($domainHost);
        if (lc($hostName) eq $lcDomainHost || lc($hostName) =~ /^$lcDomainHost\..+/)
        {
            push(@domainHomes, split(',', $domainLocations{$domainHost}));
        }
    }

    # Visit each unique domain and discover its targets
    for my $domainHome (@domainHomes)
    {
        # Make sure the domain config file exists
        my $configFileName = "$domainHome/config/config.xml";
        if (!-e $configFileName)
        {
            EMD_PERL_DEBUG("COH: No config.xml in domain home: $domainHome; skipping");
            next;
        }
    
        my $configFile = ias::simpleXPath::parseFile($configFileName);
        my $domainName = (ias::simpleXPath::queryForText($configFile,
            'domain/name'))[0];

        # Determine if the domain is part of an IAS install by looking
        # for the JRF template
        my $isIas = 0;
        if (-e "$domainHome/init-info/domain-info.xml")
        {
            my $domainInfoFile = ias::simpleXPath::parseFile(
                "$domainHome/init-info/domain-info.xml");
            my $jrf = (ias::simpleXPath::queryForAttributes($domainInfoFile,
                'domain-info/domain-template-info/identification[@name="Oracle JRF Extension"]'))[0];
            if (!defined($jrf))
            {
                $jrf = (ias::simpleXPath::queryForAttributes($domainInfoFile,
                    'domain-info/extention-template-ref[@name="Oracle JRF"]'))[0];
            }
            $isIas = defined($jrf);
        }

        # Domain target
        my $domainTarget = $isIas ? "/Farm_$domainName/$domainName" : "/$domainName";

        my $cohClusterFound = "false";

        # In Coherence*Web case, there will either be an entry for coherence-web-spi library
        # deployment OR if a cluster is added from WLS Console, an coherence-cluster-system-resource
        # is added. As part of discovery, either of these entries are searched for in domain's config.xml
        # If present, the Coherence deployment is considered to be a Coherence*Web deployment and a cluster
        # target is added with domain name prefix and an association is created between Coherence target and
        # domain target.
        my $cohCluster = (ias::simpleXPath::queryForText($configFile,
            'domain/coherence-cluster-system-resource/name'))[0];
        if (defined($cohCluster))
        {
            $cohClusterFound = "true";
            EMD_PERL_DEBUG("COH: Found coherence cluster from coherence-cluster-system-resource $cohCluster");
        }
        if ($cohClusterFound eq "false")
        {
            my @libs = ias::simpleXPath::queryForText($configFile,
                'domain/library/name');
            my @cohLibs = grep(/^coherence-web-spi/, @libs);
            if (@cohLibs)
            {
                $cohClusterFound = "true";
                EMD_PERL_DEBUG("COH: Found coherence web spi library");
            }
        }
    
        if ($cohClusterFound eq "true")
        {
            $isCoherenceWeb = "true";
            my $oldCohClusterName = $domainName."_Coherence";
            my $cohClusterName = $domainTarget."_Coherence";
            my $cohDisplayName = $cohClusterName;

            if (defined($cohCluster)) {
               $cohDisplayName = $cohCluster; 
            }

            my $domainTargetType = "weblogic_domain";

            my $tgt = createTarget('oracle_coherence', $cohClusterName, $cohClusterName,
                     {
                        'version' => $cohVersion,
                        'version_value' => $cohVersion,
                        'middlewareHome' => $middlewareHome,
                        #'domainTarget' => $domainTarget,
                        'assocType' => $assocType,
                        'assocTarget' => $domainTarget,
                        'assocTargetType' => $domainTargetType,
                        'coherenceHome' => $coherenceHome,   
                        'displayName' => $cohDisplayName,
                        'coherenceHost' => $hostName,
                        'OcmProxyOracleHome' => $coherenceHome,
                        'OLD_NAME' => $oldCohClusterName
                     });
            setTargetHost($tgt, $hostName);
            setTargetDisplayName($tgt, $cohDisplayName);
        }
    }
}



# If deployment is not Coherence*Web and if there is no domainlocation.properties file
# in mwhome/utils/ccr directory, check if this is an Exalogic deployment. If the deployment
# is Exalogic, then create a Coherence target with mwhome followed by Coherence suffix.
# Additionally, add an association between Coherence target and Exalogic Rack.

if (($isCoherenceWeb eq "false") || ($noDomainLocations eq "true"))
{
    my $exaRackId = getExalogicId();
    my $exaRackType = "exa_rack";
    my $cohClusterName = $middlewareHome."_Coherence";
    my $cohDisplayName = $cohClusterName;
    my $tgt; 
    if (defined($exaRackId))
    {
          my $exaTgtName = "/ExalogicCloud_$exaRackId/$exaRackId";
          $tgt = createTarget('oracle_coherence', $cohClusterName, $cohClusterName,
                {
                    'version' => $cohVersion,
                    'version_value' => $cohVersion,
                    'middlewareHome' => $middlewareHome,
                    'assocType' => $assocType,
                    'assocTarget' => $exaTgtName,
                    'assocTargetType' => $exaRackType,
                    'coherenceHome' => $coherenceHome,   
                    'displayName' => $cohDisplayName,
                    'coherenceHost' => $hostName,
                    'OcmProxyOracleHome' => $coherenceHome
                });
          EMD_PERL_DEBUG("COH: Creating coherence cluster for Exalogic non-Coherence*Web deployment. Cluster name is $cohClusterName");
    }
    else {
          $tgt = createTarget('oracle_coherence', $cohClusterName, $cohClusterName,
                {
                    'version' => $cohVersion,
                    'version_value' => $cohVersion,
                    'middlewareHome' => $middlewareHome,
                    'coherenceHome' => $coherenceHome,   
                    'displayName' => $cohDisplayName,
                    'coherenceHost' => $hostName,
                    'OcmProxyOracleHome' => $coherenceHome
                });
          EMD_PERL_DEBUG("COH: Creating coherence cluster for non-Exalogic, non-Coherence*Web deployment. Cluster name is $cohClusterName");
    }
    setTargetHost($tgt, $hostName);
    setTargetDisplayName($tgt, $cohDisplayName);
}

# Print out all discovered targets
for my $target (getTargets())
{
    my $type = getTargetType($target);
    my $name = getTargetName($target);
    if (!defined($type) || !defined($name))
    {
        EMD_PERL_DEBUG("COH: Target missing NAME or TYPE: name=$name, type=$type; skipping");
        next;
    }
    my $displayName = getTargetDisplayName($target);
    EMD_PERL_DEBUG("COH: Cluster Display Name is $displayName");

    my $host = getTargetHost($target);
    print('  <Target TYPE="'. $type . '" NAME="' . $name . '"' .
          (defined($displayName) ? ' DISPLAY_NAME="' . $displayName . '"' : '') .
          (defined($host) ? ' ON_HOST="' . $host . '"' : '') .
          '>' . "\n");
    my $props = getTargetProperties($target);
    if (defined($props))
    {
        for my $prop (keys %{$props})
        {
            my $val = $$props{$prop};
            if (defined($val))
            {
                print('    <Property NAME="' . $prop. '" VALUE="' . $val . '"/>' . "\n");
            }
        }
    }
    # Add OCM_CROSS_HOST property to indicate that this Coherence target discovered from multiple
    # hosts is one and the same.
    print('     <Property NAME="OCM_CROSS_HOST" VALUE="TRUE"/>' . "\n");
    print('     <Property NAME="MULTIPLEXED" VALUE="TRUE"/>' . "\n");
    # OLD_ORACLE_HOME property is added to handle out-of-place upgrade
    if (defined($oldCoherenceHome)) {
       print('     <Property NAME="OLD_ORACLE_HOME" VALUE="' . $oldCoherenceHome . '"/>' . "\n");
    }
    print('  </Target>' . "\n");
}
