#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/exalogic_system_discover.pl /main/4 2012/01/07 07:31:24 sasachde Exp $
#
# exalogic_system_discover.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      exalogic_system_discover.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    sasachde    01/05/12 - Fixing the target property of exa_rack
#    sasachde    12/27/11 - Fix for bug#13104860
#    sasachde    12/18/11 - Fix for bug#13514100
#    sasachde    09/08/11 - Creation
#

use strict;
use mwm::exalogicUtil;

my ( $emdRoot, $hostName ) = @ARGV;

my $exlID = getExalogicId();
my $version = getExalogicVersion();

if ($exlID ne "")
{
print <<__END;
  <Target TYPE="exa_rack" NAME="/ExalogicCloud_$exlID/$exlID" UNIQUE_ID="$exlID" ON_HOST="$hostName">
  <Property NAME="RackId" VALUE="$exlID"/>
  <Property NAME="version_value" VALUE="$version"/>
  <Property NAME="OcmProxyOracleHome" VALUE="/opt/exalogic"/>
  <Property NAME="OCM_CROSS_HOST" VALUE="TRUE"/>
  </Target>
__END

print <<__END;
  <Target TYPE="exalogic_system" NAME="/ExalogicCloud_$exlID" UNIQUE_ID="$exlID">
  <Property NAME="ExalogicId" VALUE="$exlID"/>
  <Property NAME="version_value" VALUE="$version"/>
  <Property NAME="OCM_CROSS_HOST" VALUE="TRUE"/>
  </Target>
__END
}
