#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/fmw/idm.pl /main/1 2010/09/27 23:45:55 proxy Exp $
#
# idm.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      idm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       09/01/10 - integrating IDM discovery to FMW discovery
#    proxy       09/01/10 - Creation
# 
use strict;
use fmw::Targets;
use LL_OH_Utilities;

#This script takes care of removing duplicate targets between IDM discovery and FMW discovery.
#In case of IDM environment, there are two custom applications - DIP and OIF which gets discovered as custom targets as well as j2ee applications.
#This script handles removal of the j2ee application targets.

my ($emdRoot,$hostName) = @ARGV;

#J2EE Application Target
my $j2eeAppTargetType = 'j2ee_application';

#Get all targets of type j2ee_application discovered by FMW discovery.
my @j2eeApps = getTargets($j2eeAppTargetType);
my $app;
my $dipEx = "DIP#11";
my $oifEx = "OIF#11";

foreach $app (@j2eeApps) 
{
	#If the appName property for the target matches the pattern for DIP or OIF, then remove the target.
	my $property = getTargetProperty($app,'appName');
	if(defined($property) && ($property =~ m/^$dipEx.*$/ || $property =~ m/^$oifEx.*$/))
	{
		my $tgtName = $app->{'NAME'};
		removeTarget($j2eeAppTargetType, $tgtName);
	}
}
