#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/fmw/oracle_fusion_apps.pl /main/13 2012/09/24 13:09:47 vidykris Exp $
#
# oracle_fusion_apps.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_fusion_apps.pl - Generate XML stream describing fusion application targets
#
#    DESCRIPTION
#      Uses the targets.xml stream from FMW discovery results, adds the fusion 
#      application specific targets, customizes FMW targets as desired  
#      and returns the resulting XML stream.
#
#    NOTES
#      This is a plugin script which will be invoked by FMW discovery 
#
#    MODIFIED   (MM/DD/YY)
#    vidykris    09/17/12 - Bug 14153513
#    chunkch     11/23/11 - update
#    vidykris    03/29/11 - Add Support for FSCM
#    vidykris    01/13/11 - Accomodate FS file location change
#    vidykris    09/24/10 - XbranchMerge vidykris_bug-10059916 from
#                           st_emll_10.3.4
#    vidykris    08/27/10 - XbranchMerge vidykris_fa_ocm_072810_dm from
#                           st_emll_10.3.4
#    vidykris    08/24/10 - Discover ATF and COM PFs
#    vidykris    08/04/10 - Defining the list of valid target types to be discovered
#    vidykris    07/30/10 - Specify the proxy OracleHome for the FA targets
#    vidykris    03/24/10 - Creation
# 

use strict;
use File::Spec;
use fmw::Targets;
use ias::simpleXPath;
use LL_OH_Utilities;

# Establish the list of valid target types
my $validTargetTypes = {                                
                        'fusion_apps_pf_atf'                  => 'VALID',
                        'fusion_apps_product_atf_atk'         => 'VALID',
                        
                        'fusion_apps_pf_common'               => 'VALID',
                        'fusion_apps_product_common_fnd'      => 'VALID',
                        
                        'fusion_apps_pf_crm'                  => 'VALID',
                        'fusion_apps_product_crm_ewm'         => 'VALID',
                        'fusion_apps_product_crm_emk'         => 'VALID',
			'fusion_apps_product_crm_fod'	      => 'VALID',
                        'fusion_apps_product_crm_hz'          => 'VALID',
                        'fusion_apps_product_crm_mkl'         => 'VALID',
                        'fusion_apps_product_crm_mks'         => 'VALID',
                        'fusion_apps_product_crm_mkt'         => 'VALID',
                        'fusion_apps_product_crm_moo'         => 'VALID',
                        'fusion_apps_product_crm_mop'         => 'VALID',
                        'fusion_apps_product_crm_mot'         => 'VALID',
                        'fusion_apps_product_crm_mow'         => 'VALID',
                        'fusion_apps_product_crm_okc'         => 'VALID',
                        'fusion_apps_product_crm_qsc'         => 'VALID',
			'fusion_apps_product_crm_vfc'	      => 'VALID',
                        'fusion_apps_product_crm_zbs'         => 'VALID',
                        'fusion_apps_product_crm_zca'         => 'VALID',
                        'fusion_apps_product_crm_zcc'         => 'VALID',
                        'fusion_apps_product_crm_zch'         => 'VALID',
                        'fusion_apps_product_crm_zcm'         => 'VALID',
                        'fusion_apps_product_crm_zcp'         => 'VALID',
                        'fusion_apps_product_crm_zcq'         => 'VALID',
                        'fusion_apps_product_crm_zcx'         => 'VALID',
                        'fusion_apps_product_crm_zmc'         => 'VALID',
                        'fusion_apps_product_crm_zmm'         => 'VALID',
                        'fusion_apps_product_crm_zms'         => 'VALID',
                        'fusion_apps_product_crm_zoc'         => 'VALID',
                        'fusion_apps_product_crm_zoe'         => 'VALID',
                        'fusion_apps_product_crm_zsf'         => 'VALID',
			'fusion_apps_product_crm_zso'         => 'VALID',
                        'fusion_apps_product_crm_zsp'         => 'VALID',
                        
                        'fusion_apps_pf_financials'           => 'VALID',
                        'fusion_apps_product_financials_ap'   => 'VALID',
                        'fusion_apps_product_financials_ar'   => 'VALID',
                        'fusion_apps_product_financials_ce'   => 'VALID',
                        'fusion_apps_product_financials_exm'  => 'VALID',
                        'fusion_apps_product_financials_fa'   => 'VALID',
                        'fusion_apps_product_financials_fun'  => 'VALID',
                        'fusion_apps_product_financials_gl'   => 'VALID',
                        'fusion_apps_product_financials_iby'  => 'VALID',
                        'fusion_apps_product_financials_iex'  => 'VALID',
                        'fusion_apps_product_financials_je'   => 'VALID',
                        'fusion_apps_product_financials_xcc'  => 'VALID',
                        'fusion_apps_product_financials_xla'  => 'VALID',
                        'fusion_apps_product_financials_xle'  => 'VALID',
                        'fusion_apps_product_financials_xlh'  => 'VALID',
                        'fusion_apps_product_financials_zx'   => 'VALID',
                        
                        'fusion_apps_pf_fscm'                  => 'VALID',
                        'fusion_apps_product_fscm_ach'         => 'VALID',
                        'fusion_apps_product_fscm_acl'         => 'VALID',
                        'fusion_apps_product_fscm_acj'         => 'VALID',
                        
                        'fusion_apps_pf_grc'                  => 'VALID',
                        'fusion_apps_product_grc_grc'         => 'VALID',
                        
                        'fusion_apps_pf_hcm'                  => 'VALID',
                        'fusion_apps_product_hcm_anc'         => 'VALID',
			'fusion_apps_product_hcm_ben'         => 'VALID',
                        'fusion_apps_product_hcm_cmp'         => 'VALID',
                        'fusion_apps_product_hcm_cms'         => 'VALID',
                        'fusion_apps_product_hcm_ff'          => 'VALID',
			'fusion_apps_product_hcm_hbm'         => 'VALID',
                        'fusion_apps_product_hcm_hlr'         => 'VALID',
                        'fusion_apps_product_hcm_hmo'         => 'VALID',
                        'fusion_apps_product_hcm_hra'         => 'VALID',
                        'fusion_apps_product_hcm_hrc'         => 'VALID',
                        'fusion_apps_product_hcm_hrg'         => 'VALID',
                        'fusion_apps_product_hcm_hrl'         => 'VALID',
			'fusion_apps_product_hcm_hrr'         => 'VALID',
                        'fusion_apps_product_hcm_hrs'         => 'VALID',
                        'fusion_apps_product_hcm_hrt'         => 'VALID',
                        'fusion_apps_product_hcm_hrw'         => 'VALID',
                        'fusion_apps_product_hcm_hrx'         => 'VALID',
                        'fusion_apps_product_hcm_hwa'         => 'VALID',
                        'fusion_apps_product_hcm_hwp'         => 'VALID',
                        'fusion_apps_product_hcm_pay'         => 'VALID',
                        'fusion_apps_product_hcm_per'         => 'VALID',
                        'fusion_apps_product_hcm_pyt'         => 'VALID',
                        'fusion_apps_product_hcm_wlm'         => 'VALID',                        
                        
                        'fusion_apps_pf_ic'                   => 'VALID',
                        'fusion_apps_product_ic_cn'           => 'VALID',
                        
                        'fusion_apps_pf_procurement'          => 'VALID',
                        'fusion_apps_product_procurement_po'  => 'VALID',
                        'fusion_apps_product_procurement_pon' => 'VALID',
                        'fusion_apps_product_procurement_por' => 'VALID',
                        'fusion_apps_product_procurement_pos' => 'VALID',
                        'fusion_apps_product_procurement_poz' => 'VALID',
                        
                        'fusion_apps_pf_projects'             => 'VALID',
                        'fusion_apps_product_projects_pjb'    => 'VALID',
                        'fusion_apps_product_projects_pjc'    => 'VALID',
                        'fusion_apps_product_projects_pjf'    => 'VALID',
                        'fusion_apps_product_projects_pjo'    => 'VALID',
                        'fusion_apps_product_projects_pjs'    => 'VALID',
                        
                        'fusion_apps_pf_scm'                  => 'VALID',
                        'fusion_apps_product_scm_cmr'         => 'VALID',
                        'fusion_apps_product_scm_cse'         => 'VALID',
                        'fusion_apps_product_scm_csi'         => 'VALID',
                        'fusion_apps_product_scm_cst'         => 'VALID',
                        'fusion_apps_product_scm_doo'         => 'VALID',
                        'fusion_apps_product_scm_egi'         => 'VALID',
                        'fusion_apps_product_scm_ego'         => 'VALID',
                        'fusion_apps_product_scm_egp'         => 'VALID',
                        'fusion_apps_product_scm_gbl'         => 'VALID',
                        'fusion_apps_product_scm_inv'         => 'VALID',
                        'fusion_apps_product_scm_jmf'         => 'VALID',
                        'fusion_apps_product_scm_msc'         => 'VALID',
                        'fusion_apps_product_scm_msp'         => 'VALID',
                        'fusion_apps_product_scm_qp'          => 'VALID',
                        'fusion_apps_product_scm_rcv'         => 'VALID',
                        'fusion_apps_product_scm_wsh'         => 'VALID',
                        
                        'fusion_apps_pf_setup'                => 'VALID',
                        'fusion_apps_product_setup_ask'       => 'VALID',
                        'fusion_apps_product_setup_asm'       => 'VALID',
                        'fusion_apps_product_setup_atm'       => 'VALID'
                       };

# Establish the WebLogic target types
my $weblogicDomainTargetType = 'weblogic_domain';
my $weblogicClusterTargetType = 'weblogic_cluster';
my $weblogicServerTargetType = 'weblogic_j2eeserver';
my $clusterAppTargetType = 'j2ee_application_cluster';
my $j2eeAppTargetType = 'j2ee_application';

# Establish the FA target types
my $fusionClusterAppTargetType = 'fusion_apps_cluster_app';
my $fusionJ2eeAppTargetType = 'fusion_apps_j2ee_app';

# Establish the fusion instance target name and type
my $fusion_instance_target_name = 'FusionInstance';
my $fusion_instance_target_type = 'fusion_apps_instance';

# Establish the fusion PF target type extensions
my $pfTargetTypeExtensions = {                                
                                'ATF'   => 'atf',
                                'COM'   => 'common',
                                'CRM'   => 'crm',
                                'FIN'   => 'financials',
                                'GRC'   => 'grc',
                                'HCM'   => 'hcm',
                                'IC'    => 'ic',
                                'PRC'   => 'procurement',
                                'PRJ'   => 'projects',
                                'SCM'   => 'scm',
                                'FSCM'  => 'fscm',
                                'FS'    => 'setup'
                             };                               

my ($emdRoot,$hostName) = @ARGV;

my $middlewareHome = $ENV{'BEA_HOME'};
if (!defined($middlewareHome))
{
  EMD_PERL_DEBUG("No BEA_HOME defined, aborting fusion apps discovery");
  exit;
}

# Establish ApplTop
my $appl_top = get_appl_top($middlewareHome);
if(-e $appl_top)
{    
    # Get the common domain
    my $commonDomainTargetName = '/Farm_CommonDomain/CommonDomain';
    my $commonDomainTarget = getTarget($weblogicDomainTargetType,$commonDomainTargetName);
    my $commonDomainHome = getTargetProperty($commonDomainTarget, 'domainHome');
    
    # Get the FS home (../../../ocm)
    my ($volume, $directories, $file) = File::Spec->splitpath($commonDomainHome);
    my @dirs = File::Spec->splitdir($directories);
    pop @dirs;
    pop @dirs;
    pop @dirs;
    my $wl_app_config_home = File::Spec->catdir(@dirs);    
    my $fsFileHome = File::Spec->catdir($wl_app_config_home, 'ocm');    
    
    # Get the FA Functional Setup file
    my $appsFSFileName = File::Spec->catfile($fsFileHome, "fusionAppsFS.xml");
    if ((-e $appsFSFileName) && (-r $appsFSFileName))
    {
      # Parse the Functional Setup file to get all the deployed applications
      my $appsFSFile = ias::simpleXPath::parseFile($appsFSFileName);       
      
      # Get the J2EE applications provisioned
      my @fusion_j2ee_apps = ias::simpleXPath::queryForAttributes($appsFSFile, 'ocm-collection-info/deployed-application');
      my $instance_pfs;
      foreach my $fusion_j2ee_app (@fusion_j2ee_apps)
      {
        my $fusion_j2ee_app_name = $fusion_j2ee_app->{'short-name'};          
        
        # Get the right taxonomy file that has info for this FA product family
        my $atgpf_home = get_taxonomy_home($middlewareHome);
        my $pfTaxonomyFileName = get_taxonomy_file_name($atgpf_home, $fusion_j2ee_app_name);
        
        if (defined($pfTaxonomyFileName) && (-e $pfTaxonomyFileName) && (-r $pfTaxonomyFileName))
        {
            # Parse the Apps Taxonomy file to get all the deployed applications
            my $pfTaxonomyFile = ias::simpleXPath::parseFile($pfTaxonomyFileName);
 
            # For each fusion j2ee app provisioned, update the current target type and add the properties
            my @wl_j2ee_apps = getTargets($j2eeAppTargetType);           
            foreach my $wl_j2ee_app (@wl_j2ee_apps)
            {
              my $wl_j2ee_app_name = $wl_j2ee_app->{'NAME'};
              my $wl_j2ee_app_display_name = $wl_j2ee_app->{'DISPLAY_NAME'};
              
              # Extract the app name portion from the display name              
              my $extracted_wl_app_name;
              if(defined($wl_j2ee_app_display_name))
              {
                my @app_name_splits = split('\(',$wl_j2ee_app_display_name);
                $extracted_wl_app_name = $app_name_splits[0];
              }
              
              if (defined($extracted_wl_app_name) && ($extracted_wl_app_name eq $fusion_j2ee_app_name))
              {                
                # Match found. Find the domain that this app is on
                my $server_target_name = getTargetProperty($wl_j2ee_app, 'serverTarget');
                my $cluster_app_target_name = getTargetProperty($wl_j2ee_app, 'clusterAppTarget');
                
                my $server_target = getTarget($weblogicServerTargetType, $server_target_name);  
                my $domain_target_name = getTargetProperty($server_target, 'domainTarget');                        
                my $wl_home = getTargetProperty($server_target, 'OcmProxyOracleHome');
                                                
                # Find the Product Family of this app and add the product family
                my $pf_name;
                my $pf_display_name;
                my $pf_node = (ias::simpleXPath::queryForAttributes($pfTaxonomyFile, 'ProductFamily'))[0];
                if(defined($pf_node))
                {
                  $pf_name = $pf_node->{'Name'};
                  $pf_display_name = $pf_node->{'DisplayName'};
                }
                
                # Check to see if the product family is in the current list of targets
                my $pf_target_name = $domain_target_name . "/" . $pf_display_name;                
                my $pf_target_type = 'fusion_apps_pf_' . $pfTargetTypeExtensions->{$pf_name};
                
                my $domainVersion = getTargetProperty($server_target, 'version');
                my $domainHome = getTargetProperty($server_target, 'domainHome');
                my $adminServerHost = getTargetProperty($server_target, 'adminServerHost');  
                my $oracle_home = get_oracle_home($pf_name, $pf_target_type, $appl_top);
                my $pf_version = get_apps_version($appl_top, $oracle_home, $pf_name); 
                
                # Make sure that the Product Family Target Type is defined and is valid
                if(defined($pf_target_type) && (defined($validTargetTypes->{$pf_target_type})) && (defined($pf_version)))
                {
                  if(!defined(getTarget($pf_target_type, $pf_target_name)))
                  {          
                      # Product family is not in the list. Get the properties for product family 
                      my $pf_target = createTarget($pf_target_type, $pf_target_name, $pf_display_name,
                                 {
                                     'version' => $domainVersion,
                                     'domainHome' => $domainHome,
                                     'fsFileHome' => $fsFileHome,
                                     'adminServerHost' => $hostName,
                                     'applTop' => $appl_top,
                                     'version_value' => $pf_version,
                                     'fusionInstanceTarget' => $fusion_instance_target_name,
                                     'name' => $pf_name,
                                     'displayName' => $pf_display_name,
                                     'domainTargetName' => $domain_target_name,
                                     'wlOracleHome' => $wl_home,
                                     'OcmProxyOracleHome' => $oracle_home
                                 });                     
                      setTargetHost($pf_target, $hostName);
                                 
                      $instance_pfs = $instance_pfs . $pf_target_name . '|' . $pf_target_type . '|' . $hostName . '|';
                  }
                  
                  # Get a list of products that use this application from the taxonomy file
                  my @fusion_products = ias::simpleXPath::queryForNodes($pfTaxonomyFile, 'ProductFamily/ListOfProducts/Product/ProvidedByApplications/Application[@name="' . $fusion_j2ee_app_name . '"]ancestor::Product');
    
                  # Iterate through each product and add it to the list of targets
                  if(defined(@fusion_products))
                  {
                    foreach my $fusion_product (@fusion_products)
                    {
                      my $product_name;
                      my $product_display_name;
                      my $product_node = (ias::simpleXPath::queryForAttributes($fusion_product, 'Product'))[0];
                      if(defined($product_node))
                      {
                        $product_name = $product_node->{'Name'};
                        $product_display_name = $product_node->{'DisplayName'};
                      } 
                      
                      # Check to see if the product target is in the current list of products
                      my $product_target_name = $domain_target_name . "/" . $pf_display_name . "/" . $product_display_name;
                      my $product_target_type = 'fusion_apps_product_' . $pfTargetTypeExtensions->{$pf_name} . '_' . lc($product_name); 
                      my $product_oracle_home = get_oracle_home($product_name, $product_target_type, $appl_top);
                      if($product_oracle_home ne $appl_top)
                      {
                        $oracle_home = $product_oracle_home;
                      }
                      
                      # Make sure that the product doesnt exist and is a valid target type
                      if((!defined(getTarget($product_target_type, $product_target_name))) && (defined($validTargetTypes->{$product_target_type})))
                      {
                        my $product_target = createTarget($product_target_type, $product_target_name, $product_display_name,
                                   {
                                       'version' => $domainVersion,
                                       'domainHome' => $domainHome,
                                       'fsFileHome' => $fsFileHome,
                                       'adminServerHost' => $hostName,
                                       'applTop' => $appl_top,
                                       'version_value' => $pf_version,
                                       'productFamilyTarget' => $pf_target_name,
                                       'productFamilyType' => $pf_target_type,
                                       'productFamilyName' => $pf_name,
                                       'productName' => $product_name,
                                       'displayName' => $product_display_name,
                                       'OcmProxyOracleHome' => $oracle_home
                                   });                       
                        setTargetHost($product_target, $hostName);
                      }  
                    }
                    
                    # Check to see if the fusion cluster app target is in the current list of targets        
                    my $cluster_app_target = getTarget($clusterAppTargetType, $cluster_app_target_name);      
                    if(defined($cluster_app_target))
                    {
                      setTargetType($cluster_app_target, $fusionClusterAppTargetType);                
                      setTargetProperty($cluster_app_target, 'applTop', $appl_top);    
                      setTargetProperty($cluster_app_target, 'version_value', $pf_version);
                      setTargetProperty($cluster_app_target, 'productFamilyTarget', $pf_target_name);
                      setTargetProperty($cluster_app_target, 'productFamilyType', $pf_target_type);
                      setTargetProperty($cluster_app_target, 'displayName', $wl_j2ee_app_display_name);
                      setTargetProperty($cluster_app_target, 'OcmProxyOracleHome', $appl_top);
                      setTargetHost($cluster_app_target, $hostName);
                    } 
                    
                    # Check to see if the fusion j2ee app target is in the current list of targets 
                    my $j2ee_app_target = getTarget($j2eeAppTargetType, $wl_j2ee_app_name);  
                    if(defined($j2ee_app_target))
                    {
                      setTargetType($j2ee_app_target, $fusionJ2eeAppTargetType);                
                      setTargetProperty($j2ee_app_target, 'applTop', $appl_top);    
                      setTargetProperty($j2ee_app_target, 'version_value', $pf_version);
                      setTargetProperty($j2ee_app_target, 'clusterAppTarget', $cluster_app_target_name);
                      setTargetProperty($j2ee_app_target, 'displayName', $wl_j2ee_app_display_name);
                      setTargetProperty($j2ee_app_target, 'OcmProxyOracleHome', $appl_top);
                      setTargetHost($j2ee_app_target, $hostName);
                    } 
                  } #if(defined($pf_target_type) && (defined($validTargetTypes->{$pf_target_type})))
                } #if(defined(@fusion_products))          
              } #if (defined($extracted_wl_app_name) && ($extracted_wl_app_name eq $fusion_j2ee_app_name))
            } #foreach my $wl_j2ee_app (@wl_j2ee_apps)
          } #if ((-e $pfTaxonomyFileName) && (-r $pfTaxonomyFileName))
      } #foreach my $fusion_j2ee_app (@fusion_j2ee_apps)
      
      # Create the Fusion Instance target        
      my $fusion_instance_version = get_instance_version($appl_top);
      my $fusion_instance_target = createTarget($fusion_instance_target_type, $fusion_instance_target_name, $fusion_instance_target_name,
                 {
                     'version_value' => $fusion_instance_version,
                     'applTop' => $appl_top,
                     'ocmHost' => $hostName,
                     'productFamilyTargets' => $instance_pfs,
                     'displayName' => $fusion_instance_target_name,
                     'OcmProxyOracleHome' => $appl_top
                 }); 
      setTargetHost($fusion_instance_target, $hostName);           
    } #if ((-e $appsFSFileName) && (-r $appsFSFileName))
}#if (-e $applTop)

# subroutine get_taxonomy_home
# Construct the location of the ATGPF home directory
# $_[0] - value of ATGPF home
sub get_taxonomy_home
{
  my ($fmw_home) = @_;

  if (!defined($fmw_home))
  {
    return $fmw_home;
  }
  
  # Check to see if APPLTOP is the delivery engine for FA taxonomy files
  my $taxonomy_home = File::Spec->catdir($fmw_home, 'applications', 'com', 'acr', 'taxonomyReferenceData');
  my $crm_taxonomy_file_name = File::Spec->catfile($taxonomy_home, "CRM_TaxonomyData.xml");
  if (!((-e $crm_taxonomy_file_name) && (-r $crm_taxonomy_file_name)))
  {
    # Now get the taxonomy files from ATGPF
    $taxonomy_home = File::Spec->catdir($fmw_home, 'atgpf', 'atgpf', 'applcore', 'db', 'data', 'fa_taxonomy');
  }
  
  return $taxonomy_home;
}

# subroutine get_appl_top
# Construct the location of the ApplTop directory
# $_[0] - value of ApplTop
sub get_appl_top
{
  my ($fmw_home) = @_;

  if (!defined($fmw_home))
  {
    return $fmw_home;
  }
  
  my $appl_top = File::Spec->catdir($fmw_home, 'applications');
  return $appl_top;
}

# subroutine get_taxonomy_file_name
# Get the product family specific taxonomy file name
# $_[0] - Taxonomy File Name for the given product family
sub get_taxonomy_file_name
{  
  my ($taxonomy_dir) = $_[0];
  my ($fusion_j2ee_app_name) = $_[1];
  my $taxonomyFileName; 
  
  if(defined($taxonomy_dir) && (-e $taxonomy_dir))
  {
    # Get a list of all taxonomy files in the Taxonomy Directory 
    my @appsTaxonomyFileNames = <$taxonomy_dir/*TaxonomyData.xml>;
    
    #Iteratively parse the files to see if there's a match
    foreach my $appsTaxonomyFileName (@appsTaxonomyFileNames)
    {
      if(-r $appsTaxonomyFileName)
      {
          # Parse the file to see if we have a matching name
          my $appsTaxonomyFile = ias::simpleXPath::parseFile($appsTaxonomyFileName);  
          my @applications = ias::simpleXPath::queryForAttributes($appsTaxonomyFile, 'ProductFamily/ListOfApplications/Application[@name="' . $fusion_j2ee_app_name . '"]');
          
          if(scalar(@applications) > 0)
          {
            # The right taxonomy file found. Return the file
            $taxonomyFileName = $appsTaxonomyFileName;
          }
      }
    }
  }
  return $taxonomyFileName;
}

# subroutine get_instance_version
# The version of the fa install
# $_[0] - value of version
sub get_instance_version
{
  my ($appl_top) = $_[0];
  my $instance_version = LL_OH_Utilities::getCompVersion($appl_top, "oracle.fusionapps.top");   
  return $instance_version;  
}

# subroutine get_apps_version
# The version of the fa product family
# $_[0] - value of version
sub get_apps_version
{
  my ($appl_top) = $_[0];
  my ($oracle_home) = $_[1];
  my ($pf_name) = $_[2];
  my $apps_version;
  
  if (defined($appl_top))
  {
    my $mapping_name = get_oui_component_name($appl_top, $pf_name);     
    if(defined($mapping_name))
    {    
      $apps_version = LL_OH_Utilities::getCompVersion($oracle_home, $mapping_name);  
    }
  }    
  return $apps_version;  
}

# subroutine get_oui_component_name
# The oui component name of the fa product family
# $_[0] - oui component name
sub get_oui_component_name
{
  my ($appl_top) = $_[0];
  my ($pf_name) = $_[1];
  my $oui_component_name; 

  if ((defined($appl_top)) && (defined($pf_name)))
  {
    my $pf_oui_mapping_file_name = File::Spec->catfile($appl_top, "pfOUImapping.xml");
    if ((-e $pf_oui_mapping_file_name) && (-r $pf_oui_mapping_file_name))
    {
      my $pf_oui_mapping_file = ias::simpleXPath::parseFile($pf_oui_mapping_file_name); 
      my $pf_oui_mapping = (ias::simpleXPath::queryForAttributes($pf_oui_mapping_file, 'ProductFamilyOUIMappings/Mapping[@TYPE="product_family"][@NAME="' . $pf_name . '"]/Property[@NAME="ouicomponent"]'))[0];
      if(defined($pf_oui_mapping))
      {
        $oui_component_name = $pf_oui_mapping->{'VALUE'};
      }
    }
  }              
  return $oui_component_name;
}

# subroutine get_oracle_home
sub get_oracle_home
{
    my $oracle_home;
    my $targetName = @_[0];
    my $targetType = @_[1];
    my $applTop = @_[2];

    my $pfOUIMappingFilePath = "$applTop/pfOUImapping.xml";
    if (!(-e $pfOUIMappingFilePath) || !(-r $pfOUIMappingFilePath))
    {
        # Value remains undefined
        return $oracle_home;
    }

    # Assign default value
    $oracle_home = $applTop;

    my $pfOUIMappingFile = ias::simpleXPath::parseFile($pfOUIMappingFilePath);

    my @properties;
    if ($targetType =~ "fusion_apps_pf")
    {
        @properties = ias::simpleXPath::queryForNodes($pfOUIMappingFile, 'ProductFamilyOUIMappings/Mapping[@TYPE="product_family"][@NAME="' . $targetName . '"]/Property[@NAME="oracle_home"]');
    }

    if ($targetType =~ "fusion_apps_product")
    {
        @properties = ias::simpleXPath::queryForNodes($pfOUIMappingFile, 'ProductFamilyOUIMappings/Mapping/Mapping[@TYPE="product"][@NAME="' . $targetName . '"]/Property[@NAME="oracle_home"]');
    }

    if (defined(@properties)) {
        foreach my $property (@properties) {
            my $oracle_home = ((ias::simpleXPath::queryForAttributes($property, 'Property'))[0])->{'VALUE'};
            if (defined($oracle_home))
            {
                my @directories = File::Spec->splitdir($applTop);
                pop @directories;
                $oracle_home = File::Spec->catdir(File::Spec->catdir(@directories), $oracle_home);
                return $oracle_home;
            }
        }
    }

    return $oracle_home;
}
