#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/fmw_discover.pl /st_emll_10.3.8/1 2013/01/16 21:19:44 navnkaur Exp $
#
# fmw_discover.pl
# 
# Copyright (c) 2010, 2013, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      fmw_discover.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    navnkaur    01/15/13 - XbranchMerge navnkaur_bug-14613905 from main
#    navnkaur    01/03/13 - Bug 14613905
#    navnkaur    09/04/12 - Getting the weblogic version from oui api or from
#                           weblogic.jar
#    navnkaur    08/16/12 - NG Oracle Home Changes
#    vidykris    02/21/11 - Accomodate FA FS file location change for
#                           visitAllDomains
#    jsmoler     08/19/10 - graceful exit if WL_HOME is not defined
#    jsmoler     08/18/10 - disable domain host check for Fusion Apps installs
#    jsmoler     08/11/10 - use proxy oracle home
#    jsmoler     07/26/10 - ON_HOST target attribute
#    jsmoler     06/16/10 - add generic target version properties
#    jsmoler     04/20/10 - Creation (code moved from oracle_ias2.pl)
# 


use strict;
use ias::propertiesFileParser;
use ias::simpleXPath;
use fmw::Targets;
use fmw::fmwUtil;
use emdcommon;

my ( $emdRoot, $hostName ) = @ARGV;

my $middlewareHome;
my $oracleHome;
my $domainsFileName;
my $domainVersion = "";
 #Check if NG install
my $checkIsNG = fmw::fmwUtil::isNGInstall();
    

my $javaHome ;
if ( defined($ENV{JAVA_HOME}) )
{
    $javaHome = $ENV{JAVA_HOME};
}
else
{
    $javaHome = $ENV{CCR_JAVA_HOME};
}

emdcommon::EMD_PERL_DEBUG("JAVA_HOME= ".$javaHome);
my $javaCmd =File::Spec->catdir($javaHome,'bin','java');

if($checkIsNG eq "Y")
{
   emdcommon::EMD_PERL_DEBUG("It is NG Install");
   $oracleHome = fmw::fmwUtil::getNGOracleHome();
   my $domainsFilePath = fmw::fmwUtil::getWLDomainLocFilePath();
   $domainsFileName = File::Spec->catdir($domainsFilePath, 'domainlocation.properties');
   $middlewareHome = $oracleHome;
   #get the weblogic version
   my $ccrLibPath = File::Spec->catdir($emdRoot, 'sysman', 'admin', 'lib', 'ticollection.jar');
   my $ouiLibPath = File::Spec->catdir($oracleHome, 'oui','modules','*');
   my $cpSep = (($^O eq "Windows_NT") || ($^O  eq "MSWin32")) ? ';' : ':';
   my $classPath = $ccrLibPath.$cpSep.$ouiLibPath;
   my $className = "oracle.sysman.ccr.ti.weblogic.WeblogicVersion";
   my $args = $oracleHome;
   my $wlsVersionCommand =$javaCmd." -classpath ". $classPath." ".$className." ".$args;
   emdcommon::EMD_PERL_DEBUG("Command : ".$wlsVersionCommand);
   my $wlsVersionResult = ` $wlsVersionCommand `;
   emdcommon::EMD_PERL_DEBUG("wls version : ".$wlsVersionResult);
   if($wlsVersionResult ne "") 
   {
     $domainVersion = $wlsVersionResult; 
   }
}
else
{
  $middlewareHome = $ENV{'BEA_HOME'};
  if (!defined($middlewareHome))
  {
     emdcommon::EMD_PERL_DEBUG("No BEA_HOME defined, aborting middleware discovery");
     exit;
  }
  my $wlHome = $ENV{'WL_HOME'};
  $oracleHome = $wlHome;
  if (!defined($oracleHome))
  {
     emdcommon::EMD_PERL_WARN("No WL_HOME defined, aborting middleware discovery");
     exit;
  }
  $domainsFileName = File::Spec->catdir($middlewareHome, 'utils', 'ccr' ,'domainlocation.properties');
  #Get the weblogic version
  my $wlJarPath = File::Spec->catdir($wlHome, 'server', 'lib', 'weblogic.jar'); 
  my $className = "weblogic.version";
  my $wlsVersionCommand = $javaCmd." -classpath ". $wlJarPath." ".$className ;
  emdcommon::EMD_PERL_DEBUG("Command = ".$wlsVersionCommand);
  my $wlsVersionResult =` $wlsVersionCommand `;# Result format =  WebLogic Server 12.1.2.0.0  Tue Jul 3 ..
  emdcommon::EMD_PERL_DEBUG("result ". $wlsVersionResult);
  if($wlsVersionResult ne "")
  {
    my $delimiterStr = " ";
    for(my $i=0 ; $i<2; $i++)
    {
       my $startIndex = index($wlsVersionResult, $delimiterStr);
       $wlsVersionResult = substr($wlsVersionResult, $startIndex +1);
    } 
    my $endIndex = index($wlsVersionResult, $delimiterStr);
    $domainVersion = substr($wlsVersionResult, 0, $endIndex );
    emdcommon::EMD_PERL_DEBUG("DomainVersion ".$domainVersion);
  }
}

emdcommon::EMD_PERL_DEBUG("Domains file : ".$domainsFileName);
# Make sure the domain locations file exists
if (!-e $domainsFileName)
{
    emdcommon::EMD_PERL_DEBUG("No domainlocation.properties file found, aborting middleware discovery");
    exit;
}

# Special case for Fusion Apps discovery: Fusion Apps installs span multiple hosts and
# domains. However, only one OCM collector is used for the entire install. Therefore
# the one collector needs to visit all domains in the domainlocation.properties file,
# regardless of what host each domain is on. Normally a collection is done from every
# host that has an admin server installed.
my $visitAllDomains = 0;
my $fa_taxonomy_dir = File::Spec->catdir($middlewareHome, 'atgpf', 'atgpf', 'applcore', 'db', 'data', 'fa_taxonomy');
if ( -e $fa_taxonomy_dir)
{   
    $visitAllDomains = 1;
}

# Parse the domain locations file to find all domain homes on this host
my %domainLocations = parsePropertiesFile($domainsFileName);
my @domainHomes;
for my $domainHost (keys %domainLocations)
{
    my $lcDomainHost = lc($domainHost);
    if ($visitAllDomains || lc($hostName) eq $lcDomainHost || lc($hostName) =~ /^$lcDomainHost\..+/)
    {
        push(@domainHomes, split(',', $domainLocations{$domainHost}));
    }
}

# Visit each unique domain and discover its targets
for my $domainHome (@domainHomes)
{
    # Make sure the domain config file exists
    my $configFileName = "$domainHome/config/config.xml";
    if (!-e $configFileName)
    {
        emdcommon::EMD_PERL_DEBUG("No config.xml in domain home: $domainHome; skipping");
        next;
    }
    
    my $configFile = ias::simpleXPath::parseFile($configFileName);
    my $domainName = (ias::simpleXPath::queryForText($configFile,
        'domain/name'))[0];
    if($domainVersion eq "")	
    {
      emdcommon::EMD_PERL_DEBUG("Picking up the version from the config file");
      $domainVersion = (ias::simpleXPath::queryForText($configFile,
          'domain/domain-version'))[0];
    }
    my $adminServer = (ias::simpleXPath::queryForText($configFile,
        'domain/admin-server-name'))[0];

    # Determine if the domain is part of an IAS install by looking
    # for the JRF template
    my $isIas = 0;
    if (-e "$domainHome/init-info/domain-info.xml")
    {
        my $domainInfoFile = ias::simpleXPath::parseFile(
            "$domainHome/init-info/domain-info.xml");
        my $jrf = (ias::simpleXPath::queryForAttributes($domainInfoFile,
            'domain-info/domain-template-info/identification[@name="Oracle JRF Extension"]'))[0];
        if (!defined($jrf))
        {
            $jrf = (ias::simpleXPath::queryForAttributes($domainInfoFile,
                'domain-info/extention-template-ref[@name="Oracle JRF"]'))[0];
        }
        $isIas = defined($jrf);
    }

    if ($isIas)
    {
        # Farm target
        my $tgt = createTarget('oracle_ias_farm', "Farm_$domainName", "Farm_$domainName",
                     {
                         'version' => $domainVersion,
                         'version_value' => $domainVersion, # for generic target version metric
                         'domainHome' => $domainHome,
                         'domainTarget' => "/Farm_$domainName/$domainName",
                         'adminServerHost' => $hostName,
                         'OcmProxyOracleHome' => $oracleHome
                     });
        setTargetHost($tgt, $hostName);
    }
    
    # Domain target
    my $domainTarget = $isIas ? "/Farm_$domainName/$domainName" : "/$domainName";
    my $tgt = createTarget('weblogic_domain', $domainTarget, $domainName,
                 {
                     'version' => $domainVersion,
                     'version_value' => $domainVersion, # for generic target version metric
                     'domainHome' => $domainHome,
                     'adminServerTarget' => "$domainTarget/$adminServer",
                     'adminServerHost' => $hostName,
                     'OcmProxyOracleHome' => $oracleHome
                 });
    setTargetHost($tgt, $hostName);
    
    # Server targets
    my @servers = ias::simpleXPath::queryForText($configFile, 'domain/server/name');
    for my $server (@servers)
    {
        my $serverCluster = (ias::simpleXPath::queryForText($configFile, 'domain/server[name="' . $server . '"]/cluster'))[0];
        my $clusterTarget;
        if (defined($serverCluster))
        {
            $clusterTarget = "$domainTarget/$serverCluster";
        }
        my $tgt = createTarget('weblogic_j2eeserver', "$domainTarget/$server", $server,
                     {
                         'version' => $domainVersion,
                         'version_value' => $domainVersion, # for generic target version metric
                         'domainHome' => $domainHome,
                         'domainTarget' => $domainTarget,
                         'adminServer' => $adminServer,
                         'adminServerHost' => $hostName,
                         'clusterTarget' => $clusterTarget,
                         'OcmProxyOracleHome' => $oracleHome
                     });
        setTargetHost($tgt, $hostName);
    }
    
    # Cluster targets
    my @clusters = ias::simpleXPath::queryForText($configFile, 'domain/cluster/name');
    my %isClusterName = ();
    for my $cluster (@clusters)
    {
        $isClusterName{$cluster} = 1;
        my $tgt = createTarget('weblogic_cluster', "$domainTarget/$cluster", $cluster,
                     {
                         'version' => $domainVersion,
                         'version_value' => $domainVersion, # for generic target version metric
                         'domainHome' => $domainHome,
                         'domainTarget' => $domainTarget,
                         'adminServerHost' => $hostName,
                         'OcmProxyOracleHome' => $oracleHome
                     });
        setTargetHost($tgt, $hostName);
    }
                
    # Application targets
    my @apps = ias::simpleXPath::queryForNodes($configFile, 'domain/app-deployment');
    for my $app (@apps)
    {
        my $appName = (ias::simpleXPath::queryForText($app, 'app-deployment/name'))[0];
        
        # Check if the app is versioned by parsing its name
        my $displayName = $appName;
        my $appVersion;
        my $planVersion;
        if ($appName =~ /^(.+)#(.+)#(.+)$/)
        {
            $appVersion = $2;
            $planVersion = $3;
            $displayName = "$1($appVersion,$planVersion)";
        }
        elsif ($appName =~ /^(.+)#(.+)$/)
        {
            $appVersion = $2;
            $displayName = "$1($appVersion)";
        }
        
        # Figure out what servers or clusters the app is deployed to
        my $appTargetStr = (ias::simpleXPath::queryForText($app, 'app-deployment/target'))[0];
        my @appTargets = split(',', $appTargetStr);
        for my $appTarget (@appTargets)
        {
            # See if the target is a cluster
            if ($isClusterName{$appTarget})
            {
                my $clusterAppTarget = "$domainTarget/$appTarget/$displayName";
                # Create cluster app target
                my $tgt = createTarget('j2ee_application_cluster', $clusterAppTarget, $displayName,
                             {
                                 'version' => $domainVersion,
                                 'version_value' => $domainVersion, # for generic target version metric
                                 'domainHome' => $domainHome,
                                 'clusterTarget' => "$domainTarget/$appTarget",
                                 'adminServerHost' => $hostName,
                                 'appName' => $appName,
                                 'appVersion' => $appVersion,
                                 'planVersion' => $planVersion,
                                 'OcmProxyOracleHome' => $oracleHome
                             });
                setTargetHost($tgt, $hostName);

                my @serversForCluster = ias::simpleXPath::queryForText($configFile, 'domain/server[cluster="' . $appTarget . '"]/name');
                for my $appServer (@serversForCluster)
                {
                    # Create app deployment target associated with cluster app target
                    my $tgt = createTarget('j2ee_application', "$domainTarget/$appServer/$displayName", $displayName,
                                 {
                                     'version' => $domainVersion,
                                     'version_value' => $domainVersion, # for generic target version metric
                                     'domainHome' => $domainHome,
                                     'serverTarget' => "$domainTarget/$appServer",
                                     'clusterAppTarget' => $clusterAppTarget,
                                     'adminServerHost' => $hostName,
                                     'appName' => $appName,
                                     'appVersion' => $appVersion,
                                     'planVersion' => $planVersion,
                                     'OcmProxyOracleHome' => $oracleHome
                                 });
                    setTargetHost($tgt, $hostName);
                }
            }
            else
            {
                # Create app deployment target
                my $tgt = createTarget('j2ee_application', "$domainTarget/$appTarget/$displayName", $displayName,
                             {
                                 'version' => $domainVersion,
                                 'version_value' => $domainVersion, # for generic target version metric
                                 'domainHome' => $domainHome,
                                 'serverTarget' => "$domainTarget/$appTarget",
                                 'adminServerHost' => $hostName,
                                 'appName' => $appName,
                                 'appVersion' => $appVersion,
                                 'planVersion' => $planVersion,
                                 'OcmProxyOracleHome' => $oracleHome
                             });
                setTargetHost($tgt, $hostName);
            }
        }
    }
}

# Run integrator discovery scripts
my $intgPath = "$emdRoot/sysman/admin/discover/fmw/integration.lst";
if ( -e $intgPath)
{
    my $intgFile;
    open($intgFile, $intgPath);
    my $count = 0;
    for my $line (readline($intgFile))
    {
        if ($line !~ /^\#/ && $line =~ /^([^\|]+)\|([^\|]+)/)
        {
            my $catName = $1;
            my $scriptName = $2;
            if ($scriptName =~ /(\S+)/)
            {
                $scriptName = $1;
            }
            my $scriptPath = "$emdRoot/sysman/admin/discover/fmw/$scriptName";
            if ( -e $scriptPath)
            {
                my @backupArgv = @ARGV;
                eval("{ package fmwintg$count; do '$scriptPath'; }");
                @ARGV = @backupArgv;
                $count++;
            }
            else
            {
                emdcommon::EMD_PERL_DEBUG("Integration script not found: $scriptPath");
            }
        }
    }
    close($intgFile);
}
else
{
    emdcommon::EMD_PERL_DEBUG("No integration.lst file found");
}

# Print out all discovered targets
for my $target (getTargets())
{
    my $type = getTargetType($target);
    my $name = getTargetName($target);
    if (!defined($type) || !defined($name))
    {
        emdcommon::EMD_PERL_DEBUG("Target missing NAME or TYPE: name=$name, type=$type; skipping");
        next;
    }
    my $displayName = getTargetDisplayName($target);
    my $host = getTargetHost($target);
    print('  <Target TYPE="'. $type . '" NAME="' . $name . '"' .
          (defined($displayName) ? ' DISPLAY_NAME="' . $displayName . '"' : '') .
          (defined($host) ? ' ON_HOST="' . $host . '"' : '') .
          '>' . "\n");
    my $props = getTargetProperties($target);
    if (defined($props))
    {
        for my $prop (keys %{$props})
        {
            my $val = $$props{$prop};
            if (defined($val))
            {
                print('    <Property NAME="' . $prop. '" VALUE="' . $val . '"/>' . "\n");
            }
        }
    }
    print('  </Target>' . "\n");
}
