#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/host.pl /main/8 2011/08/23 00:53:59 imunusam Exp $
#
# host.pl
# 
# Copyright (c) 2002, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      host.pl - <one-line expansion of the name>
#    creates a host target with just name and type.
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    imunusam    08/19/11 - To change getDbMachineNameFromLL function to check
#                           both .ll and .ccr instead checking only .ll
#    imunusam    07/01/11 - To add cellhost as member of dbmachine
#    ckalivar    05/31/10 - ER 8239565: populate version_value property
#    jsutton     06/29/07 - Add OCM_CROSS_HOST property for cluster targets
#    dkapoor     10/11/05 - discover cluster if Cluster Manager is found in 
#                           the home 
#    xuliu       07/13/05 - CLUSTER_NAME
#    xuliu       05/11/05 - OMSENV_CLUSTER_NAME: bug 4346269 
#    hying       01/07/05 - use AssocTargetInstance 
#    xuliu       12/03/04 - csrhome warning 
#    xuliu       11/08/04 - use new getClusterName() 
#    xuliu       10/26/04 - CRSHome -> OracleHome 
#    xuliu       06/28/04 - CRSHome
#    xuliu       11/05/03 - use getClusterName() 
#    ysun        08/05/03 - add association
#    ysun        01/29/03 - support cluster discovery
#    kduvvuri    07/15/02 - kduvvuri_bug-2442426_main
#    kduvvuri    07/12/02 - Creation
# 

use File::Spec;
use hostOSD;
use Net::Domain qw(hostname hostfqdn hostdomain domainname);

($emdRoot,$hostName,$crsHome) = @ARGV;
require "$emdRoot/sysman/admin/scripts/emd_common.pl";
require "$emdRoot/sysman/admin/scripts/semd_common.pl";
require "$emdRoot/sysman/admin/scripts/rac/clusterCommon.pl";
require "$emdRoot/sysman/admin/scripts/ccr/ccr_common.pl";

if (!exists $ENV{LL_ORACLE_HOME}) { print "<Targets>\n" };
nmep_printHostTarget();
if (!exists $ENV{LL_ORACLE_HOME}) { print "</Targets>\n" };

sub nmep_printHostTarget 
{
  # This should never happen.
  if ( (! defined $hostName ) || (!defined $emdRoot) ) 
  {
    #TODO, log an error message that we can not proceed
    return;
  }

  if (defined $ENV{OMSENV_CRS_HOME})
  {
    $crsHome = $ENV{OMSENV_CRS_HOME};
    my $oldOH = $ENV{ORACLE_HOME};
    $ENV{ORACLE_HOME} = $crsHome;
    `$crsHome/bin/cemutlo -n 2>&1`;
    $ENV{ORACLE_HOME} = $oldOH;
    if ($?)
    {
      print "<DiscoveryWarning DISCOVERY_SCRIPT=\"INVALID_CRSHOME\"/>\n";
    }    
  }  

  ($clusterName, $crsHome) = getClusterName($emdRoot, $crsHome);
  
  if (defined $ENV{CLUSTER_NAME} && $ENV{CLUSTER_NAME} ne '')
  {
    $clusterName = $ENV{CLUSTER_NAME};
  }
  
  if ( $clusterName ne '') 
  {
    print "  <Target TYPE=\"cluster\" NAME=\"$clusterName\" >\n";
    if ($crsHome ne "")
    {
      print "    <Property NAME=\"OracleHome\" VALUE=\"$crsHome\"/>\n";
    }
    print "    <Property NAME=\"OCM_CROSS_HOST\" VALUE=\"TRUE\"/>\n";
    print "  </Target>\n"
  }

  if (exists $ENV{LL_ORACLE_HOME}) 
  {
    my $cmcfgOra = File::Spec->catdir($ENV{LL_ORACLE_HOME},"oracm","admin","cmcfg.ora");
    my $configFile = getSrvConfigFile();
    if (-e $cmcfgOra || -e $srvConfig)
    {
      $clusterName = "ocm_$ENV{LL_ORACLE_HOME}";
      print "  <Target TYPE=\"cluster\" NAME=\"$clusterName\" >\n";
      print "    <Property NAME=\"OracleHome\" VALUE=\"$ENV{LL_ORACLE_HOME}\"/>\n";
      print "    <Property NAME=\"OCM_CROSS_HOST\" VALUE=\"TRUE\"/>\n";
      print "  </Target>\n";
    }
  } 

  print "  <Target TYPE=\"host\" NAME=\"$hostName\" >\n";
## populate version_value
## In NT getOSRelease need to have ORACLE_HOME to be set in environment
## ORACLE_HOME might not be set at the time of discovery.
## store OH in a variable and set it to LL_ORACLE_HOME and then reset it
  my $tmpOH = $ENV{ORACLE_HOME};
  $ENV{ORACLE_HOME}=$ENV{LL_ORACLE_HOME};
  my $versionRelease = getOSRelease();
  $ENV{ORACLE_HOME}=$tmpOH;
  # getOSRelease will give you baseversion-release info, we just need base version
  my $baseVersion = (split("-",$versionRelease))[0];
  printf "    <Property NAME=\"version_value\" VALUE=\"%s\"/>\n",
                                  $baseVersion;
  if ( $clusterName ne '') 
  {
    print "    <AssocTargetInstance ASSOCIATION_NAME=\"cluster_instance\" ASSOC_TARGET_TYPE=\"cluster\" ASSOC_TARGET_NAME=\"$clusterName\"/>\n";
    print "    <CompositeMembership>\n";
    print "      <MemberOf TYPE=\"cluster\" NAME=\"$clusterName\" ASSOCIATION=\"cluster_member\" />\n";
    print "    </CompositeMembership>\n";
  }

  # add association if the host is part of oracle dbmachine
  if (-e "/opt/oracle.cellos")
  { 
    my $dbmachineName;
    my ($shortHostName) = split /\./, $hostName;
    $shortHostName = lc($shortHostName);
    $dbmachineName=getDbMachineNameFromLL($shortHostName);
    if(defined $dbmachineName && $dbmachineName ne "")   
    { 
      print "    <Property NAME=\"dbmachine_uniqueid\" VALUE=\"$dbmachineName\"/>\n";
    }
  }


  print "  </Target>\n";
}

sub getDbMachineNameFromLL()
{

   my ($shortHostName) = @_;
   my %allLLFiles = getAllLLfiles();

   my $cellHostName;
   # Now walk the list of all config files we found.
   foreach $fullFilePath (values %allLLFiles)
   {
      EMD_PERL_INFO("$LOG_CATEGORY Handle $fullFilePath");
      my ($volume,$directories,$file) = File::Spec->splitpath($fullFilePath);

      if ( $file =~ /(.*)(\.ll$|\.ccr$)/)
      {
         ########################### call Cell discovery #########
         my @cellTargets = getCellTargetsInfoFromDBll($fullFilePath);
	 # if cell target available in one ll file then we can skip all other files.
         if (@cellTargets)
         {
            my $cellTarget = lc($cellTargets[0]);
            my @tokens=split(/\|/, $cellTarget);
            my $cellName = $tokens[1];
            ($cellName) = split /\./, $cellName;

            my $commonPrefix = findCommonPrefix($cellName, $shortHostName);
            $cellHostName = $commonPrefix.".".hostdomain();
            if(defined $commonPrefix && $commonPrefix ne "")
            {
              $cellHostName = $commonPrefix.".".hostdomain();
              return $cellHostName;
            }
          }
          EMD_PERL_INFO(" target name is: $llCellTargetNames");
          ########################### end Cell discovery #########
       }
    }
    #end of going through .ll file
}
