#!/usr/local/bin/perl
# 
# $Header: ibm_discover.pl 22-may-2006.07:30:52 dkapoor Exp $
#
# ibm.pl
# 
# Copyright (c) 2002, 2006, Oracle. All rights reserved.  
#
#    NAME
#      discovers the livelink target
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#       dkapoor  05/21/06 - windows discovery implmtd 
#       ndutko   08/03/05 - ndutko_code_checkin
#    dkapoor      30-jun-2005 - Creation


strict;
($emdRoot,$hostName,$crsHome) = @ARGV;
require "$emdRoot/sysman/admin/scripts/semd_common.pl";
require "$emdRoot/sysman/admin/discover/utl/thirdPartyCommon.pl";
use File::Spec;
use File::Basename;

EMD_PERL_DEBUG("IBM DISCOVERY START");

if(get_osType() eq 'WIN')
{	
  my @locations = getWindowsInstalledLocations("IBM WebSphere Application Server");
  my $location;
  foreach $location (@locations)
  {
      EMD_PERL_DEBUG("Home = $location");
      #The install location returned is path to the uninstall command
      #like <drive>:<IBM_HOME>\_uninst
      if(defined $location && $location ne "")
      {
        printTarget(dirname($location));
      }
  }
  exit;
}

EMD_PERL_DEBUG("HOME directory [". $ENV{HOME}. "]");

my $vpdFile = File::Spec->catdir($ENV{HOME}, "vpd.properties");
#vpd.properties base discovery is not working as we don't know the format
#of this file.
$vpdFile = "";

EMD_PERL_DEBUG("HOME IBM at $vpdFile");

my @ibmHomes; 
if(-f $vpdFile)
{
	if(open(IBM_HOME_LIST,$vpdFile))
	{
            while ( my $line = <IBM_HOME_LIST> )
            {
                my @tempArray = split(/=/,$line);

                if(($tempArray[1] =~ /^WebSphere Application Server\|/) or
                    ($tempArray[1] =~ /^WebSphere Network Deployment\|/))
                {
		    EMD_PERL_DEBUG("Found WAS or WND: $tempArray[1]");
            	    my @tokens = split(/\|/,$tempArray[1]);
                    my $token;
                    foreach $token (@tokens)
                    {
		        EMD_PERL_DEBUG("Token=$token");
                        if($token =~ /:\\/ or $token =~ /\//)
                        {
		            EMD_PERL_DEBUG("HOME FOUND-->$token");
              	            push(@ibmHomes,$token);
                        }
                    }
                }
            }

	    close(IBM_HOME_LIST)
	}
}
else
{
#find the ibm homes from the running Server
 EMD_PERL_DEBUG("start from running server");
 @ibmHomes = getIBMHomes ();
}

if(! defined @ibmHomes)
{
   exit;
}
my %discoveredHomes;
for my $home (@ibmHomes)
{
 chomp($home);
 if(defined  $discoveredHomes{$home})
 {
     #Don't discover already discovered homes
     next;
 }
 $discoveredHomes{$home} = $home;
 printTarget($home);
}

EMD_PERL_DEBUG("IBM DISCOVERY END");

sub getIBMHomes 
{
   my @ibmHomes;
   my @thirdPartyJarList = getThirdPartyJarList("com.ibm.ws.runtime.WsServer","bootstrap");
   for my $path (@thirdPartyJarList)
   {
   	#Found the directory for the bootstrap.jar
       	#its of the format <IBM_HOME>\lib\bootstrap.jar
	EMD_PERL_DEBUG("got the directory bootstrap.jar-->$path");
        $path = dirname($path);
	EMD_PERL_DEBUG("IBM Home from running process=$path");
        push(@ibmHome,$path);
   }

   return @ibmHome; 
}

#Print the target
sub printTarget
{
 my ($home) = @_;
 if( !-d $home)
 {
   EMD_PERL_DEBUG("Discovered IBM home at $home does not exists. Not discovering!");
 }

 my $targetName = getTargetName($home,"IBM");
 EMD_PERL_DEBUG("Found IBM at $home");
print <<__END;
<Target TYPE="ibm" NAME="$targetName">
  <Property NAME="IBMHOME" VALUE="$home"/>
</Target>
__END
}

