#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/java_virtual_machine.pl /main/4 2012/02/08 22:16:58 nvarma Exp $
#
# java_virtual_machine.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      java_virtual_machine.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#     This script discovers the jvm targets found in the middleware home.
#     It creates targets for JRockit installations, it will be enhances to
#     include other oracle supported JVMs like Hotspot.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nvarma      08/01/11 - Creation
# 

#!/usr/local/bin/perl
# 
use strict;
use Config;
use File::Spec;
use ias::simpleXPath;
use ias::propertiesFileParser;
use Sys::Hostname;
use Socket;

#******************************************
#     Global Variables
#*****************************************
#my $result = ();


my ($emdRoot,$hostName) = @ARGV;
require "$emdRoot/sysman/admin/scripts/semd_common.pl";

my $osType = get_osType();     # get the OS type
my $sepchar = "/";
my $targetExe = "java";

if ($osType eq "WIN")
{
    $sepchar='\\';
    $targetExe = "java.exe";
}

my $oracleHome = $ENV{ORACLE_HOME};
my $configCCRHome = $ENV{CCR_CONFIG_HOME};

my @targetLines;
my $host;
my $middlewareHome ;
my $jvmVisited = "0";

  $middlewareHome = $ENV{'BEA_HOME'};
  if (!defined($middlewareHome))
  {
# Targetting JRockit in a MW home only
    EMD_PERL_DEBUG("No BEA_HOME defined, aborting jrockit discovery");
    exit;
  }

#--------------------------------
# Make sure the domain locations file exists
my $domainsFileName = "$middlewareHome/utils/ccr/domainlocation.properties";
if (!-e $domainsFileName)
{
    EMD_PERL_DEBUG("No domainlocation.properties file found, aborting JRockit discovery");
    exit;
}

# Parse the domain locations file to find all domain homes on this host
my %domainLocations = parsePropertiesFile($domainsFileName);
my @domainHomes;
for my $domainHost (keys %domainLocations)
{
    my $lcDomainHost = lc($domainHost);
        EMD_PERL_DEBUG("lcDomainHost:  $lcDomainHost");
    if (lc($hostName) eq $lcDomainHost || lc($hostName) =~ /^$lcDomainHost\..+/)
    {
        push(@domainHomes, split(',', $domainLocations{$domainHost}));
    }
}
        EMD_PERL_DEBUG("domainHomes:  @domainHomes ");
my @jrockitDir;
my @validJrockitDir;
my @javaVersion;

# Visit each unique domain and discover its targets
my $domainHome = $domainHomes[0];
        EMD_PERL_DEBUG("DomainHost:  $domainHome");
for my $domainHome (@domainHomes)
{
    # Make sure the domain config file exists
    my $configFileName = "$domainHome/config/config.xml";
    if (!-e $configFileName)
    {
        EMD_PERL_DEBUG("No config.xml in domain home: $domainHome; skipping");
        next;
    }

    my $configFile = ias::simpleXPath::parseFile($configFileName);
    my $domainName = (ias::simpleXPath::queryForText($configFile,
        'domain/name'))[0];

    # Determine if the domain is part of an IAS install by looking
    # for the JRF template
    my $isIas = 0;
    if (-e "$domainHome/init-info/domain-info.xml")
    {
        my $domainInfoFile = ias::simpleXPath::parseFile(
            "$domainHome/init-info/domain-info.xml");
        my $jrf = (ias::simpleXPath::queryForAttributes($domainInfoFile,
            'domain-info/domain-template-info/identification[@name="Oracle JRF Extension"]'))[0];
        if (!defined($jrf))
        {
            $jrf = (ias::simpleXPath::queryForAttributes($domainInfoFile,
                'domain-info/extention-template-ref[@name="Oracle JRF"]'))[0];
        }
        $isIas = defined($jrf);
    }

    # Domain target
    my $domainTarget = $isIas ? "/Farm_$domainName/$domainName" : "/$domainName";

    getJVMTargetInfo();
    my $number;
    for($number =0; $number <= $#jrockitDir; $number++)
    {
        if($validJrockitDir[$number] eq "y")
        {
    	   &printJVMTargetLines($domainTarget, $number);
        }
    }
}
#--------------------------------
print(@targetLines);


sub printJVMTargetLines()
{
   my $domainTarget = $_[0];
   my $num = $_[1];
#push proxy oracle home value, if the oracle home of product is different from that of where ccr is configured
   my $jvmIdentification = "oracle_jrockit";
   push(@targetLines, "<Target TYPE=\"java_virtual_machine\" NAME=\"${domainTarget}_${jvmIdentification}\" DISPLAY_NAME=\"JRockit JVM\" ON_HOST=\"$hostName\">\n");
   push(@targetLines, "\t<Property NAME=\"OcmProxyOracleHome\" VALUE=\"${middlewareHome}${sepchar}${jrockitDir[$num]}\"/>\n");
   push(@targetLines, "\t<Property NAME=\"version_value\" VALUE=\"$javaVersion[$num]\"/>\n");
   push(@targetLines, "\t<Property NAME=\"Version\" VALUE=\"$javaVersion[$num]\"/>\n");
   push(@targetLines, "\t<Property NAME=\"domainTarget\" VALUE=\"$domainTarget\"/>\n");
   push(@targetLines, "\t<Property NAME=\"jvmHost\" VALUE=\"$hostName\"/>\n");
   push(@targetLines, "\t<Property NAME=\"jvmName\" VALUE=\"$jvmIdentification\"/>\n");
   push(@targetLines,"</Target>\n");
}

sub getJVMTargetInfo
{
   if ($jvmVisited eq "1")
   {
      return;
   }
   my $fl;
   my $allFiles;

   opendir (MW, "$middlewareHome");
   my @allFiles = readdir(MW);
   my @files = grep(/jrockit*/, @allFiles);
   closedir(MW);
   EMD_PERL_DEBUG("JRockit directories under the mw home:\n @files\n");

   my $i = -1;
   for  my $jDir (@files)
   {
      $i = $i +1; 
      $jrockitDir[$i] = $files[$i];
      EMD_PERL_DEBUG("JRockit Dir = ${jrockitDir[$i]}");
   
      chomp($jrockitDir[$i]);
      if ($jrockitDir[$i] eq "") 
      {
          EMD_PERL_DEBUG("No jrockit directory\n");
          $validJrockitDir[$i] = "n";
          next;
      }
      my $javaExe = "${middlewareHome}${sepchar}${jrockitDir[$i]}${sepchar}jre${sepchar}bin${sepchar}${targetExe}"; 
      if (! -e $javaExe)
      {
	   EMD_PERL_DEBUG("No java executable found ");
           $validJrockitDir[$i] = "n";
           next;
      }
# Read the ReleaseInformation.xml file to obtain version information.
      my $releaseInformationFile = "${middlewareHome}${sepchar}${jrockitDir[$i]}${sepchar}jre${sepchar}lib${sepchar}ReleaseInformation.xml";

      EMD_PERL_DEBUG("ReleaseInformation file : $releaseInformationFile ");
      if (! -e $releaseInformationFile)
      {
	   EMD_PERL_DEBUG("No ReleaseInformation.xml file found \n");
           $validJrockitDir[$i] = "n";
           next;
      }
      my $relFile = ias::simpleXPath::parseFile($releaseInformationFile);

      my $version = (ias::simpleXPath::queryForText($relFile, 'patch_information/product_version'))[0];
       EMD_PERL_DEBUG("Version is $version");
		if($version=="6 Update 29 R28.2.2")
		{
       EMD_PERL_DEBUG("Converting $version to 6u29 R28.2.2");
		 $version = "6u29 R28.2.2";
		}

      $javaVersion[$i]=$version;
      $validJrockitDir[$i] = "y";
   }
   $jvmVisited = "1";
   
}
   
