#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/ocs_mailstore_discovery.pl /main/1 2009/11/25 21:49:18 aghanti Exp $
#
# ocs_mailstore_discovery.pl
# 
# Copyright (c) 2005, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ocs_mailstore_discovery.pl - discover mailstore targets to be monitored
#
#    DESCRIPTION
#    This script is used to discover mailstore targets to be monitored.
#    please read
#    ess30/bug3977203/Discover_Mailstore.html
#
#    NOTES
#    Script finds if there are mailstores to be monitored if sp
#    then encloses the target mailstore entries in a <targets></targets>
#    if no targets are found then <targets></targets> is printed.
#    
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    aghanti       08/27/09 - Remove references to ADE and oracle hostnames
#    hpammi        08/10/05 - hpammi_bug-3977203
#    pallumpa      08/07/05 - Creation
# 
#
########################################
# 1. arg to script is central agent oracle home
########################################
my ($cagentOH) = @ARGV;

########################################
# 2. determine platform, set some variables
########################################

my $filesep ;
if ( $ENV{OS} =~ /^Windows/ ) 
{
    $filesep = "\\";
} 
else 
{
    $filesep = "/";
}

# get all oracle homes in this host.
use emdiscoveryhelper('getOracleHomes');
$oraclehomes = getOracleHomes();

$numHomes=@$oraclehomes;
print "\<Targets\>\n";
#For each oracle home, try to read targets.xml
#if present and see if it contains a mailstore
#to be monitored.
for ( $i = 0; $i < $numHomes; $i++ ) 
{
  $oneOH = $oraclehomes->[$i];
  chomp($oneOH);
  # first check targets.xml
  my $targets_xml = join($filesep, $oneOH, "sysman", "emd", "targets.xml");
  if ( -e $targets_xml )
  {
    open TARGETSXML, $targets_xml ;
  } 
  else 
  {
    next;
  }

  @lines = <TARGETSXML>;
  $lines_ref = \@lines ;
  for ($j = 0; $j <= $#$lines_ref; $j++) 
  {
    my @processedLines;
    $str0= $lines_ref->[$j];
    chomp($str0);
    if ($str0 =~ /<target/i && $str0 =~ /type="mailstore"/i) 
    {
      push (@processedLines, "$str0 \n");
      my $print_current_target = 0;
      $j++;
      $not_all_properties_processed = 1;
      while ($not_all_properties_processed ) 
      {
        $str1 = $lines_ref->[$j];
        chomp($str1);

        #read the oracle home of this mailstore
        #and check if the central agent already monitors it.
        if ($str1 =~ /oraclehome/i) 
        {
          push (@processedLines, "$str1 \n");
          $_ = $lines_ref->[$j];
          $_ =~ s/.*value="([^\"]*)".*/$1/i;
          chomp;
          $print_current_target = oh_not_present($_);
        } 
        elsif ($str1 =~ /password/i) 
        {
          #store empty password value as the seed in the source
          #target.xml would be different from the seed for encryption in 
          #the destination.
          push(@processedLines, "<Property NAME=\"password\" VALUE=\"\"/> \n");
        } 
        else 
        {
          push (@processedLines, "$str1 \n");
        }
        if ($str1 =~ /<\/target/i) 
        {
          $not_all_properties_processed = 0;
        }
        $j++;
      }
      # if the current target is not present in the central agent targets
      # print the target entry
      if ($print_current_target) 
      {
        print @processedLines;
      }
    }
    undef @processedLines;
  }
  close TARGETSXML;
}
print "\<\/Targets\>\n";
exit 0;

########################################
## see if central agent targets.xml exists and 
## already has a mail store entry with this oracle home
#########################################

sub oh_not_present {
  
  my $myOH = shift(@_);
  
  #read the central agent targets.xml and see if entry
  #already present
  my $ca_targets_xml = join($filesep, $cagentOH, "sysman", "emd", "targets.xml");

  if ( -e $ca_targets_xml ) 
  {
    open CATARGETSXML, $ca_targets_xml ;
  } 
  else 
  {
    return 1;
  }
          
  @ca_lines = <CATARGETSXML>;
  $ca_lines_ref = \@ca_lines ;

  for ($k = 0; $k <= $#$ca_lines_ref; $k++) 
  {
    my @processedLines;
    $_ = $ca_lines_ref->[$k];
    if (/<target/i && /type="mailstore"/i) 
    {
      $k++;
      while (1) 
      {
        $_ = $ca_lines_ref->[$k];
        $k++;
        if (/oraclehome/i) 
        {
          $_ =~ s/.*value="([^\"]*)".*/$1/i;
          chomp;
          if ( $myOH eq $_ ) 
          {
            #if the central agent already has a mailstore entry
            #for this oracle home then return 0
            close CATARGETSXML;
            return 0 ;
          }
        }
        if (/<\/target/i) 
        {
          last;
        }
      }
    }
  }
  close CATARGETSXML;
  return 1;
}

