#!/usr/local/bin/perl
#
# $Header: emll/sysman/admin/discover/oracle_apps_cm.pl /main/14 2012/11/06 13:57:28 fmorshed Exp $
#
# Copyright (c) 2005, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_apps_cm.pl
#
#    DESCRIPTION
#      N/A
#
#    NOTES
#      N/A
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    11/05/12 - Call getStateDirs instead of figuring it out.  In presence
#                           of designated collector the algorithm is more complicated.
#    jsutton     02/25/11 - Fixes related to issue with values from
#                           getConfigProperty
#    aghanti     10/14/10 - Bug 9033775 - Do not discover targets from
#                           .ll*/.ccr/.emrep file if it does not have end
#                           marker
#    jsutton     03/19/10 - fix up target dbname property
#    aghanti     06/05/09 - Add CCR_DB_NLS_CHARACTERSET as property in
#                           targets.xml file
#    pparida     06/01/09 - impl_multiplex_clientside: Add MULTIPLEXED property
#                           conditionally to oracle_apps_cm target.
#    pparida     10/17/07 - XbranchMerge pparida_bug-6492554 from
#                           st_emll_10.2.7
#    pparida     10/15/07 - Fix bug 6492554: Use CCR_CONFIG_HOME for OCM log,
#                           state and config dirs.
#    jsutton     06/21/07 - Add OCM_CROSS_HOST property to RAC targets
#    dkapoor     12/02/05 - use ccr/ccr_common 
#    fle         10/17/05 - Check if RAC.
#    fle         10/12/05 - Add CCR_COLLECTION_TIMESTAMP_OVERRIDE.
#    fle         10/05/05 - Changed LOG_CATEGORY and delete cm ll file after 30 days old.
#    fle         09/30/05 - Not move *.ll files to temp.
#    fle         09/11/05 - Created.
#

use Config;
use Cwd;
use File::Copy;
use File::Spec;
use File::stat;

my ($emdRoot,$hostName,$crsHome) = @ARGV;
$ENV{EMDROOT} = $emdRoot;

require "$emdRoot/sysman/admin/scripts/emd_common.pl";
require "$emdRoot/sysman/admin/scripts/semd_common.pl";
require "$emdRoot/sysman/admin/scripts/ccr/ccr_common.pl";

#Discovery LOG CATEGORY
$LOG_CATEGORY = "ORALCE_APPS_CM_DISCOVERY: ";

EMD_PERL_INFO("$LOG_CATEGORY ***** Start of oracle_apps_cm discovery *****");
my $elapsedSec = time();
# The Live link agent home is defined only if discovery is called by the live link agent.
# During this, discover only targets for this agent home
if (defined $ENV{LL_ORACLE_HOME} && -d  $ENV{LL_ORACLE_HOME})
{
  my $llOracleHome = $ENV{LL_ORACLE_HOME};
  my @configDirs = getStateDirs($emdRoot,$hostName);
  foreach $configDir (@configDirs)
  {
    EMD_PERL_DEBUG("Checking $configDir for ll/ccr files");  
    opendir(DIR,$configDir);
    my @files = grep {/\.ll$/ } readdir(DIR);
    foreach my $file (@files)
    {
      EMD_PERL_DEBUG("$LOG_CATEGORY Process $file");
      if ($file =~ /(.*).ll$/)
      {
        my $filename = $1;
        if ($filename =~ /(.*)-apps_cm$/)
        {
          # Delete cm ll file after 30 days old.
          my $fullFilePath = File::Spec->catdir($configDir, $file);
          EMD_PERL_INFO("$LOG_CATEGORY Days past since last modification on $fullFilePath=". (-M $fullFilePath));
          if (-M $fullFilePath >= 30)
          {
            unlink($fullFilePath);
            EMD_PERL_INFO("$LOG_CATEGORY Deleted 30 days old file= $fullFilePath");
            next;
          }
          #
          # Check if the file has been completely written out (has an end marker)
          # If it is incomplete, print a warning and ignore the file
          #
          next if (llFileIsComplete($fullFilePath) ne "true");
          my $dbname= $1;
          my $isRAC = 0;
          print "<Target TYPE='oracle_apps_cm' NAME='$1_apps_cm'>\n";
          print "  <Property NAME='DBOracleHome' VALUE='$llOracleHome'/>\n";
          # Move this logic around so we get properties similar to oracle_apps_db.
          # NOTE that we have existing targets with -RAC in the name and do not 
          # want to create new targets; we leave RAC in the name (above).
          # If associated with a RAC database, strip RAC off dbname. This is so that
          # when we go to get association info we look for the right files (bug 9319824)
          if ($dbname =~ /(.*)-RAC$/)
          {
            $dbname= $1; 
            $isRAC = 1;
          }
          print "  <Property NAME='DBName' VALUE='$dbname'/>\n";
          print "  <Property NAME='ConfigFile' VALUE='".File::Spec->catdir($configDir, $file)."'/>\n";
          if ($isRAC) 
          {
            print "  <Property NAME='ISRAC' VALUE='true'/>\n";
            print "  <Property NAME='OCM_CROSS_HOST' VALUE='TRUE'/>\n";
            print "  <Property NAME=\"MULTIPLEXED\" VALUE=\"TRUE\" />\n";
          }
          my $timestamp = getCollectionTimestamp($fullFilePath);
          if (defined $timestamp && $timestamp != "")
          {
            print "  <Property NAME='CCR_COLLECTION_TIMESTAMP_OVERRIDE' VALUE='$timestamp'/>\n";
          }
          my $dbcharset = getConfigProperty($fullFilePath, "NLS_CHARACTERSET");
          if (defined $dbcharset && $dbcharset ne "")
          {
            print "  <Property NAME='CCR_DB_NLS_CHARACTERSET' VALUE='$dbcharset'/>\n";
          }
          print "</Target>\n";
        }
      }
    }
  }
  closedir(DIR);
}
$elapsedSec = time() - $elapsedSec;
EMD_PERL_INFO("$LOG_CATEGORY ***** End of oracle_apps_cm discovery: total sec= $elapsedSec *****");

# Returns the timestamp from the config file, if there is no error and the value 
# is not empty, return the value, otherwise, returned undefined value.
sub getCollectionTimestamp
{
  my ($configFile) = @_;
  my ($err,$value) = getConfigProperty($configFile, "TIMESTAMP");

  EMD_PERL_DEBUG("$LOG_CATEGORY in getCollectionTimestamp for $configFile=$err,$value");
  # If there is no error and the value is not empty, return the value
  $value =~ s/^\s*|\s*$//g;
  if ($err eq "" && $value ne "")
  {
    return $value;
  }
  return "";
}

