#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/oracle_apps_inf.pl /main/12 2012/08/06 12:44:03 rlandows Exp $
#
# Copyright (c) 2002, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_apps_inf.pl - creates a host target with just name and type.
#
#    DESCRIPTION
#      
#
#    NOTES
#      
#
#    MODIFIED   (MM/DD/YY)
#    rlandows    08/06/12 - to fix bug 14461063
#    ppradhan    02/27/07 - Fix for bug 5875555
#    ppradhan    06/13/06 - Fix issue on Windows - bug 5296732 
#    ppradhan    03/08/06 - changing to _debug calls 
#    ppradhan    03/07/06 - Fixing bug 5082088 
#    fle         10/12/05 - Changed the inf target name to be consistence with others.
#    fle         10/11/05 - Warn about config/context file not found.
#    fle         10/10/05 - Added require "emd_common.pl".
#    fle         09/19/05 - Changed 'returns' to 'return'
#    rmohan	 07/12/02 - Creation
# 

use TXK::XML();
use TXK::Common();
use TXK::Runtime();
use TXK::Error();
use ias::propertiesFileParser;
use ias::simpleXPath;

#Version of Oracle EBusiness Suite Infrastructure Target

$SC_VAR_ORACLE_HOME = $ENV{LL_ORACLE_HOME};

($emdRoot,$hostName,$crsHome) = @ARGV;
require "$emdRoot/sysman/admin/scripts/emd_common.pl";
require "$emdRoot/sysman/admin/scripts/semd_common.pl";

# Check the Oracle Home
# This should never happen.
if ((! defined $hostName ) || (!defined $emdRoot) ||(!defined $SC_VAR_ORACLE_HOME))
{
   _error("EBS discovery failed! Required variable undefined LL_ORACLE_HOME", true);  
   exit 0;
}


#If we are able to get targtes from $OH_APPSUTIL_CTX exit
my ($lCheckFoundFiles) = _printTargetsFrom_OH_APPSUTIL_CTX();
_debug(" lCheckFoundFiles = $lCheckFoundFiles", true);    
if($lCheckFoundFiles == 0)
{
   EMD_PERL_DEBUG("Successfully printed target from OH_APPSUTIL_CTX");
   #die "done!"; # For local testing
   exit 0;
}


$lCheckFoundFiles = _printTargetsFrom_WEBLOGIC();

if($lCheckFoundFiles == 0)
{
   EMD_PERL_DEBUG("Successfully printed target from WEBLOGIC");
   #die "done!"; # For local testing
   exit 0;
}



sub _printTargetsFrom_WEBLOGIC
{
  my $retu_gotTragets = -1;
  my $middlewareHome = $ENV{'BEA_HOME'};
  if (!defined($middlewareHome))
  {
    EMD_PERL_DEBUG("No BEA_HOME defined, aborting apps 12.2 discovery");
    exit;
  }

  #14461063
  my $applTopLoc=$middlewareHome."/../EBSapps/appl";
  if (! -d $applTopLoc)
  {  
     EMD_PERL_DEBUG("appl_top is not a valid directory");
     exit;
  }

  my ($shortHostName) = split /\./, $hostName;
  $shortHostName = lc($shortHostName);



  opendir(APPLDIR, $applTopLoc);
  @envFiles = grep(/\.env$/, readdir(APPLDIR));
  closedir(APPLDIR);
 
  my $ctxFile;
  foreach $tempEnvFile (@envFiles)
  {
    if($tempEnvFile =~ /_/)
    {
      if (substr($tempEnvFile,0,4) ne "APPS")
      {
         if (lc($tempEnvFile) =~ $shortHostName)
         {
           $ctxFile = _getContextFile($tempEnvFile,$applTopLoc);
           if (-f $ctxFile)
           {
              $lContextFileName = $ctxFile;
              $xmlObj = TXK::XML->new();
              $xmlObj->loadDocument( { "file" => $ctxFile} );
              _printAllEbsTargets($xmlObj);
              $retu_gotTargets = 0;
              break;
           }
         }
      }
    }
  }

  return $retu_gotTargets;

}

sub _getContextFile
{
  my ($envFile,$applTop) = @_;

  my $fileWithPath = $applTop ."/". $envFile;

  if(! -f $fileWithPath)
  {
    return;
  }

  my $ctxFile;
  open(ENVFILE, $fileWithPath) or die $!;
  while(my $line = <ENVFILE>)
  {
    if ($line =~/CONTEXT_FILE=/)
    {
      chomp($line);
      my $lastQuote = index($line,"\"",14);
      $ctxFile = substr($line,14,$lastQuote-14);
      break; 
    }
  }
  close(ENVFILE);
  return $ctxFile;

}





sub _printEbsInfraTarget
{
  my $xmlObj = shift(@_);
  my $lSystemName =  $xmlObj->getOAVar('s_systemname');
  my $lContextName = $xmlObj->getOAVar('s_contextname');
  my $lContextType = $xmlObj->getOAVar('s_contexttype');
  my $lTargetName = "$lSystemName:Infrastructure($lContextName)";
  
  print "  <Target TYPE=\"oracle_apps_inf\" NAME=\"$lTargetName\">\n";
  print "    <Property NAME=\"contextFile\" VALUE=\"$lContextFileName\" />\n";
  print "  </Target>\n";
}

sub _printCmInfraTarget {
    my $xmlObj = shift(@_);
    my $isConc =  $xmlObj->getOAVar('s_isConc');
    if ($isConc ne "YES") {
	return;
    }
  
    my $lSystemName =  $xmlObj->getOAVar('s_systemname');
    my $lContextName = $xmlObj->getOAVar('s_contextname');

    my ($lTargetName) = "$lSystemName:Concurrent Processing Infrastructure($lContextName)";
  
    print "  <Target TYPE=\"oracle_apps_cm_inf\" NAME=\"$lTargetName\">\n";
    print "    <Property NAME=\"contextFile\" VALUE=\"$lContextFileName\" />\n";
    print "  </Target>\n";
}

sub _printReportTarget {
    my $xmlObj = shift(@_);
    my $isEnabled =  $xmlObj->getOAVar('s_reptstatus');
    if ($isEnabled ne 'enabled') {
        return;
    }

    my $systemName =  $xmlObj->getOAVar('s_systemname');
    my $contextName = $xmlObj->getOAVar('s_contextname');

    my $targetName = "$systemName:Report Server($contextName)";
    my $serverName =  $xmlObj->getOAVar('s_dbSid');

    print "  <Target TYPE=\"oracle_apps_reports\" NAME=\"$targetName\">\n";
    print "    <Property NAME=\"contextFile\" VALUE=\"$lContextFileName\"/>\n";
    print "    <Property NAME=\"serverName\" VALUE=\"REP60_$serverName\"/>\n";
    print "  </Target>\n";
}

sub _printDiscovererTarget {
    my $xmlObj = shift(@_);
    my $isEnabled =  $xmlObj->getOAVar('s_discostatus');
    my $host1 =  $xmlObj->getOAVar('s_hostname');
    my $host2 = $xmlObj->getOAVar('s_disco_machine');
    if ($isEnabled ne 'enabled') {
        if ($host2 =~ /^$host1\./) { # Test if 'host2' starts with 'host1.'.
            return;
        }
    }

    my $systemName =  $xmlObj->getOAVar('s_systemname');
    my $contextName = $xmlObj->getOAVar('s_contextname');

    my $targetName = "$systemName:Discoverer($contextName)";
    my $oracleHome =  $xmlObj->getOAVar('s_tools_oh');

    print "  <Target TYPE=\"oracle_apps_discoverer\" NAME=\"$targetName\">\n";
    print "    <Property NAME=\"contextFile\" VALUE=\"$lContextFileName\"/>\n";
    print "    <Property NAME=\"oracleHome\" VALUE=\"$oracleHome\"/>\n";
    print "  </Target>\n";
}

sub _printFormsListenerTarget {
    my $xmlObj = shift(@_);
    my $isEnabled =  $xmlObj->getOAVar('s_isForms');
    if ($isEnabled ne 'YES') {
        return;
    }

    my $systemName =  $xmlObj->getOAVar('s_systemname');
    my $contextName = $xmlObj->getOAVar('s_contextname');

    my $targetName = "$systemName:Forms Listener($contextName)";
    my $oracleHome =  $xmlObj->getOAVar('s_tools_oh');
    my $port =  $xmlObj->getOAVar('s_formsport');
    my $rtiDir =  $xmlObj->getOAVar('s_formsrtidir');

    print "  <Target TYPE=\"oracle_apps_forms\" NAME=\"$targetName\">\n";
    print "    <Property NAME=\"contextFile\" VALUE=\"$lContextFileName\"/>\n";
    print "    <Property NAME=\"oracleHome\" VALUE=\"$oracleHome\"/>\n";
    print "    <Property NAME=\"port\" VALUE=\"$port\"/>\n";
    print "    <Property NAME=\"rtiDir\" VALUE=\"$rtiDir\"\/>\n";
    print "  </Target>\n";
}

#***********************************************************************************
# Returns 0 if failed. Error messages is written to trace file.
sub getContextXmlObj {
  # read from apps.conf file
  my ($lCommontop) = _getCommonTop(); 
  _debug("lCommontop = $lCommontop", true);    
  if (! defined $lCommontop)
  {
    return 0;
  }

  $lContextFileName = _getContextFileName($lCommontop);
  if (! defined $lContextFileName || !(-e $lContextFileName))
  {
    _debug("*** Ignore this message if this is NOT IAS_ORACLE_HOME ***\nEBS discovery failed. Could not locate CTX_FILE");
    return 0;
  }

  # Load the context file.
  $xmlObj = TXK::XML->new();
  $xmlObj->loadDocument( { "file" => $lContextFileName  } );
  return $xmlObj;
}

#***********************************************************************************
sub _getCommonTop{
  $retu_CommonTop;
  my $lCnfFileName = "$SC_VAR_ORACLE_HOME/Apache/Apache/conf/apps.conf";
  if (!( -e $lCnfFileName)) {
     _debug("*** Ignore this message if this is NOT IAS_ORACLE_HOME ***\nNot Ebiz infra target. File not found: $lCnfFileName.");       
     return -1;     
  }     

  if (!(-r $lCnfFileName)) {
    _error("Cannot access file '$lCnfFileName'.");
    return -1;
  }
  open(FILE, "$lCnfFileName");
  while(FILE){
     chomp($line = <FILE>);
     
     if((index($line,"Alias") >= 0) && (index($line,"OA_JAVA") >= 0)){
#     _debug("$line \n", true);
     $lStartIndex = index($line,'"') + 1;   
#     print "lStartIndex = $lStartIndex \n";     
     $lEndIndex = index($line,"java");
     $retu_CommonTop = substr($line, $lStartIndex, ($lEndIndex - $lStartIndex));
#     print "lEndIndex = $lEndIndex \n";     
     last;     }
  }
  close FILE;
  return $retu_CommonTop;
}# End _getCommonTop

#***********************************************************************************
sub _getContextFileName{
  $retu_ContextFileName;
  my ($lDirAdminScript) =  @_;
  $lDirAdminScript = $lDirAdminScript . "admin/scripts";
  _debug("lDirAdminScript = $lDirAdminScript", true);
  if (!( -e "$lDirAdminScript")) {
     _debug("*** Ignore this message if this is NOT IAS_ORACLE_HOME ***\nNot Ebiz infra target. File not found: $lDirAdminScript.");       
     return;     
  }

  #Get all the dir under $COMMON_TOP/admin/scripts based on alst modified
  @lDirList = _dirFiles($lDirAdminScript);
  if (! defined @lDirList) {
    return -1;
  }

  #
  #Bugfix for bug 5875555.
  #First attempt to see if an entry that ends with _<hostname> exist. if 
  #yes, pick that entry. If such an entry does not exist, then only pick the 
  #first entry from the sorted list.
  #
  my $currhostexpr = "_" . _getHostName();
  @lDirListWithHost = grep(/$currhostexpr$/, @lDirList);
  if (defined @lDirListWithHost) {
    _debug("Identified directory that ends with $currhostexpr\n");
    $lContextFileprS = @lDirListWithHost[0];
  } else {
    _debug("Did not locate directory that ends with $currhostexpr\n");
    $lContextFileprS = @lDirList[0];
  }
  _debug("lContextFileprS: $lContextFileprS\n");

  # bug fix 5296732
  my $autcfgfile = "/adautocfg.sh";
  if (get_osType() eq 'WIN') {
    $autcfgfile = "/adautocfg.cmd";
  }
  $lContextFileprS = $lContextFileprS . $autcfgfile;

  if(!( -e "$lContextFileprS")){
     _debug("*** Ignore this message if this is NOT IAS_ORACLE_HOME ***\nNot Ebiz infra target. File not found: $lContextFileprS.");       
     return;     
  }
  
  _debug ( "lContextFileprS  = $lContextFileprS", true);
  if (!(-r $lContextFileprS)) {
    _error("Cannot access file '$lContextFileprS'.");
    return -1;
  }
  open(FILE, "$lContextFileprS");
  while(FILE){
     chomp($line = <FILE>);
     if (get_osType() eq 'WIN')
     {
       if(index($line,"context_file") >= 0)
       {
	 @tokens = split(/=/,$line);
         $retu_ContextFileName = $tokens[1];
         last;
       }
     }
     else
     {
       if(index($line,"CTX_FILE") >= 0){
         $lStartIndex = index($line,'"') + 1;   
         $lEndIndex = rindex($line,'"');
         $retu_ContextFileName = substr($line, $lStartIndex, ($lEndIndex - $lStartIndex));
         last;     
       }
    }
  }

  _debug ("retu_ContextFileName  = $retu_ContextFileName",true);

  return $retu_ContextFileName;
}

#***********************************************************************************
#This function returns the files in directories in descending sorted order
sub _dirFiles {
   my ($dir) = @_;
  if (!(-r $dir)) {
    _error("Cannot access dir '$dir'.");
    return -1;
  }
   opendir(dh, $dir);
   @lDirFiles =  
          grep {    -d     }       # choose only "dir" files
          map  { "$dir/$_" }       # create full paths
          grep {  !/^\./   }       # filter out dot files
          readdir(dh);             # read all entries
    close(dh);

    @lSortDirFiles = sort{(stat($b))[9]<=> (stat($a))[9]} @lDirFiles;           
}

#***********************************************************************************
# This function prints the target definition from files in $OH/appsutil/context/ dir
sub _printTargetsFrom_OH_APPSUTIL_CTX{
  my ($lmhdCtx) = "oracle_apps_inf._printTargetsFrom_OH_APPSUTIL_CTX";
  $retu_gotTragets = -1;

  # Search all the file which ends with thid dir
  my $lFileFilter = "_" . _getHostName() . "_ctx";
  my $lDirTop = $SC_VAR_ORACLE_HOME . "/appsutil/context";

  if (!(-r $lDirTop)) 
  {
    _debug("*** $lmhdCtx  Ignore this if this is NOT Shared IAS_ORACLE_HOME ***\n. Cannot access dir $lDirTop");
    return $retu_gotTragets;
  }

  opendir(dh, $lDirTop);
  @lDirFiles =  
          map  { "$lDirTop/$_" }            # create full paths
          grep {  m/$lFileFilter/   }   # get files ends with hostname_ctx
          #grep {  m/\.xml/   }          # get all files ends with .xml
          readdir(dh);                  # read all entries
  close(dh);

  _debug("$lmhdCtx lDirTop = $lDirTop ", true);    
  _debug("$lmhdCtx lFileFilter = $lFileFilter", true);    

  foreach $file (@lDirFiles) 
  {
     _debug("$lmhdCtx file to extract ctx = $file ", true);    
     my($lctxFileName1) = _extractContextFileName($file);
     _debug("$lmhdCtx ctx file = $lctxFileName1", true);    

     if (! defined $lctxFileName1 || !(-e $lctxFileName1))
     {
        _debug("$lmhdCtx  Could not locate $lctxFileName1");
     }
     else
     {
        # Load the context file.
        $lContextFileName = $lctxFileName1;
        $xmlObj = TXK::XML->new();
        $xmlObj->loadDocument( { "file" => $lctxFileName1} );
        _printAllEbsTargets($xmlObj);
        $retu_gotTragets = 0;
     } 
  }#foreach

#  _debug("$lmhdCtx Found files = $retu_gotTragets", true);    
  return $retu_gotTragets; 
}#_printTargetsFrom_OH_APPSUTIL_CTX

#**************************************************************************************
sub _printAllEbsTargets
{
    my $xmlObj = shift(@_);
    _printEbsInfraTarget($xmlObj);
    _printCmInfraTarget($xmlObj);
    _printReportTarget($xmlObj);
    _printDiscovererTarget($xmlObj);
    _printFormsListenerTarget($xmlObj);
}



#**************************************************************************************
sub _extractContextFileName{
  my ($lmhdCtx) = "oracle_apps_inf._extractContextFileName";

  my ($file) = @_;
  _debug("$lmhdCtx file = $file", true);    

  # Load the context file.
  my ($xmlObj) = TXK::XML->new();
  $xmlObj->loadDocument( { "file" => $file} );
  $retu =  $xmlObj->getOAVar('s_contextfile');
  chomp($retu);
  return $retu;
}



sub _getHostName
{ 
  $retu = readpipe("hostname"); 
  chomp($retu);
  return $retu;
}

sub _debug{
  my($strToPrint, $isLocalDebug) = @_;
  my $shallPrint = true;
  if(! $LOCAL_DEBUG_FLAG){
    $shallPrint = false;
  }
   
#  print "LOCAL_DEBUG=$LOCAL_DEBUG";
#  print "shallPrint=$shallPrint";


  if($shallPrint){

#    print "$strToPrint \n";
    EMD_PERL_DEBUG($strToPrint);
   }    
} #End debug

sub _warn{
  my $msg = shift(@_);
  EMD_PERL_WARN($msg);
} 

sub _error{
  my $msg = shift(@_);
  EMD_PERL_ERROR($msg);
} 

