#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/oracle_beehive.pl /main/4 2011/02/10 02:33:42 nkaushal Exp $
#
# oracle_beehive.pl
# 
# Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_beehive.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rgorle      03/08/09 - Creation 
# 
# Include Libraries

use XML::Parser;
use IPC::Open2;
use File::Spec;
use ecmAssoc;
use strict;
#------------------------------------------------------------------------
# Global variables
#------------------------------------------------------------------------
my ($emdRoot,$hostName,$crsHome) = @ARGV;
my $oraHome                 = $ENV{LL_ORACLE_HOME};
my $currentMidtierOH        = "";
my $file_sep                = "";
my $bean_name               = "beanName";
my $beehive_version         = "";
my $exit_status             = 0;
my $site_name               = "";
my $site_id                 = "";

# Variables introduced because of change of beehive version
my $beehiveHome = $oraHome ;
my $isWlsStack = 0; # 0 indicates oc4j and 1 indicates WLS


#Discovery LOG CATEGORY
my $LOG_CATEGORY = "BEEHIVE_DISCOVERY: ";

#parsing variables
my $target_type_map = { "Site" => [$ecmAssoc::BEEHIVE_SITE_TYPE, "Oracle_Site"],
                        "CalDAVService" => [$ecmAssoc::BEEHIVE_CALDAVAPP_TYPE, "CalDAV_Application"],
                        "CalDAVServiceInstance" => [$ecmAssoc::BEEHIVE_CALDAVINST_TYPE, "CalDAV_Instance"],
                        "ConferenceService" => [$ecmAssoc::BEEHIVE_CONFERENCEAPP_TYPE, "Conference_Application"],
                        "ConferenceServiceInstance" => [$ecmAssoc::BEEHIVE_CONFERENCEINST_TYPE, "Conference_Instance"],
                        "DeviceManagementService" => [$ecmAssoc::BEEHIVE_DEVICEMGMTAPP_TYPE, "DeviceManagement_Application"],
                        "DeviceManagementServiceInstance" => [$ecmAssoc::BEEHIVE_DEVICEMGMINST_TYPE, "DeviceManagement_Instance"],
                        "DiscussionsService" => [$ecmAssoc::BEEHIVE_DISCUSSIONSAPP_TYPE, "Discussions_Application"],
                        "DiscussionsServiceInstance" => [$ecmAssoc::BEEHIVE_DISCUSSIONSINST_TYPE, "Discussions_Instance"],
                        "EmailService" => [$ecmAssoc::BEEHIVE_EMAILAPP_TYPE, "Email_Application"],
                        "EmailServiceInstance" => [$ecmAssoc::BEEHIVE_EMAILINST_TYPE, "Email_Instance"],
                        "FtpService" => [$ecmAssoc::BEEHIVE_FTPAPP_TYPE, "FTP_Application"],
                        "FtpServiceInstance" => [$ecmAssoc::BEEHIVE_FTPINST_TYPE, "FTP_Instance"],
                        "ImService" => [$ecmAssoc::BEEHIVE_IMAPP_TYPE, "IM_Application"],
                        "ImServiceInstance" => [$ecmAssoc::BEEHIVE_IMINST_TYPE, "IM_Instance"],
                        "PresenceService" => [$ecmAssoc::BEEHIVE_PRESENCEAPP_TYPE, "Presence_Application"],
                        "PresenceServiceInstance" => [$ecmAssoc::BEEHIVE_PRESENCEINST_TYPE, "Presence_Instance"],
                        "PushMailService" => [$ecmAssoc::BEEHIVE_PUSHMAILAPP_TYPE, "PushMail_Application"],
                        "PushMailServiceInstance" => [$ecmAssoc::BEEHIVE_PUSHMAILINST_TYPE, "PushMail_Instance"],
                        "SearchService" => [$ecmAssoc::BEEHIVE_SEARCHAPP_TYPE, "Search_Application"],
                        "SearchServiceInstance" => [$ecmAssoc::BEEHIVE_SEARCHINST_TYPE, "Search_Instance"],
                        "TimeManagementService" => [$ecmAssoc::BEEHIVE_TIMEMGMTAPP_TYPE, "TimeManagement_Application"],
                        "TimeManagementServiceInstance" => [$ecmAssoc::BEEHIVE_TIMEMGMTINST_TYPE, "TimeManagement_Instance"],
                        "UserDirectoryService" => [$ecmAssoc::BEEHIVE_USERDIRECTORYAPP_TYPE, "UserDirectory_Application"],
                        "UserDirectoryServiceInstance" => [$ecmAssoc::BEEHIVE_USERDIRECTORYINST_TYPE, "UserDirectory_Instance"],
                        "VoiceMessageService" => [$ecmAssoc::BEEHIVE_VOICEMESSAGEAPP_TYPE, "VoiceMessage_Application"],
                        "VoiceMessageServiceInstance" => [$ecmAssoc::BEEHIVE_VOICEMESSAGEINST_TYPE, "VoiceMessage_Instance"],
                        "WebdavService" => [$ecmAssoc::BEEHIVE_WEBDAVAPP_TYPE, "WebDAV_Application"],
                        "WebdavServiceInstance" => [$ecmAssoc::BEEHIVE_WEBDAVINST_TYPE, "WebDAV_Instance"],
                        "WorkspacesService" => [$ecmAssoc::BEEHIVE_WORKSPACESAPP_TYPE, "Workspaces_Application"],
                        "WorkspacesServiceInstance" => [$ecmAssoc::BEEHIVE_WORKSPACESINST_TYPE, "Workspaces_Instance"],
                        "XmppService" => [$ecmAssoc::BEEHIVE_XMPPAPP_TYPE, "XMPP_Application"],
                        "XmppServiceInstance" => [$ecmAssoc::BEEHIVE_XMPPINST_TYPE, "XMPP_Instance"]
                      };
my $oc4j_bean_prop_map = {};

# Exit codes
my $parse_error_code        = "";
my $parse_error_msg        = "";

#------------------------------------------------------------------------
# Main Logic
#------------------------------------------------------------------------
parseCommandLine();
getBeehiveHome();
createTargets();
#Exit program with the appropriate return status
exit($exit_status);

#------------------------------------------------------------------------
# Parses the command line parameters  and updates the global variables
#------------------------------------------------------------------------
sub parseCommandLine
{
    my $warn_msg = "";
    if ((!defined $hostName) || (!defined $emdRoot)) {
        $warn_msg = getWarningMsg("101","emdRoot or hostName is not provided in the arguments.");
#        EMD_PERL_ERROR("$LOG_CATEGORY $warn_msg");
        exit($exit_status);
    }
    
    require "$emdRoot/sysman/admin/scripts/emd_common.pl";

    $oraHome = (defined $oraHome) ? trim($oraHome) : "";
    if($oraHome eq "")
    {
        $warn_msg = getWarningMsg("101","LL_ORACLE_HOME not set.");
        EMD_PERL_ERROR("$LOG_CATEGORY $warn_msg");
        exit($exit_status);
    }

    my $script_file = $emdRoot."/sysman/admin/scripts/beehive/bhv_config.pl";
    #replace \ with / in the input file
    $script_file =~ s/\\/\//g;
    #replace /+ with / 
    $script_file=~ s/\/+/\//g;

    if (($^O =~ "Windows") || ($^O =~ "MSWin32"))  # windows platforms
    {
        # For Windows change the path  from / to \
        $script_file=~ s/\//\\\\/g;
        $file_sep = "\\\\";
    } else {
        $file_sep = "/";
    }
    require "$script_file";
}

#---------------------------------------------------------------------------------------------
# This funciton verifies whether its OC4J stack or Weblogic_j2eeserver stack and fetches the Beehive Home
sub getBeehiveHome{
	my $path = $oraHome;
	my $volume = "";
	my $directories ="";
	my $endfile = "";
	my $line = "";
	my $bhv_path="";    
	my $isBeehiveHome = 0 ; # 0 equals No Beehive Home 
	
	
	($volume,$directories,$endfile) = File::Spec->splitpath( $path );

        #Fetching beehive instance home from .home.properties file in the Middleware home
        my $file = $volume.$directories.".home.properties";
        my $file_exists = open(HANDLE, $file );

	if (($^O =~ "Windows") || ($^O =~ "MSWin32")){
		$path = Win32::GetLongPathName($path);
	}
	
	if($file_exists){
		
		while( $line = <HANDLE> ){
			chomp($line); 
			my @values = split('=', $line);
			if($values[0] eq 'BSH.home'){
				
				if (($^O =~ "Windows") || ($^O =~ "MSWin32"))  # windows platforms
				{
					# For Windows change the path  from / to \
					$values[1] =~ s/\//\\/g;
					# replace \: with \
					$values[1] =~ s/\\:/:/;
					$values[1] =~ s/\\+/\\/g;
							
       
				}else{
					#replace \ with /
					$values[1] =~ s/\\/\//g;
					#replace /+ with / 
					$values[1] =~ s/\/+/\//g;
				}
                   	 	chop($values[1]);
                      		$isBeehiveHome = 1;
                        	if(lc $values[1] ne lc $path){
                              	 	exit 0;
							
                          	 }
                        }
			if( $values[0] eq  'BIH.home'){
				$beehiveHome = $values[1];
				$isWlsStack = 1;
				last;
			}
		}
		if(!($isBeehiveHome && $isWlsStack)){
                       my $warn_msg = "Skipping Beehive discovery as Beehive Home or Beehive Instance Home are not correctly set in .home.properties file";
                       EMD_PERL_ERROR("$LOG_CATEGORY $warn_msg");
                       exit($exit_status);
               }

	}

	 



	
		
		#if(!($isBeehiveHome && $isWlsStack)){
		#	my $warn_msg = "Skipping Beehive discovery as Beehive Home or Beehive Instance Home are not correctly set in .home.properties file";
        	#	EMD_PERL_ERROR("$LOG_CATEGORY $warn_msg");
		#	exit($exit_status);
	#	}

    

	

}

#---------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------
sub createTargets 
{
    my $parser="";
	my $full_output="";
	
	#Incase of WLS beehive_ocm_wls.xml will be used for discovering targets 
	#Incase of OC4J beehive_r1.xml will be used for discovering targets 
	if($isWlsStack){
	
		 $full_output = getOutputTargets($emdRoot."/sysman/admin/scripts/beehive/beehive_ocm_wls.xml", "", "", $beehiveHome);
		 $parser = new XML::Parser(Handlers => {Init => \&handle_Init, Start => \&handle_wlsStart,End => \&handle_wlsEnd, Final => \&handle_Final});
	
	}else{
		 
		 $full_output = getOutputTargets($emdRoot."/sysman/admin/scripts/beehive/beehive_r1.xml", "", "", $beehiveHome);
		 $parser = new XML::Parser(Handlers => {Init => \&handle_Init, Start => \&handle_Start,End => \&handle_End, Final => \&handle_Final});
		 
	}
    $full_output =~ m/<DiscoveryResult>([\S*\s*]*)<\/DiscoveryResult>/g;
    
    my $command_output = (defined $1) ? trim($1) : "";
    if($command_output ne "")
    {
        $command_output = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DiscoveryResult>\n".$command_output."\n<\/DiscoveryResult>\n";
    }
    
    
    my $targetsNode;
    if($command_output ne ""){
        my $rootNode = $parser->parsestring($command_output);
        if (($rootNode eq "") || (ref($rootNode) ne 'HASH')) {
            my $warn_msg = getWarningMsg("110","No Targets Present");
            EMD_PERL_ERROR("$LOG_CATEGORY $warn_msg");
            exit($exit_status);
        }

        $targetsNode = $rootNode->{"ChildTargets"};
    }else{
        my $warn_msg = getWarningMsg("110","No Targets Present");
        EMD_PERL_ERROR("$LOG_CATEGORY $warn_msg");
        exit($exit_status);
    }

    # start the output array
    my @processedLines;

    if($parse_error_code ne "") {
        my $warn_msg = getWarningMsg($parse_error_code, $parse_error_msg);
        EMD_PERL_ERROR("$LOG_CATEGORY $warn_msg");
        exit($exit_status);
    } elsif($site_name eq "") {
        my $warn_msg = getWarningMsg("110","No Targets Present");
        EMD_PERL_ERROR("$LOG_CATEGORY $warn_msg");
        exit($exit_status);
    } else {
        for (my $i = 0; $i <= $#$targetsNode; $i++) {
            push(@processedLines, parseTargetNode($targetsNode->[$i]));
        }
    }
    
    print @processedLines;
}
#---------------------------------------------------------------------------------------------
sub parseTargetNode
{
    (my $target_node) = @_;
    my @processedLines;
    my $targetType = "";
    my $typeDisplayName = "";
    my $targetName = "";
    my $displayName = "";
    my $uniqueId = "";
    
    my $beanType = $target_node->{"type"};
    my $properties = $target_node->{"Properties"};
    my $childTargets = $target_node->{"ChildTargets"};

    my $oc4j_props = "";
    
    $properties->{"siteName"} = $site_name;
    $properties->{"version"} = $beehive_version;
    
    $targetType = (defined $target_type_map->{$beanType}->[0]) ? trim($target_type_map->{$beanType}->[0]) : "";
    $typeDisplayName = (defined $target_type_map->{$beanType}->[1] ) ? trim($target_type_map->{$beanType}->[1]) : "";

    if($targetType eq "") {
        return @processedLines;
    }

    if($targetType=~ m/inst$/) {
        my $beanName = delete $properties->{"managedOC4JBeanName"};
        $oc4j_props = $oc4j_bean_prop_map->{$beanName};        
        $targetName = $displayName = $oc4j_props->{"asName"}."_".$oc4j_props->{"oc4jName"}."_".$typeDisplayName;
        
        my $isCurrentMidtier = $oc4j_props->{"isCurrentMidtier"};
        if($isCurrentMidtier ne "true") {
            return @processedLines;
        }
    }elsif($targetType=~ m/app$/) {
        $targetName = $displayName = $site_name."_".$typeDisplayName;
        $properties->{"OracleHome"} = $currentMidtierOH;
        $properties->{"OCM_CROSS_HOST"} = "TRUE";
        $properties->{"MULTIPLEXED"} = "TRUE";
        
        $uniqueId = $site_name."_".$site_id;
    }else {
        $targetName = $displayName = $site_name;
        $properties->{"OracleHome"} = $currentMidtierOH;
        $properties->{"OCM_CROSS_HOST"} = "TRUE";
        $properties->{"MULTIPLEXED"} = "TRUE";
        
        $uniqueId = $site_name."_".$site_id;
    }

    push(@processedLines, createTargetTypeXMLTag($targetType, $targetName, $displayName, $uniqueId));
    foreach my $key (keys %$properties) {
        push(@processedLines, createTargetPropertyXMLTag($key,$properties->{$key}));
    }
    
    if($oc4j_props ne "") {
        foreach my $key (keys %$oc4j_props) {
            if($key ne "isCurrentMidtier") {
                push(@processedLines, createTargetPropertyXMLTag($key,$oc4j_props->{$key}));
            }
        }
    }
    
    push(@processedLines,getTargetEndTag());

    for (my $i = 0; $i <= $#$childTargets; $i++) {
           push(@processedLines, parseTargetNode($childTargets->[$i]));
    }
    
    return @processedLines;
}
#---------------------------------------------------------------------------------------------
sub createTargetTypeXMLTag
{
  my ($targetType, $targetName, $displayName, $uniqueId) = @_;
  my $targetTypeTag = "<Target TYPE=\"$targetType\" NAME=\"$targetName\"";
  if ($displayName ne "")
  {
     $targetTypeTag = "$targetTypeTag DISPLAY_NAME=\"$displayName\"";
  }
  
  if ($uniqueId ne "")
  {
     $targetTypeTag = "$targetTypeTag UNIQUE_ID=\"$uniqueId\"";
  }

  $targetTypeTag = "$targetTypeTag>\n";
  return $targetTypeTag;
}
#---------------------------------------------------------------------------------------------
sub getTargetEndTag
{
  return "</Target>\n";
}
#---------------------------------------------------------------------------------------------
sub createTargetPropertyXMLTag
{
  my ($propName, $propValue) = @_;
  my $xmlstring = "\t<Property NAME=\"$propName\" VALUE=\"$propValue\"/>\n";
  return $xmlstring;
}
#---------------------------------------------------------------------------------------------
sub getWarningMsg
{
    (my $code, my $msg) = @_;
    my $warnmsg = "<DiscoveryWarning DISCOVERY_SCRIPT=\"$code\">$msg</DiscoveryWarning>";
    return $warnmsg;
}
#---------------------------------------------------------------------------------------------
sub handle_Init {
    my $expat = shift;
    $expat->{Targets} = [];
    $expat->{CurTarget} = ();
    $expat->{CurTarget}->{"ChildTargets"} = [];
}
#---------------------------------------------------------------------------------------------
sub handle_Start {
    (my $expat, my $tag, my %atts) = @_;
    if($tag eq "Target") {
        push @{ $expat->{Targets} }, $expat->{CurTarget};
        $expat->{CurTarget} = ();
        
        my $beanTypeValue = (defined %atts->{"beanType"} ) ? trim(%atts->{"beanType"}) : "";
        $expat->{CurTarget}->{"type"} = $beanTypeValue;
        if($beanTypeValue ne "ManagedOc4j") {
            $expat->{CurTarget}->{"type"} = $beanTypeValue;
            $expat->{CurTarget}->{"ChildTargets"} = [];
        }
        $expat->{CurTarget}->{"Properties"} = ();
    }elsif($tag eq "Property") {
        foreach (keys %atts) {
            my $key = trim($_);
            $expat->{CurTarget}->{"Properties"}->{$key} = (defined %atts->{$_} ) ? trim(%atts->{$_}) : "";
        }
    }elsif($tag eq "Error") {
        $parse_error_code = (defined %atts->{"code"} ) ? trim(%atts->{"code"}) : "";
        $parse_error_msg = (defined %atts->{"message"} ) ? trim(%atts->{"message"}) : "";
    }
}
#---------------------------------------------------------------------------------------------
sub handle_End {
    (my $expat,my $tag) = @_;
    if($tag eq "Target") {
        if($expat->{CurTarget}->{"type"} eq "ManagedOc4j") {
            if($expat->{CurMidtierOH} eq "") {
                if($expat->{CurTarget}->{"Properties"}->{"isCurrentMidtier"} eq "true") {
                    $expat->{CurMidtierOH} = $expat->{CurTarget}->{"Properties"}->{"OracleHome"};
                }
            }
            
            my $beanName = delete $expat->{CurTarget}->{"Properties"}->{"beanName"};
            $oc4j_bean_prop_map->{$beanName} = delete $expat->{CurTarget}->{"Properties"};            
            delete $expat->{CurTarget};
            $expat->{CurTarget} = pop @{ $expat->{Targets} };
        } else {
            my $target = $expat->{CurTarget};
            $expat->{CurTarget} = pop @{ $expat->{Targets} };
            push @{ $expat->{CurTarget}->{"ChildTargets"} }, $target;

            if($target->{"type"} eq "Site") {
                $site_name = (defined $target->{"Properties"}->{"siteName"}) ? (delete $target->{"Properties"}->{"siteName"}) : "";
                $site_name =~ s/\s+/\_/g;
                $site_id = (defined $target->{"Properties"}->{"beanName"}) ? ($target->{"Properties"}->{"beanName"}) : "";
                $site_id =~ s/\s+/\_/g;
                $beehive_version = (defined $target->{"Properties"}->{"Version"}) ? (delete $target->{"Properties"}->{"Version"}) : "";
            }
        }
    }
}
#---------------------------------------------------------------------------------------------
sub handle_Final {
    my $expat = shift;
    $currentMidtierOH = delete $expat->{CurMidtierOH};
    delete $expat->{Targets};
    $expat->{CurTarget};
}
#---------------------------------------------------------------------------------------------
sub trim 
{
    my @out = @_;
    for(@out) 
    {
        s/^\s+//;
        s/\s+$//;
    }
    return wantarray ? @out : $out[0];
}

#---------------------------------------------------------------------------------------------
# Handlers for WLS target

sub handle_wlsStart {
    (my $expat, my $tag, my %atts) = @_;
    if($tag eq "Target") {
        push @{ $expat->{Targets} }, $expat->{CurTarget};
        $expat->{CurTarget} = ();
        
        my $beanTypeValue = (defined %atts->{"beanType"} ) ? trim(%atts->{"beanType"}) : "";
        $expat->{CurTarget}->{"type"} = $beanTypeValue;
        if(($beanTypeValue ne "WlsServer")) {
            $expat->{CurTarget}->{"type"} = $beanTypeValue;
            $expat->{CurTarget}->{"ChildTargets"} = [];
        }
        $expat->{CurTarget}->{"Properties"} = ();
    }elsif($tag eq "Property") {
        foreach (keys %atts) {
            my $key = trim($_);
            $expat->{CurTarget}->{"Properties"}->{$key} = (defined %atts->{$_} ) ? trim(%atts->{$_}) : "";
        }
    }elsif($tag eq "Error") {
        $parse_error_code = (defined %atts->{"code"} ) ? trim(%atts->{"code"}) : "";
        $parse_error_msg = (defined %atts->{"message"} ) ? trim(%atts->{"message"}) : "";
    }
}

sub handle_wlsEnd {
    (my $expat,my $tag) = @_;
    if($tag eq "Target") {
        if(($expat->{CurTarget}->{"type"} eq "WlsServer")) {
            if($expat->{CurMidtierOH} eq "") {
                if($expat->{CurTarget}->{"Properties"}->{"isCurrentMidtier"} eq "true") {
                    $expat->{CurMidtierOH} = $expat->{CurTarget}->{"Properties"}->{"OracleHome"};
                }
           }
     	

            
            my $beanName = delete $expat->{CurTarget}->{"Properties"}->{"beanName"};
            $oc4j_bean_prop_map->{$beanName} = delete $expat->{CurTarget}->{"Properties"};            
            delete $expat->{CurTarget};
            $expat->{CurTarget} = pop @{ $expat->{Targets} };
        } else {
            my $target = $expat->{CurTarget};
            $expat->{CurTarget} = pop @{ $expat->{Targets} };
            push @{ $expat->{CurTarget}->{"ChildTargets"} }, $target;

            if($target->{"type"} eq "Site") {
                $site_name = (defined $target->{"Properties"}->{"siteName"}) ? (delete $target->{"Properties"}->{"siteName"}) : "";
                $site_name =~ s/\s+/\_/g;
                $site_id = (defined $target->{"Properties"}->{"beanName"}) ? ($target->{"Properties"}->{"beanName"}) : "";
                $site_id =~ s/\s+/\_/g;
                $beehive_version = (defined $target->{"Properties"}->{"Version"}) ? (delete $target->{"Properties"}->{"Version"}) : "";
            }
        }
    }
}
