#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/oracle_bi_cc_discover.pl /main/6 2012/06/14 11:40:59 fmorshed Exp $
#
# oracle_bi_cc_discover.pl
# 
# Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_bi_cc_discover.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    01/19/12 - With advent of central collector, set emdroot, 
#                           and oracle home properly.
#    ckannusa    04/18/07 - biutil Package removed
#    ckannusa    04/04/07 - Modify Discovery condition
#    aime        03/21/07 - 
#    ckannusa    01/11/07 - 
#    ssaivam     01/02/07 - Creation
# 
use iniparser;
use biutil;
use File::Basename;
use hostOSD;
my ($emdroot, $hostName) = @ARGV;
my $oracleHome = $ENV{'ORACLE_HOME'};
my $version = getVersion($oracleHome);
my $targetType = $ecmAssoc::ORACLE_BI_CC;
my $relPath = getConfigFilePath($oracleHome,$targetType);
my $commonFile = "/setup/common.sh";
$commonFile =sprintf("%s%s", $oracleHome ,$commonFile);
my $SAROOTDIR,$SADATADIR;
my $file;
my $confName = "CLUSTER";
my $attribNameEnable = "ENABLE_CONTROLLER";
my $attribNamePC = "PRIMARY_CONTROLLER";
my $attrbDefFilePath ="/systemsmanagement/resources/attribute-definitions.xml";
$attrbDefFilePath = sprintf("%s%s", $oracleHome, $attrbDefFilePath);
if (!(-f $attrbDefFilePath))
{
	$attrbDefFilePath=" ";
}

my $os=get_osType();
if ($os eq 'WIN')
{
	    ($SAROOTDIR,$SADATADIR)=getWinEnvVariables();

}
else
{
    if (-f $commonFile)
    {
            ($SAROOTDIR,$SADATADIR)=iniparser::getCommonScriptVal($commonFile,$version);
    }
}
$file = sprintf("%s%s", $oracleHome, $relPath);
if (-f $file)
{
    	my $name = sprintf("%s\.%s\_%s",$oracleHome,$hostName,"BI_CC");
	$lines=&getContent($file);
	$lines =~s/\/\/(.*)//g;
    	$lines =~s/\s/ /g;
    	my (%confhash)=iniparser::getConfigAttribs($lines,$confName);
	#create a target only if enable_controller is yes and 
	#primary controller matches the host
    	my $attribValEnable=$confhash{$attribNameEnable};
    	my $attribValPC=$confhash{$attribNamePC};
	$attribValPC=~ s/"//g;
	if((lc($attribValPC) eq "local") or (lc($attribValPC) eq "localhost"))
	{
		$attribValPC=$hostName;
	}
	$attribValPC=&hostOSD::getHostNameForIP($attribValPC);
	if ( (length($attribValPC)!=0) and (lc($attribValEnable) eq "yes") and (($attribValPC=~/^$hostName/) or ($hostName=~/^$attribValPC/) ))
    	{
	        print " <Target TYPE=\"$targetType\" NAME=\"$name\">\n";
	        print "     <Property NAME=\"OracleHome\" VALUE=\"$oracleHome\"/>\n";
	        print "     <Property NAME=\"ConfigFile\" VALUE=\"$file\"/>\n";
	        print "     <Property NAME=\"AttributeDefFile\" VALUE=\"$attrbDefFilePath\"/>\n";
	        print "     <Property NAME=\"Host\" VALUE=\"$hostName\"/>\n";
	        print "     <Property NAME=\"SAROOTDIR\" VALUE=\"$SAROOTDIR\"/>\n";
	        print "     <Property NAME=\"SADATADIR\" VALUE=\"$SADATADIR\"/>\n";
	        print " </Target>\n";
    	}
}
