#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/oracle_bi_dac_discover.pl /main/6 2012/06/14 11:40:59 fmorshed Exp $
#
# oracle_bi_dac_discover.pl
# 
# Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_bi_dac_discover.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    01/19/12 - With advent of central collector, set emdroot, 
#                           and oracle home properly.
#    ckannusa    04/18/07 - biutil Package removed
#    ckannusa    04/09/07 - add dac.properties file
#    aime        03/26/07 - 
#    ckannusa    03/01/07 - Dac server discovery
#    ckannusa    03/01/07 - Creation
#
use File::Basename;
use iniparser;
use biutil;
my ($emdroot, $hostName) = @ARGV;
my $oracleHome = $ENV{'ORACLE_HOME'};
my $version = getVersion($oracleHome);
my $targetType = $ecmAssoc::ORACLE_BI_DAC;
my $relPath  = "/DAC/conf/server.properties";
my $relPathETLFile = "/DAC/conf/EtlSummary.properties";
my $relPathDACFile = "/DAC/dac.properties";
my $commonFile = "/setup/common.sh";
my $attrbDefFilePath ="/systemsmanagement/resources/attribute-definitions.xml";
$commonFile =sprintf("%s%s", $oracleHome ,$commonFile);
my $SAROOTDIR,$SADATADIR;

$attrbDefFilePath = sprintf("%s%s", $oracleHome, $attrbDefFilePath);

my $os=get_osType();
if ($os eq 'WIN')
{
	    ($SAROOTDIR,$SADATADIR)=getWinEnvVariables();

}
else
{
    if (-f $commonFile)
    {
            ($SAROOTDIR,$SADATADIR)=iniparser::getCommonScriptVal($commonFile,$version);
    }
}

my $file = sprintf("%s%s", $oracleHome, $relPath);
my $etlFile = sprintf("%s%s", $oracleHome ,$relPathETLFile);
my $dacFile = sprintf("%s%s", $oracleHome ,$relPathDACFile);
if (!(-f $etlFile))
{
	$etlFile=" ";
}
if (!(-f $dacFile))
{
	$dacFile=" ";
}

if (-f $file)
{
	my %defaulthash = getPropValues($file);
    	my $portNumber=$defaulthash{"port"};
    	my $host=$defaulthash{"host"};
	if ( (length($portNumber)!=0) and (length($host)!=0) )
	{
	        my $name = sprintf("%s\.%s\_%s", $oracleHome,$hostName,"BI_DAC");
	        print " <Target TYPE=\"$targetType\" NAME=\"$name\">\n";
	        print "     <Property NAME=\"OracleHome\" VALUE=\"$oracleHome\"/>\n";
	        print "     <Property NAME=\"ConfigFile\" VALUE=\"$file\"/>\n";
	        print "     <Property NAME=\"ETLSummaryFile\" VALUE=\"$etlFile\"/>\n";
		print "     <Property NAME=\"DACPropertyFile\" VALUE=\"$dacFile\"/>\n";	
	        print "     <Property NAME=\"Host\" VALUE=\"$hostName\"/>\n";
	        print "     <Property NAME=\"SAROOTDIR\" VALUE=\"$SAROOTDIR\"/>\n";
	        print "     <Property NAME=\"SADATADIR\" VALUE=\"$SADATADIR\"/>\n";
	        print " </Target>\n";
	}
}

 
