#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/oracle_bi_ps_discover.pl /main/5 2012/06/14 11:40:59 fmorshed Exp $
#
# oracle_bi_ps_discover.pl
# 
# Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_bi_ps_discover.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    01/19/12 - With advent of central collector, set emdroot, 
#                           and oracle home properly.
#    ckannusa    04/18/07 - biutil Package removed
#    aime        03/21/07 - 
#    ckannusa    01/11/07 - 
#    ssaivam     01/02/07 - Creation
# 
use biutil;
use File::Basename;
use iniparser;
my ($emdroot, $hostName) = @ARGV;
my $oracleHome = $ENV{'ORACLE_HOME'};
my $version = getVersion($oracleHome);
my $targetType = $ecmAssoc::ORACLE_BI_PS;
my $relPath  = "/web/config/instanceconfig.xml";
my $commonFile = "/setup/common.sh";
my $attrbDefFilePath ="/systemsmanagement/resources/attribute-definitions.xml";
$commonFile =sprintf("%s%s", $oracleHome ,$commonFile);
$attrbDefFilePath = sprintf("%s%s", $oracleHome, $attrbDefFilePath);
if (!(-f $attrbDefFilePath))
{
	$attrbDefFilePath=" ";
}

my $SAROOTDIR,$SADATADIR;
my $os=get_osType();
if ($os eq 'WIN')
{
	($SAROOTDIR,$SADATADIR)=getWinEnvVariables();

}
else
{
    if (-f $commonFile)
    {
            ($SAROOTDIR,$SADATADIR)=iniparser::getCommonScriptVal($commonFile,$version);
    }
}

my $file = sprintf("%s%s", $SADATADIR, $relPath);
if (-f $file)
{
    my $name = sprintf("%s\.%s\_%s", $oracleHome, $hostName,"BI_PS");
    print " <Target TYPE=\"$targetType\" NAME=\"$name\">\n";
    print "     <Property NAME=\"OracleHome\" VALUE=\"$oracleHome\"/>\n";
    print "     <Property NAME=\"ConfigFile\" VALUE=\"$file\"/>\n";
    print "     <Property NAME=\"AttributeDefFile\" VALUE=\"$attrbDefFilePath\"/>\n";
    print "     <Property NAME=\"Host\" VALUE=\"$hostName\"/>\n";
    print "     <Property NAME=\"SAROOTDIR\" VALUE=\"$SAROOTDIR\"/>\n";
    print "     <Property NAME=\"SADATADIR\" VALUE=\"$SADATADIR\"/>\n";
    print " </Target>\n";
}
