#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/oracle_bi_sch_discover.pl /main/6 2012/06/14 11:40:59 fmorshed Exp $
#
# oracle_bi_sch_discover.pl
# 
# Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_bi_sch_discover.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    01/19/12 - With advent of central collector, set emdroot, 
#                           and oracle home properly.
#    ckannusa    04/18/07 - biutil Package removed
#    ckannusa    04/09/07 - Add DSN to Discovery
#    aime        03/22/07 - 
#    ckannusa    02/13/07 - Discovery Scripts for Scheduler
#    ckannusa    02/13/07 - Creation
#
use ias::simpleXPath;
use File::Basename;
use iniparser;
use biutil;
my ($emdroot, $hostName) = @ARGV;
my $oracleHome = $ENV{'ORACLE_HOME'};
my $version = getVersion($oracleHome);
my $targetType = "oracle_bi_sch";
my $relPath  = "/scheduler/config/instanceconfig.xml";
my $commonFile = "/setup/common.sh";
my $attrbDefFilePath ="/systemsmanagement/resources/attribute-definitions.xml";
$commonFile =sprintf("%s%s", $oracleHome ,$commonFile);
my $SAROOTDIR,$SADATADIR;
$attrbDefFilePath = sprintf("%s%s", $oracleHome, $attrbDefFilePath);
if (!(-f $attrbDefFilePath))
{
	$attrbDefFilePath=" ";
}

my $os=get_osType();
if ($os eq 'WIN')
{
	($SAROOTDIR,$SADATADIR)=getWinEnvVariables();

}
else
{
    if (-f $commonFile)
    {
            ($SAROOTDIR,$SADATADIR)=iniparser::getCommonScriptVal($commonFile,$version);
    }
}

my $file = sprintf("%s%s", $SADATADIR, $relPath);
if (-f $file)
{

        my $schConfigQuery="scheduler/ServerInstance/DSN";
        my @schParams = simpleXPathQueryForText($file,$schConfigQuery);
        my $dsn=trim($schParams[0]);
	if (length($dsn)!=0)
	{
	        my $name = sprintf("%s\.%s\_%s",$oracleHome, $hostName,"BI_SCH");
	        print " <Target TYPE=\"$targetType\" NAME=\"$name\">\n";
	        print "     <Property NAME=\"OracleHome\" VALUE=\"$oracleHome\"/>\n";
	        print "     <Property NAME=\"ConfigFile\" VALUE=\"$file\"/>\n";
	        print "     <Property NAME=\"AttributeDefFile\" VALUE=\"$attrbDefFilePath\"/>\n";
	        print "     <Property NAME=\"Host\" VALUE=\"$hostName\"/>\n";
	        print "     <Property NAME=\"SAROOTDIR\" VALUE=\"$SAROOTDIR\"/>\n";
	        print "     <Property NAME=\"SADATADIR\" VALUE=\"$SADATADIR\"/>\n";
	        print " </Target>\n";
	}
}
elsif (($version=~/^7.8/) and ($os eq 'WIN'))
{
	$file= " ";
	my $env = getSchConfigFromRegistry("ServerInstance","DSN");
	if (length($env)!=0)
	{
        	my $name = sprintf("%s\.%s\_%s",$oracleHome, $hostName,"BI_SCH");
	        print " <Target TYPE=\"$targetType\" NAME=\"$name\">\n";
	        print "         <Property NAME=\"OracleHome\" VALUE=\"$oracleHome\"/>\n";
	        print "         <Property NAME=\"ConfigFile\" VALUE=\"$file\"/>\n";
	        print "         <Property NAME=\"AttributeDefFile\" VALUE=\"$attrbDefFilePath\"/>\n";
	        print "         <Property NAME=\"Host\" VALUE=\"$hostName\"/>\n";
	        print "         <Property NAME=\"SAROOTDIR\" VALUE=\"$SAROOTDIR\"/>\n";
        	print "         <Property NAME=\"SADATADIR\" VALUE=\"$SADATADIR\"/>\n";
	        print " </Target>\n";
	}
}
 
