#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/oracle_cell_discover.pl /main/7 2012/06/14 11:40:59 fmorshed Exp $
#
# oracle_cell_discover.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_cell_discover.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    04/10/12 - Call getStateDirs instead of figuring it out.  In presence
#                           of designated collector the algorithm is more complicated.
#    ckalivar    11/04/11 - ER 12688918: discover host targets for each cell
#    imunusam    10/27/11 - add exdata grid target
#    imunusam    07/05/11 - To move common code getAllLLFiles to ccr_common.pl
#    imunusam    06/23/11 - To add DBMACHINE target in discovery script
#    nmittal     06/06/11 - Creation
# 

use Config;
use Cwd;
use File::Basename;
use File::Copy;
use File::Spec;
use File::stat();
use Sys::Hostname;
use Net::Domain qw(hostname hostfqdn hostdomain domainname);

my ($emdRoot,$hostName,$crsHome) = @ARGV;
$ENV{EMDROOT} = $emdRoot;

require "$emdRoot/sysman/admin/scripts/semd_common.pl";
require "$emdRoot/sysman/admin/scripts/db/db_common.pl";
require "$emdRoot/sysman/admin/scripts/ccr/ccr_common.pl";
require "$emdRoot/sysman/admin/scripts/db/net/listenerUtil.pl";
require "$emdRoot/sysman/admin/discover/utl/oracledbUtl.pl";
require "$emdRoot/sysman/admin/discover/utl/initParameterFileUtl.pl";
require "$emdRoot/sysman/admin/scripts/emd_common.pl";

$OSNAME = get_osType();

#Discovery LOG CATEGORY
$LOG_CATEGORY = "CELL_DISCOVERY: ";

EMD_PERL_INFO("$LOG_CATEGORY ***** Start of Oracle Exadata Cell Discovery***");
#The Live link agent home is defined only if 
#discovery is called by the live link agent
#During this, discover only targets for this agent home
my $llOracleHome;
my %myllCELLTargetNames;


# host name and IP address retrieved from LL file and from perl environment
my ($dbHostName,$dbSHortHostName,$dbIpAddress);
my ($perlHostName,$perlShortHostName,$perlIpAddr);

$perlHostName = lc(hostname());
($perlShortHostName) = split /\./, $perlHostName;
$perlIpAddr = join(".",unpack("C4",(gethostbyname($perlHostName))[4]));

if (defined $ENV{LL_ORACLE_HOME} && -d  $ENV{LL_ORACLE_HOME})
{
  $llOracleHome = $ENV{LL_ORACLE_HOME};
  my %allLLFiles;
  my %allCCRFiles;

  if (defined $ENV{LL_ORACLE_HOME} && -d  $ENV{LL_ORACLE_HOME})
  {
      $llOracleHome = $ENV{LL_ORACLE_HOME};
      my %allLLFiles=getAllLLfiles($emdRoot,$hostName);

      # Now walk the list of all config files we found.
      foreach $fullFilePath (values %allLLFiles)
      {
        EMD_PERL_INFO("$LOG_CATEGORY Handle $fullFilePath");
        my ($volume,$directories,$file) = File::Spec->splitpath($fullFilePath);
        if ( $file =~ /(.*)(\.ll$|\.ccr$)/)
        {
            ########################### call Cell discovery #########
            my @llCellTargetNames = discoverCellTargetsFromll($fullFilePath);
            EMD_PERL_INFO(" target name is: $llCellTargetNames");
            ########################### end Cell discovery #########
        } #end of going through .ll file
      }
  }

}

##############################################################################
##                 Start of Exadata Discovery Functions                          #
##############################################################################

#discover the cells from a config file
sub discoverCellTargetsFromll
{  
  my ($configFile) = @_;
  EMD_PERL_DEBUG("CELL Exadata target from LL file, configFile is $configFile");
  #may have multiple cells used by one db
  my @cellTargets = getCellTargetsInfoFromDBll($configFile); 
  EMD_PERL_DEBUG("CELL Exadata target from LL file, printing exadata target");

  my %llCellTargetNames;
  my $cellHostName;
  foreach $cellTarget (@cellTargets)
  {
      my $pos=0;
      my $cellIp = '';
      my $cellName = '';
      my $cellId = '';
      my $cellVersion = '';
      my $releaseVersion = '';
      my @tokens=split(/\|/, $cellTarget);
      foreach $token (@tokens)
      {
          if ($pos == 0)
          {
              $cellIp = $token;
          }
          if ($pos == 1 )
          {
              $cellName = $token;
          }
          if ($pos == 2)
          {
              $cellId = $token;
          }
          if ($pos == 3)
          {
              $cellVersion = $token;
          }
          if ($pos == 4)
          {
              $releaseVersion = $token;
          }
          $pos =$pos+1 ;
      }
      $releaseVersion = getReleaseVersion($cellVersion, $releaseVersion);
      my $myTargetName = $cellName.'|'.$cellId;
      $cellHostName = $cellName.".".hostdomain();
      $llCellTargetNames{$cellId} = $myTargetName;
  #check if the id existing
  if (!exists $myllCELLTargetNames{$cellId})
  {
      $myllCELLTargetNames{$cellId} = $myTargetName;
print <<__END;
  <Target TYPE="oracle_cell" NAME="$cellName" UNIQUE_ID="$cellId" ON_HOST="$cellHostName">
  <Property NAME="OcmProxyOracleHome" VALUE="/opt/oracle/cell"/>
  <Property NAME="ConfigFile" VALUE="$configFile"/>
  <Property NAME="IP" VALUE="$cellIp"/>
  <Property NAME="ID" VALUE="$cellId"/>
  <Property NAME="version_value" VALUE="$releaseVersion"/>
  <Property NAME="OCM_CROSS_HOST" VALUE="TRUE"/>
__END

      my $timestamp = getCollectionTimestamp($configFile);
      if (defined $timestamp && $timestamp ne "")
      {
print <<__END;
  <Property NAME="CCR_COLLECTION_TIMESTAMP_OVERRIDE" VALUE="$timestamp"/>
__END
  }
  my $dbcharset = getConfigProperty($configFile, "NLS_CHARACTERSET");
  if (defined $dbcharset && $dbcharset ne "") {
      print <<__END;
  <Property NAME="CCR_DB_NLS_CHARACTERSET" VALUE="$dbcharset"/>
__END
  }
  ## include the association information in the oracle_database section

      my $cellHostName = lc($cellHostName);        
      my ($shortCellHostName) = split /\./, $cellHostName;
      my $commonPrefix = &findCommonPrefix($shortCellHostName, $perlShortHostName);
      if(defined $commonPrefix && $commonPrefix ne "")
      {          
        my $dbMachineName = $commonPrefix.".".hostdomain();

        my $exdataGridTargetType = "oracle_exadata_grid";
        my $exdataGridTargetName = "Exadata Grid " . $dbMachineName;
        my $exdataGridTargetId = "exadata_grid_" . $dbMachineName;

          print("<AssocTargetInstance ASSOCIATION_NAME=\"member_of\" ASSOC_TARGET_TYPE=\"$exdataGridTargetType\" ASSOC_TARGET_NAME=\"\" ASSOC_TARGET_PROPERTY=\"$exdataGridTargetId\"/>\n");
       }

print <<__END;
</Target>
__END
  # cell host discovery
  #get kernel version for Cell OS(right now thats the only thing we know about cell host os)
  my $configSet = getCellHostInfoFromDBll($configFile,$cellIp);
  # pass the availabe information to collection scripts in plugin using configSet
  $configSet = $configSet.'|'.$cellId; 
   # collect for cell host also
print <<__END;
  <Target TYPE="host" NAME="$cellHostName" ON_HOST="$cellHostName">
   <Property NAME="OcmProxyOracleHome" VALUE="/opt/oracle/cell"/>
   <Property NAME="Category" VALUE="Cell"/>
   <Property NAME="ConfigSet" VALUE="$configSet"/>
  </Target>
__END

  } 
  }

  ## include DBMachine target if atleaset one cell target is present
  if (keys % myllCELLTargetNames)
  {
     &discoverDbMachineTargetsFromll ($cellHostName,$configFile);
  }

  return (values %llCellTargetNames);
}


## Discover the dbmachine 
sub discoverDbMachineTargetsFromll
{
    my ($cellHostName,$configFile) = @_;
    my $cellHostName = lc($cellHostName);
    my ($shortCellHostName) = split /\./, $cellHostName;

    my $commonPrefix = &findCommonPrefix($shortCellHostName, $perlShortHostName);
    if(defined $commonPrefix && $commonPrefix ne "")
    {
   	my $dbMachineName = $commonPrefix.".".hostdomain();

print <<__END;
  <Target TYPE="oracle_dbmachine" NAME="$dbMachineName" UNIQUE_ID="$dbMachineName" >
  <Property NAME="ConfigFile" VALUE="$configFile"/>
  <Property NAME="ID" VALUE="$dbMachineName"/>
  <Property NAME="OCM_CROSS_HOST" VALUE="TRUE"/>
__END

	my $timestamp = getCollectionTimestamp($configFile);
	if (defined $timestamp && $timestamp ne "")
	{
	
print <<__END;
  <Property NAME="CCR_COLLECTION_TIMESTAMP_OVERRIDE" VALUE="$timestamp"/>
__END
	}
	
print <<__END;
</Target>
__END

#### Adding dbmachine target end    ####

#### Adding Cell group target start ####
my $cellgroupTargetType="oracle_exadata_grid";
my $cellgroupname= "Exadata Grid " . $dbMachineName;
my $cellgroupid = "exadata_grid_" . $dbMachineName;
my $timestamp = getCollectionTimestamp($configFile);
print <<__END;  
<Target TYPE="$cellgroupTargetType" NAME="$cellgroupname" UNIQUE_ID="$cellgroupid" >
  <AssocTargetInstance ASSOCIATION_NAME="member_of"
                       ASSOC_TARGET_TYPE="oracle_dbmachine" 
                       ASSOC_TARGET_NAME=""
                       ASSOC_TARGET_PROPERTY="$dbMachineName" />
  <Property NAME="OCM_CROSS_HOST" VALUE="TRUE"/>
__END

if (defined $timestamp && $timestamp ne "")
{

print <<__END;
  <Property NAME="CCR_COLLECTION_TIMESTAMP_OVERRIDE" VALUE="$timestamp"/>
__END
}
print <<__END;
</Target>
__END
#### Adding Cell group target end ####
	}
	# end of if

}

sub getReleaseVersion()
{
  my ($cellVersion, $releaseVersion) = @_;
  EMD_PERL_DEBUG("++Original release version is $releaseVersion");

####
#  Need to put the conversion logic here
####

  if (!defined $releaseVersion || $releaseVersion eq '')
  {
    if ($cellVersion =~ m/11.2.1.2.1/)
    { # ex. OSS_11.2.1.2.1_LINUX.X64_100131 -->  11.2.1.2.1 
      $releaseVersion = "11.2.1.2.1";
    }
    elsif ($cellVersion =~ m/11.2.1.2.4/)
    { 
      $releaseVersion = "11.2.1.2.4";
    }
    elsif ($cellVersion =~ m/11.2.1.2.6/)
    {
      $releaseVersion = "11.2.1.2.6";
    }
    elsif ($cellVersion =~ m/11.2.0.1.0/)
    { # exception case to regular matching rule
      $releaseVersion = "11.2.1.3.1";
    }
    elsif ($cellVersion =~ m/11.2.2.1.1/)
    {
      $releaseVersion = "11.2.2.1.1";
    }
    elsif ($cellVersion =~ m/11.2.0.3.0/)
    { # exception case to regular matching rule
      $releaseVersion = "11.2.2.2.0";
    }
    elsif ($cellVersion =~ m/11.2.2.2.2/)
    {
      $releaseVersion = "11.2.2.2.2";
    }
  }

  EMD_PERL_DEBUG("++Converted release version is $releaseVersion");

  $releaseVersion;
}

##############################################################################
##                 End of Exadata Discovery Functions                          #
##############################################################################

#Returns the timestamp from the config file
#if there is no error and the value is not empty, return the value  
#otherwise, return empty string
sub getCollectionTimestamp
{
  my ($configFile) = @_;
  my ($err,$value) = getConfigProperty($configFile,"TIMESTAMP");

  EMD_PERL_DEBUG("$LOG_CATEGORY in getCollectionTimestamp for $configFile=$err,$value");
  #if there is no error and the value is not empty, return the value  
  if ($err eq "" && trim($value) ne "")
  {
    return trim($value);
  }

  return "";
}

