#!/usr/local/bin/perl
#
# $Header: emll/sysman/admin/discover/oracle_cminfo_discover.pl /main/2 2009/08/10 13:28:09 snathan Exp $
#
# oracle_cminfo_discover.pl
#
# Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_cminfo_discover.pl - Oracle Contract Manager Discovery Script
#
#    DESCRIPTION
#      Determine whether or not to collect information for Oracle Contract Manager
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    snathan     08/10/09 - Fixed 8743080
#    nmittal     07/03/09 - Creation
#

require "$ENV{CCR_HOME}/sysman/admin/scripts/semd_common.pl";
require "$ENV{CCR_HOME}/sysman/admin/discover/utl/thirdPartyCommon.pl";

use File::Spec;
use File::Basename;
my $CM_HOME="";

  if(get_osType() eq 'WIN')
  {
  my @CM = getWindowsInstalledLocations("Primavera Contract Management 13.0");
	if(CM eq ""){

EMD_PERL_DEBUG("Primavera Contract Manager 13.0 is not installed. not discovering");
	}
	 if (-e $CM[0])
{
    if(-e "$CM[0]/cmocm")
    {
		if (-e "$CM[0]/cmocm/cmEnvironment.properties")
		{
			$CM_HOME=$CM[0];
	                printf ("<Target NAME=\"Oracle Primavera Contract Management\" TYPE=\"oracle_cmenvironment\">\n");
	                print (" <Property NAME=\"CMHOME\" VALUE=\"$CM_HOME\"/>\n");
	                print (" <Property NAME=\"CMENVDUMPFILE\" VALUE=\"cmocm/cmEnvironment.properties\"/>\n");
			print ("</Target>\n");

		 }

		else
	    {
	            EMD_PERL_DEBUG("Primavera Contract Manager configuration properties files does not exists.");
	    }
			if (-e "$CM[0]/cmocm/databaseInformation.properties")
	    {
	    		printf ("<Target NAME=\"Oracle Primavera Contract Management Database Information\" TYPE=\"oracle_cmdatabase\">\n");
                print (" <Property NAME=\"CMHOME\" VALUE=\"$CM_HOME\"/>\n");
                print (" <Property NAME=\"CMDBINFODUMPFILE\" VALUE=\"cmocm/databaseInformation.properties\"/>\n");
                print (" <Property NAME=\"CMDBMETADUMPFILE\" VALUE=\"cmocm/CMDbMetaInfo.properties\"/>\n");
                print (" <Property NAME=\"CMDBVERDUMPFILE\" VALUE=\"cmocm/dbVersion.properties\"/>\n");
		print ("</Target>\n");
	    }
	    else
        {

                EMD_PERL_DEBUG("Primavera Contract Manager database configuration files does not exists. ");
        }
    }
    else
    {

        EMD_PERL_DEBUG("Primavera Contract Manager configuration folder does not exists.");
    }
}
else
{
    EMD_PERL_DEBUG("Primavera Contract Manager does not exists. Not discovering!");
}

}
else

{
EMD_PERL_DEBUG("Contract Manager is Supported only on windows platform. Not discovering!");

}


