#!/usr/local/bin/perl
# 
# oracle_e1_config_discover.pl
# 
# Copyright (c) 2002, 2005, Oracle. All rights reserved.  
#
#    NAME
#
#    DESCRIPTION
#      Discovery script for EnterpriseOne (Former JDEdwards) configuration ('config') data.
#
#    NOTES
#      This script relies on a xml dump file produced by the EnterpriseOne deployment server.
#
#    MODIFIED   (MM/DD/YY)
#    kclearwater 07/20/06 - Creation

($emdRoot,$hostName,$crsHome) = @ARGV;

use File::Spec;
use File::Copy;
use ias::simpleXPath;
use Config;
use constant LIVELINK_HOME => $ENV{CCR_HOME};
require "$emdRoot/sysman/admin/scripts/emd_common.pl";
require "$emdRoot/sysman/admin/discover/utl/e1_util.pl";

EMD_PERL_DEBUG("oracle_e1_config_discover START");

#windows check.  'config' is windows only
my $OSNAME = $Config{'osname'};
my $IsWin32 = ($OSNAME eq 'MSWin32');
    
my $win32SystemDirectory = " ";

#Get system directory for windows.  Deployment Server doesn't know where
#CCR is installed so a common, known location for the dump file is needed.  The WIN32 API
#GetSystemDirectory() called in C++ (via solution explorer) and perl's $ENV{SystemRoot} called
#(via CCR) will find the same folder location.  Deployment Server is always windows OS.

if($IsWin32)
{
    $win32SystemDirectory = $ENV{SystemRoot}."\\";
    
    if ($win32SystemDirectory eq " ")
    {
        EMD_PERL_DEBUG("Windows %SystemRoot% not available.");    
    }
    else
    {
        my @files = getE1CCRDumpFiles($win32SystemDirectory, "config");
        foreach my $file (@files)
        {
        
            my $fileNamePath = File::Spec->catdir($win32SystemDirectory, $file);
         
            if( -f $fileNamePath)
            {
                # config file found.
                my @topLevelComponents = simpleXPathQuery($fileNamePath, "oracle_e1/config");
                for my $topLevelComponent (@topLevelComponents)
                {
                    my $release = $$topLevelComponent{'release'};
                    my $sp = $$topLevelComponent{'servicepack'};
                    
                    EMD_PERL_DEBUG("oracle_e1_config target found");
                    print  "<Target TYPE=\"oracle_e1_config\" NAME=\"$release\_$sp\" >\n";
                    print  "  <Property NAME=\"E1DumpFile\" VALUE=\"$fileNamePath\" />\n";
                    print  "</Target>\n";
                    
                }
            }
        }
    }
}
else
{
    EMD_PERL_DEBUG("E1 Dumpfile of type config can only be on windows OS.");
}

EMD_PERL_DEBUG("oracle_e1_config_discover END");




