#!/usr/local/bin/perl
# 
# oracle_e1_scf_mc_discover.pl
# 
# Copyright (c) 2002, 2005, Oracle. All rights reserved.  
#
#    NAME
#
#    DESCRIPTION
#      Discovery script for EnterpriseOne (Former JDEdwards) Server Configuration Framework/Management Console ('scf_mc') data.
#
#    NOTES
#      This script relies on a xml dump file produced by the Management Console.
#
#    MODIFIED   (MM/DD/YY)
#    kclearwater 10/11/06 - Creation

($emdRoot,$hostName,$crsHome) = @ARGV;

use File::Spec;
use File::Copy;
use ias::simpleXPath;
use Config;
use constant LIVELINK_HOME => $ENV{CCR_HOME};
require "$emdRoot/sysman/admin/scripts/emd_common.pl";
require "$emdRoot/sysman/admin/discover/utl/e1_util.pl";

EMD_PERL_DEBUG("oracle_e1_scf_mc_discover START");

#windows check.  'scf_mc' is windows only
my $OSNAME = $Config{'osname'};
my $IsWin32 = ($OSNAME eq 'MSWin32');
    
#Management Console is always windows OS.

if($IsWin32)
{
        #Looking for dumpfile in ccr directory because we need the dumpfile created before CCR installs and therefore state will not exist yet.
        #my $dumpFileLocation = File::Spec->catdir($emdRoot, "state");
        my $dumpFileLocation = $emdRoot;
        
        my @files = getE1CCRDumpFiles($dumpFileLocation, "scf_mc");
        foreach my $file (@files)
        {
        
            my $fileNamePath = File::Spec->catdir($dumpFileLocation, $file);
         
            if( -f $fileNamePath)
            {
                # scf_mc file found.
                my @topLevelComponents = simpleXPathQuery($fileNamePath, "oracle_e1/scf_mc/agents/agent");
                for my $topLevelComponent (@topLevelComponents)
                {
                    
                    my $Agentlocation = $$topLevelComponent{'AGINLOC'};
                   
                    EMD_PERL_DEBUG("oracle_e1_config target found");
                    print  "<Target TYPE=\"oracle_e1_scf_mc\" NAME=\"$Agentlocation\" >\n";
                    print  "  <Property NAME=\"E1DumpFile\" VALUE=\"$fileNamePath\" />\n";
                    print  "</Target>\n";
                    
                }
            }
        }
    
}
else
{
    EMD_PERL_DEBUG("E1 Dumpfile of type config can only be on windows OS.");
}

EMD_PERL_DEBUG("oracle_e1_scf_mc_discover END");



